/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.woodcutter.helper;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import ovh.corail.woodcutter.config.ConfigWoodcutter;
import ovh.corail.woodcutter.config.CustomConfig;
import ovh.corail.woodcutter.recipe.WoodcuttingRecipe;
import ovh.corail.woodcutter.registry.ModBlocks;
import ovh.corail.woodcutter.registry.ModRecipeTypes;

@Mod.EventBusSubscriber(modid="corail_woodcutter", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class Helper {
    public static final Comparator<Recipe<Container>> recipeComparator = (r1, r2) -> {
        String[] name2;
        ResourceLocation registryName1 = r1.m_8043_().m_41720_().getRegistryName();
        ResourceLocation registryName2 = r2.m_8043_().m_41720_().getRegistryName();
        assert (registryName1 != null && registryName2 != null);
        String[] name1 = registryName1.m_135815_().split("_");
        int comp = name1[name1.length - 1].compareTo((name2 = registryName2.m_135815_().split("_"))[name2.length - 1]);
        return comp == 0 ? registryName1.compareTo(registryName2) : comp;
    };

    public static void initItemModels() {
        ModBlocks.WOODCUTTERS.forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
    }

    public static void registerSharedConfig() {
        ModLoadingContext ctx = ModLoadingContext.get();
        ctx.getActiveContainer().addConfig((ModConfig)new CustomConfig(ConfigWoodcutter.GENERAL_SPEC, ctx.getActiveContainer()));
    }

    public static List<WoodcuttingRecipe> getSortedMatchingRecipes(Level level, Container inventory) {
        return level.m_7465_().m_44054_(ModRecipeTypes.WOODCUTTING).values().stream().flatMap(recipe -> Util.m_137519_((Optional)ModRecipeTypes.WOODCUTTING.m_44115_(recipe, level, inventory))).sorted(recipeComparator).toList();
    }
}

