/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.recipe.type.InventoryFluid;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasin;
import org.cyclops.integrateddynamics.block.BlockMechanicalDryingBasinConfig;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerDryingBasin;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalDryingBasin;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalDryingBasin;

public class BlockEntityMechanicalDryingBasin
extends BlockEntityMechanicalMachine<Pair<ItemStack, FluidStack>, RecipeMechanicalDryingBasin>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private final SingleUseTank tankIn = new SingleUseTank(10000);
    private final SingleUseTank tankOut = new SingleUseTank(100000);

    public BlockEntityMechanicalDryingBasin(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_MECHANICAL_DRYING_BASIN, blockPos, blockState, 5);
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.UP, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.DOWN, LazyOptional.of(() -> this.tankOut));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.NORTH, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.SOUTH, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.WEST, LazyOptional.of(() -> this.tankIn));
        this.addCapabilitySided(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, Direction.EAST, LazyOptional.of(() -> this.tankIn));
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerDryingBasin(() -> ((BlockEntityMechanicalDryingBasin)this).m_58904_())));
        this.tankIn.addDirtyMarkListener(this::onTankChanged);
        this.tankOut.addDirtyMarkListener(this::onTankChanged);
    }

    @Override
    protected SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeMechanicalDryingBasin>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<Pair<ItemStack, FluidStack>, Optional<RecipeMechanicalDryingBasin>>(){

            public Optional<RecipeMechanicalDryingBasin> getNewValue(Pair<ItemStack, FluidStack> key) {
                InventoryFluid recipeInput = new InventoryFluid(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)key.getLeft()}), NonNullList.m_122783_((Object)FluidStack.EMPTY, (Object[])new FluidStack[]{(FluidStack)key.getRight()}));
                return CraftingHelpers.findServerRecipe(BlockEntityMechanicalDryingBasin.this.getRecipeRegistry(), (Container)recipeInput, (Level)BlockEntityMechanicalDryingBasin.this.m_58904_());
            }

            public boolean isKeyEqual(Pair<ItemStack, FluidStack> cacheKey, Pair<ItemStack, FluidStack> newKey) {
                return cacheKey == null || newKey == null || ItemStack.m_41728_((ItemStack)((ItemStack)cacheKey.getLeft()), (ItemStack)((ItemStack)newKey.getLeft())) && FluidStack.areFluidStackTagsEqual((FluidStack)((FluidStack)cacheKey.getRight()), (FluidStack)((FluidStack)newKey.getRight())) && FluidHelpers.getAmount((FluidStack)((FluidStack)cacheKey.getRight())) == FluidHelpers.getAmount((FluidStack)((FluidStack)newKey.getRight()));
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)BlockMechanicalDryingBasin.LIT);
    }

    @Override
    public void setWorking(boolean working) {
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)BlockMechanicalDryingBasin.LIT, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTankInput() {
        return this.tankIn;
    }

    public SingleUseTank getTankOutput() {
        return this.tankOut;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        this.getTankInput().readFromNBT(tag.m_128469_("tankIn"));
        this.getTankOutput().readFromNBT(tag.m_128469_("tankOut"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("tankIn", (Tag)this.getTankInput().writeToNBT(new CompoundTag()));
        tag.m_128365_("tankOut", (Tag)this.getTankOutput().writeToNBT(new CompoundTag()));
        super.m_183515_(tag);
    }

    @Override
    protected RecipeType<RecipeMechanicalDryingBasin> getRecipeRegistry() {
        return RegistryEntries.RECIPETYPE_MECHANICAL_DRYING_BASIN;
    }

    @Override
    protected Pair<ItemStack, FluidStack> getCurrentRecipeCacheKey() {
        return Pair.of((Object)this.getInventory().m_8020_(0).m_41777_(), (Object)FluidHelpers.copy((FluidStack)this.getTankInput().getFluid()));
    }

    @Override
    public int getRecipeDuration(RecipeMechanicalDryingBasin recipe) {
        return recipe.getDuration();
    }

    @Override
    protected boolean finalizeRecipe(RecipeMechanicalDryingBasin recipe, boolean simulate) {
        FluidStack inputFluid;
        IFluidHandler.FluidAction fluidAction = FluidHelpers.simulateBooleanToAction((boolean)simulate);
        ItemStack outputStack = recipe.getOutputItem().m_41777_();
        if (!outputStack.m_41619_() && !InventoryHelpers.addToInventory((Container)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)NonNullList.m_122780_((int)1, (Object)outputStack), (boolean)simulate).isEmpty()) {
            return false;
        }
        FluidStack outputFluid = recipe.getOutputFluid();
        if (outputFluid != null && this.getTankOutput().fill(outputFluid.copy(), fluidAction) != outputFluid.getAmount()) {
            return false;
        }
        if (!simulate && !recipe.getInputIngredient().m_43947_()) {
            this.getInventory().m_7407_(0, 1);
        }
        return (inputFluid = recipe.getInputFluid()) == null || FluidHelpers.getAmount((FluidStack)this.getTankInput().drain(inputFluid, fluidAction)) == inputFluid.getAmount();
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalDryingBasinConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalDryingBasinConfig.capacity;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerMechanicalDryingBasin(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return new TranslatableComponent("block.integrateddynamics.mechanical_drying_basin");
    }
}

