/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonText;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenScrolling;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.container.DisplayErrorsComponent;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipartAspects;

public abstract class ContainerScreenMultipartAspects<P extends IPartType<P, S>, S extends IPartState<P>, A extends IAspect, C extends ContainerMultipartAspects<P, S, A>>
extends ContainerScreenScrolling<C> {
    private static final Rectangle ITEM_POSITION = new Rectangle(8, 17, 18, 18);
    protected final DisplayErrorsComponent displayErrors = new DisplayErrorsComponent();
    private Map<IAspect, ButtonText> aspectPropertyButtons = Maps.newHashMap();

    public ContainerScreenMultipartAspects(C container, Inventory inventory, Component title) {
        super(container, inventory, title);
    }

    protected Rectangle getScrollRegion() {
        return new Rectangle(this.f_97735_ + 9, this.f_97736_ + 18, 160, 105);
    }

    public void m_7856_() {
        this.m_169413_();
        super.m_7856_();
        if (((ContainerMultipartAspects)this.m_6262_()).getPartType().getContainerProviderSettings(null).isPresent()) {
            this.m_142416_((GuiEventListener)new ButtonImage(this.f_97735_ + 174, this.f_97736_ + 4, 15, 15, (Component)new TranslatableComponent("gui.integrateddynamics.partsettings"), this.createServerPressable(ContainerMultipartAspects.BUTTON_SETTINGS, b -> {}), true, (IImage)Images.CONFIG_BOARD, -2, -3));
        }
        for (Map.Entry<IAspect, String> entry : ((ContainerMultipartAspects)this.m_6262_()).getAspectPropertyButtons().entrySet()) {
            ButtonText button = new ButtonText(-20, -20, 10, 10, (Component)new TranslatableComponent("gui.integrateddynamics.aspect_settings"), (Component)new TextComponent("+"), this.createServerPressable(entry.getValue(), b -> {}), true);
            this.aspectPropertyButtons.put(entry.getKey(), button);
            this.m_142416_((GuiEventListener)button);
        }
    }

    protected abstract String getNameId();

    protected ResourceLocation constructGuiTexture() {
        return new ResourceLocation("integrateddynamics", "textures/gui/" + this.getNameId() + ".png");
    }

    protected float colorSmoothener(float color) {
        return 1.0f - (1.0f - color) / 4.0f;
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(matrixStack, partialTicks, mouseX, mouseY);
        for (Map.Entry<IAspect, ButtonText> entry : this.aspectPropertyButtons.entrySet()) {
            entry.getValue().f_93620_ = -20;
            entry.getValue().f_93621_ = -20;
        }
        RenderHelpers.drawScaledCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (String)this.f_96539_.getString(), (int)(this.f_97735_ + this.offsetX + 6), (int)(this.f_97736_ + this.offsetY + 10), (int)70, (int)0x404040);
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.m_6262_();
        int aspectBoxHeight = container.getAspectBoxHeight();
        for (int i = 0; i < container.getPageSize(); ++i) {
            if (!container.isElementVisible(i)) continue;
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            Triple rgb = Helpers.intToRGB((int)aspect.getValueType().getDisplayColor());
            RenderSystem.m_157429_((float)this.colorSmoothener(((Float)rgb.getLeft()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getMiddle()).floatValue()), (float)this.colorSmoothener(((Float)rgb.getRight()).floatValue()), (float)1.0f);
            RenderHelpers.bindTexture((ResourceLocation)this.texture);
            this.m_93228_(matrixStack, this.f_97735_ + this.offsetX + 9, this.f_97736_ + this.offsetY + 18 + aspectBoxHeight * i, 0, this.getBaseYSize(), 160, aspectBoxHeight - 1);
            String aspectName = L10NHelpers.localize((String)aspect.getTranslationKey(), (Object[])new Object[0]);
            RenderHelpers.drawScaledCenteredString((PoseStack)matrixStack, (Font)this.f_96547_, (String)aspectName, (int)(this.f_97735_ + this.offsetX + 26), (int)(this.f_97736_ + this.offsetY + 25 + aspectBoxHeight * i), (int)this.getMaxLabelWidth(), (int)Helpers.RGBToInt((int)40, (int)40, (int)40));
            this.drawAdditionalElementInfo(matrixStack, container, i, aspect);
            if (!this.aspectPropertyButtons.containsKey(aspect)) continue;
            ButtonText button = this.aspectPropertyButtons.get(aspect);
            button.f_93620_ = this.f_97735_ + this.offsetX + 116;
            button.f_93621_ = this.f_97736_ + this.offsetY + 20 + aspectBoxHeight * i;
        }
    }

    protected abstract void drawAdditionalElementInfo(PoseStack var1, C var2, int var3, A var4);

    protected Rectangle getElementPosition(C container, int i, boolean absolute) {
        return new Rectangle(ContainerScreenMultipartAspects.ITEM_POSITION.x + this.offsetX + (absolute ? this.f_97735_ : 0), ContainerScreenMultipartAspects.ITEM_POSITION.y + ((ContainerMultipartAspects)((Object)container)).getAspectBoxHeight() * i + this.offsetY + (absolute ? this.f_97736_ : 0), ContainerScreenMultipartAspects.ITEM_POSITION.width, ContainerScreenMultipartAspects.ITEM_POSITION.height);
    }

    protected void m_7027_(PoseStack matrixStack, int mouseX, int mouseY) {
        ContainerMultipartAspects container = (ContainerMultipartAspects)this.m_6262_();
        for (int i = 0; i < container.getPageSize(); ++i) {
            int y;
            ButtonText button;
            int x;
            if (!container.isElementVisible(i)) continue;
            if (this.isPointInRegion(this.getElementPosition(container, i, false), new Point(mouseX, mouseY))) {
                LinkedList lines = Lists.newLinkedList();
                ((IAspect)container.getVisibleElement(i)).loadTooltip(lines, true);
                this.drawTooltip(lines, matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
            }
            this.drawAdditionalElementInfoForeground(matrixStack, container, i, (IAspect)container.getVisibleElement(i), mouseX, mouseY);
            IAspect aspect = (IAspect)container.getVisibleElement(i);
            if (!this.aspectPropertyButtons.containsKey(aspect) || !this.m_6774_(x = button.f_93620_ - this.f_97735_, y = button.f_93621_ - this.f_97736_, (button = this.aspectPropertyButtons.get(aspect)).m_5711_(), button.m_93694_(), mouseX, mouseY)) continue;
            LinkedList lines = Lists.newLinkedList();
            lines.add(new TranslatableComponent("gui.integrateddynamics.part.properties").m_130940_(ChatFormatting.WHITE));
            for (IAspectPropertyTypeInstance property : aspect.getPropertyTypes()) {
                lines.add(new TextComponent("-").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)new TranslatableComponent(property.getTranslationKey())));
            }
            this.drawTooltip(lines, matrixStack, mouseX - this.f_97735_, mouseY - this.f_97736_);
        }
    }

    protected abstract void drawAdditionalElementInfoForeground(PoseStack var1, C var2, int var3, A var4, int var5, int var6);

    public int getMaxLabelWidth() {
        return 63;
    }
}

