/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class WrenchHelpers {
    public static final ResourceLocation TAG_WRENCH = new ResourceLocation("forge", "tools/wrench");

    public static boolean isWrench(Player player, ItemStack heldItem, Level world, BlockPos pos, @Nullable Direction side) {
        return heldItem.m_41720_().getTags().contains(TAG_WRENCH);
    }

    public static <P> void wrench(Player player, ItemStack heldItem, Level world, BlockPos pos, Direction side, IWrenchAction<P> action, P parameter) {
        if (WrenchHelpers.isWrench(player, heldItem, world, pos, side)) {
            action.onWrench(player, pos, parameter);
        }
    }

    public static void wrench(Player player, ItemStack heldItem, Level world, BlockPos pos, Direction side, IWrenchAction<Void> action) {
        WrenchHelpers.wrench(player, heldItem, world, pos, side, action, null);
    }

    public static interface IWrenchAction<P> {
        public void onWrench(Player var1, BlockPos var2, P var3);
    }

    public static abstract class SimpleWrenchAction
    implements IWrenchAction<Void> {
        @Override
        public void onWrench(Player player, BlockPos pos, Void parameter) {
            this.onWrench(player, pos);
        }

        public abstract void onWrench(Player var1, BlockPos var2);
    }
}

