/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import java.util.Random;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IAspectVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectRead;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class AspectVariableFacade
extends VariableFacadeBase
implements IAspectVariableFacade {
    private final int partId;
    private final IAspect aspect;

    public AspectVariableFacade(boolean generateId, int partId, IAspect aspect) {
        super(generateId);
        this.partId = partId;
        this.aspect = aspect;
    }

    public AspectVariableFacade(int id, int partId, IAspect aspect) {
        super(id);
        this.partId = partId;
        this.aspect = aspect;
    }

    @Override
    public <V extends IValue> IVariable<V> getVariable(IPartNetwork network) {
        if (this.isValid() && this.getAspect() instanceof IAspectRead && network.hasPartVariable(this.getPartId(), (IAspectRead)this.getAspect())) {
            return network.getPartVariable(this.getPartId(), (IAspectRead)this.getAspect());
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.getPartId() >= 0 && this.getAspect() != null;
    }

    @Override
    public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
        if (!this.isValid()) {
            validator.addError((MutableComponent)new TranslatableComponent("variable.integrateddynamics.error.invalid_item"));
        } else if (!(this.getAspect() instanceof IAspectRead) || !network.hasPartVariable(this.getPartId(), (IAspectRead)this.getAspect())) {
            validator.addError((MutableComponent)new TranslatableComponent("variable.integrateddynamics.error.part_not_in_network", new Object[]{Integer.toString(this.getPartId())}));
        } else if (!ValueHelpers.correspondsTo(containingValueType, this.getAspect().getValueType())) {
            validator.addError((MutableComponent)new TranslatableComponent("aspect.integrateddynamics.error.invalid_type", new Object[]{new TranslatableComponent(containingValueType.getTranslationKey()), new TranslatableComponent(this.getAspect().getValueType().getTranslationKey())}));
        }
    }

    @Override
    public IValueType getOutputType() {
        IAspect aspect = this.getAspect();
        if (aspect == null) {
            return null;
        }
        return aspect.getValueType();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(List<Component> list, Level world) {
        if (this.isValid()) {
            this.getAspect().loadTooltip(list, false);
            list.add((Component)new TranslatableComponent("aspect.integrateddynamics.tooltip.part_id", new Object[]{this.getPartId()}));
        }
        super.appendHoverText(list, world);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads, Random random, IModelData modelData) {
        if (this.isValid()) {
            IAspect aspect = this.getAspect();
            Object valueType = aspect.getValueType();
            quads.addAll(variableModelBaked.getSubModels(VariableModelProviders.VALUETYPE).getBakedModels().get(valueType).getQuads(null, null, random, modelData));
            quads.addAll(variableModelBaked.getSubModels(VariableModelProviders.ASPECT).getBakedModels().get(aspect).getQuads(null, null, random, modelData));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AspectVariableFacade)) {
            return false;
        }
        AspectVariableFacade other = (AspectVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPartId() != other.getPartId()) {
            return false;
        }
        IAspect this$aspect = this.getAspect();
        IAspect other$aspect = other.getAspect();
        return !(this$aspect == null ? other$aspect != null : !this$aspect.equals(other$aspect));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AspectVariableFacade;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPartId();
        IAspect $aspect = this.getAspect();
        result = result * 59 + ($aspect == null ? 43 : $aspect.hashCode());
        return result;
    }

    @Override
    public int getPartId() {
        return this.partId;
    }

    @Override
    public IAspect getAspect() {
        return this.aspect;
    }

    @Override
    public String toString() {
        return "AspectVariableFacade(partId=" + this.getPartId() + ", aspect=" + this.getAspect() + ")";
    }
}

