/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import java.util.Locale;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.item.IInformationProvider;
import org.cyclops.cyclopscore.item.ItemBlockNBT;
import org.cyclops.cyclopscore.modcompat.capabilities.DefaultCapabilityProvider;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.capability.energystorage.EnergyStorageItemBlockEnergyContainer;

public class ItemBlockEnergyContainer
extends ItemBlockNBT {
    private IEnergyContainerBlock block;

    public ItemBlockEnergyContainer(Block block, Item.Properties builder) {
        super(block, builder);
        this.block = (IEnergyContainerBlock)block;
    }

    public IEnergyContainerBlock get() {
        return this.block;
    }

    public LazyOptional<IEnergyStorage> getEnergyBattery(ItemStack itemStack) {
        if (CapabilityEnergy.ENERGY == null) {
            return LazyOptional.of(() -> this.createCapability(itemStack));
        }
        return itemStack.getCapability(CapabilityEnergy.ENERGY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemStack, world, list, flag);
        this.getEnergyBattery(itemStack).ifPresent(energyStorage -> {
            int amount = energyStorage.getEnergyStored();
            int capacity = energyStorage.getMaxEnergyStored();
            String line = String.format(Locale.ROOT, "%,d", amount) + " / " + String.format(Locale.ROOT, "%,d", capacity) + " " + L10NHelpers.localize((String)"general.integrateddynamics.energy_unit", (Object[])new Object[0]);
            list.add((Component)new TextComponent(IInformationProvider.ITEM_PREFIX + line));
        });
    }

    public boolean m_142522_(ItemStack stack) {
        return true;
    }

    public int m_142158_(ItemStack itemStack) {
        return this.getEnergyBattery(itemStack).map(energyStorage -> {
            double amount = energyStorage.getEnergyStored();
            double capacity = energyStorage.getMaxEnergyStored();
            return (int)Math.round(amount / capacity * 13.0);
        }).orElse(0);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)(Math.max(0.0f, (float)this.m_142158_(stack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }

    protected EnergyStorageItemBlockEnergyContainer createCapability(ItemStack itemStack) {
        return new EnergyStorageItemBlockEnergyContainer(this, itemStack){

            @Override
            public int getRate() {
                return BlockEntityEnergyBattery.getEnergyPerTick(this.getMaxEnergyStored());
            }
        };
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return new DefaultCapabilityProvider(() -> CapabilityEnergy.ENERGY, LazyOptional.of(() -> this.createCapability(stack)));
    }
}

