/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.block.cable.ICableFakeable;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.helper.CableHelpers;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.item.ItemBlockCable;

public class ItemPart<P extends IPartType<P, S>, S extends IPartState<P>>
extends Item {
    private static final List<IUseAction> USE_ACTIONS = Lists.newArrayList();
    private final IPartType<P, S> part;

    public ItemPart(Item.Properties properties, IPartType<P, S> part) {
        super(properties);
        this.part = part;
    }

    public IPartType<P, S> getPart() {
        return this.part;
    }

    public String m_5524_() {
        return this.part.getTranslationKey();
    }

    public String m_5671_(ItemStack stack) {
        return this.part.getTranslationKey();
    }

    public static void addUseAction(IUseAction useAction) {
        USE_ACTIONS.add(useAction);
    }

    public Component m_7626_(ItemStack p_200295_1_) {
        return new TranslatableComponent(this.m_5524_());
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        BlockPos pos = context.m_8083_();
        Direction side = context.m_43719_();
        ItemStack itemStack = player.m_21120_(hand);
        IPartContainer partContainerFirst = (IPartContainer)PartHelpers.getPartContainer((BlockGetter)world, pos, side).orElse(null);
        if (partContainerFirst != null) {
            if (PartHelpers.addPart(world, pos, side, this.getPart(), itemStack)) {
                if (world.m_5776_()) {
                    ItemBlockCable.playPlaceSound(world, pos);
                }
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        BlockPos target = pos.m_142300_(side);
        Direction targetSide = side.m_122424_();
        BlockHitResult targetRayTrace = new BlockHitResult(new Vec3((double)target.m_123341_() + 0.5 + (double)targetSide.m_122429_() * 0.5, (double)target.m_123342_() + 0.5 + (double)targetSide.m_122430_() * 0.5, (double)target.m_123343_() + 0.5 + (double)targetSide.m_122431_() * 0.5), targetSide, target, false);
        if (world.m_8055_(target).m_60734_().m_6864_(world.m_8055_(target), new BlockPlaceContext(world, player, hand, itemStack, targetRayTrace))) {
            IPartContainer partContainer;
            ItemBlockCable itemBlockCable = (ItemBlockCable)Item.m_41439_((Block)RegistryEntries.BLOCK_CABLE);
            itemStack.m_41769_(1);
            if (itemBlockCable.m_6225_(new UseOnContext(player, hand, targetRayTrace)).m_19077_() && (partContainer = (IPartContainer)PartHelpers.getPartContainer((BlockGetter)world, target, targetSide).orElse(null)) != null) {
                ICableFakeable cableFakeable = (ICableFakeable)CableHelpers.getCableFakeable((BlockGetter)world, target, targetSide).orElse(null);
                if (!world.m_5776_()) {
                    PartHelpers.addPart(world, target, side.m_122424_(), this.getPart(), itemStack);
                    if (cableFakeable != null) {
                        CableHelpers.onCableRemoving(world, target, false, false);
                        cableFakeable.setRealCable(false);
                        CableHelpers.onCableRemoved(world, target, CableHelpers.ALL_SIDES);
                    } else {
                        IntegratedDynamics.clog(org.apache.logging.log4j.Level.WARN, String.format("Tried to set a fake cable at a block that is not fakeable at %s", target));
                    }
                } else {
                    cableFakeable.setRealCable(false);
                }
                itemStack.m_41774_(1);
                return InteractionResult.SUCCESS;
            }
            itemStack.m_41774_(1);
        } else {
            IPartContainer partContainer = (IPartContainer)PartHelpers.getPartContainer((BlockGetter)world, target, targetSide).orElse(null);
            if (partContainer != null) {
                if (!world.m_5776_() && NetworkHelpers.getNetwork(PartPos.of(world, pos, side)).isPresent() && partContainer.canAddPart(targetSide, this.getPart())) {
                    CableHelpers.getCable((BlockGetter)world, target, targetSide).ifPresent(cable -> CableHelpers.disconnectCable(world, target, targetSide, cable, targetSide));
                }
                if (PartHelpers.addPart(world, target, side.m_122424_(), this.getPart(), itemStack)) {
                    if (world.m_5776_()) {
                        ItemBlockCable.playPlaceSound(world, target);
                    }
                    if (!player.m_7500_()) {
                        itemStack.m_41774_(1);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        for (IUseAction useAction : USE_ACTIONS) {
            if (!useAction.attempItemUseTarget(this, itemStack, world, pos, side)) continue;
            return InteractionResult.SUCCESS;
        }
        return super.m_6225_(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack itemStack, Level world, List<Component> list, TooltipFlag flag) {
        if (itemStack.m_41783_() != null && itemStack.m_41783_().m_128425_("id", 3)) {
            int id = itemStack.m_41783_().m_128451_("id");
            list.add((Component)new TranslatableComponent("item.integrateddynamics.general.id", new Object[]{id}));
        }
        this.getPart().loadTooltip(itemStack, list);
        super.m_7373_(itemStack, world, list, flag);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ItemPart)) {
            return false;
        }
        ItemPart other = (ItemPart)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        IPartType<P, S> this$part = this.getPart();
        IPartType<P, S> other$part = other.getPart();
        return !(this$part == null ? other$part != null : !this$part.equals(other$part));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ItemPart;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IPartType<P, S> $part = this.getPart();
        result = result * 59 + ($part == null ? 43 : $part.hashCode());
        return result;
    }

    public static interface IUseAction {
        public boolean attempItemUseTarget(ItemPart var1, ItemStack var2, Level var3, BlockPos var4, Direction var5);
    }
}

