/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeDryingBasin;

public class RecipeSerializerDryingBasin
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RecipeDryingBasin> {
    public RecipeDryingBasin fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)false);
        FluidStack inputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)json, (String)"fluid", (boolean)false);
        ItemStack outputItemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)result, (boolean)false, GeneralConfig.recipeTagOutputModPriorities);
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        int duration = GsonHelper.m_13927_((JsonObject)json, (String)"duration");
        if (inputIngredient.m_43947_() && inputFluid.isEmpty()) {
            throw new JsonSyntaxException("An input item or fluid is required");
        }
        if (outputItemStack.m_41619_() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        if (!inputFluid.isEmpty() && !outputFluid.isEmpty()) {
            throw new JsonSyntaxException("Can't have both an input and output fluid");
        }
        if (duration <= 0) {
            throw new JsonSyntaxException("Durations must be higher than one tick");
        }
        return new RecipeDryingBasin(recipeId, inputIngredient, inputFluid, outputItemStack, outputFluid, duration);
    }

    @Nullable
    public RecipeDryingBasin fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        FluidStack inputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        ItemStack outputItemStack = buffer.m_130267_();
        FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        int duration = buffer.m_130242_();
        return new RecipeDryingBasin(recipeId, inputIngredient, inputFluid, outputItemStack, outputFluid, duration);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeDryingBasin recipe) {
        recipe.getInputIngredient().m_43923_(buffer);
        recipe.getInputFluid().writeToPacket(buffer);
        buffer.m_130055_(recipe.getOutputItem());
        recipe.getOutputFluid().writeToPacket(buffer);
        buffer.m_130130_(recipe.getDuration());
    }
}

