/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.cyclops.cyclopscore.helper.RecipeSerializerHelpers;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RecipeSerializerSqueezer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RecipeSqueezer> {
    protected static RecipeSqueezer.ItemStackChance getJsonItemStackChance(JsonObject json) {
        ItemStack itemStack = RecipeSerializerHelpers.getJsonItemStackOrTag((JsonObject)json, (boolean)true, GeneralConfig.recipeTagOutputModPriorities);
        float chance = GsonHelper.m_13820_((JsonObject)json, (String)"chance", (float)1.0f);
        return new RecipeSqueezer.ItemStackChance(itemStack, chance);
    }

    protected static NonNullList<RecipeSqueezer.ItemStackChance> getJsonItemStackChances(JsonObject json, String key) {
        JsonElement element = json.get(key);
        if (element == null) {
            return NonNullList.m_122779_();
        }
        if (element.isJsonArray()) {
            JsonArray jsonElements = element.getAsJsonArray();
            NonNullList elements = NonNullList.m_122779_();
            for (JsonElement jsonElement : jsonElements) {
                elements.add((Object)RecipeSerializerSqueezer.getJsonItemStackChance(jsonElement.getAsJsonObject()));
            }
            return elements;
        }
        throw new JsonSyntaxException("A JSON array is required as value for " + key);
    }

    public RecipeSqueezer fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        Ingredient inputIngredient = RecipeSerializerHelpers.getJsonIngredient((JsonObject)json, (String)"item", (boolean)true);
        NonNullList<RecipeSqueezer.ItemStackChance> outputItemStacks = RecipeSerializerSqueezer.getJsonItemStackChances(result, "items");
        FluidStack outputFluid = RecipeSerializerHelpers.getJsonFluidStack((JsonObject)result, (String)"fluid", (boolean)false);
        if (inputIngredient.m_43947_()) {
            throw new JsonSyntaxException("An input item is required");
        }
        if (outputItemStacks.isEmpty() && outputFluid.isEmpty()) {
            throw new JsonSyntaxException("An output item or fluid is required");
        }
        return new RecipeSqueezer(recipeId, inputIngredient, outputItemStacks, outputFluid);
    }

    @Nullable
    public RecipeSqueezer fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        Ingredient inputIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        NonNullList outputItemStacks = NonNullList.m_122779_();
        int outputItemStacksCount = buffer.readInt();
        for (int i = 0; i < outputItemStacksCount; ++i) {
            outputItemStacks.add((Object)new RecipeSqueezer.ItemStackChance(buffer.m_130267_(), buffer.readFloat()));
        }
        FluidStack outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        return new RecipeSqueezer(recipeId, inputIngredient, (NonNullList<RecipeSqueezer.ItemStackChance>)outputItemStacks, outputFluid);
    }

    public void toNetwork(FriendlyByteBuf buffer, RecipeSqueezer recipe) {
        recipe.getInputIngredient().m_43923_(buffer);
        buffer.writeInt(recipe.getOutputItems().size());
        for (RecipeSqueezer.ItemStackChance outputItem : recipe.getOutputItems()) {
            buffer.m_130055_(outputItem.getItemStack());
            buffer.writeFloat(outputItem.getChance());
        }
        recipe.getOutputFluid().writeToPacket(buffer);
    }
}

