/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.integrateddynamics.RegistryEntries;

public class RecipeSqueezer
implements Recipe<Container> {
    private final ResourceLocation id;
    private final Ingredient inputIngredient;
    private final NonNullList<ItemStackChance> outputItems;
    private final FluidStack outputFluid;

    public RecipeSqueezer(ResourceLocation id, Ingredient inputIngredient, NonNullList<ItemStackChance> outputItems, FluidStack outputFluid) {
        this.id = id;
        this.inputIngredient = inputIngredient;
        this.outputItems = outputItems;
        this.outputFluid = outputFluid;
    }

    public Ingredient getInputIngredient() {
        return this.inputIngredient;
    }

    public NonNullList<ItemStackChance> getOutputItems() {
        return this.outputItems;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public boolean m_5818_(Container inv, Level worldIn) {
        return this.inputIngredient.test(inv.m_8020_(0));
    }

    public ItemStack m_5874_(Container inv) {
        if (this.outputItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((ItemStackChance)this.outputItems.get(0)).getItemStack().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return width * height <= 1;
    }

    public ItemStack m_8043_() {
        if (this.outputItems.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return ((ItemStackChance)this.outputItems.get(0)).getItemStack().m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_SQUEEZER;
    }

    public RecipeType<?> m_6671_() {
        return RegistryEntries.RECIPETYPE_SQUEEZER;
    }

    public static class ItemStackChance {
        private final ItemStack itemStack;
        private final float chance;

        public ItemStackChance(ItemStack itemStack, float chance) {
            this.itemStack = Objects.requireNonNull(itemStack);
            this.chance = chance;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public float getChance() {
            return this.chance;
        }
    }
}

