/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.item;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.cyclops.cyclopscore.inventory.container.NamedContainerProviderItem;
import org.cyclops.cyclopscore.item.ItemGui;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.entity.item.EntityItemTargetted;
import org.cyclops.integrateddynamics.inventory.container.ContainerOnTheDynamicsOfIntegration;
import org.cyclops.integrateddynamics.item.ItemOnTheDynamicsOfIntegrationConfig;

public class ItemOnTheDynamicsOfIntegration
extends ItemGui {
    private static final int SPAWN_RANGE = 25;
    private static final String NBT_INFOBOOK_SPAWNED = "integrateddynamics:infoBookSpawned";

    public ItemOnTheDynamicsOfIntegration(Item.Properties properties) {
        super(properties);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLoggedIn);
    }

    @Nullable
    public MenuProvider getContainer(Level world, Player playerEntity, int itemIndex, InteractionHand hand, ItemStack itemStack) {
        return new NamedContainerProviderItem(itemIndex, hand, (Component)new TranslatableComponent("gui.cyclopscore.infobook"), ContainerOnTheDynamicsOfIntegration::new);
    }

    public Class<? extends AbstractContainerMenu> getContainerClass(Level world, Player playerEntity, ItemStack itemStack) {
        return ContainerOnTheDynamicsOfIntegration.class;
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (ItemOnTheDynamicsOfIntegrationConfig.obtainOnSpawn) {
            CompoundTag playerTag;
            CompoundTag tag = event.getPlayer().getPersistentData();
            if (!tag.m_128441_("PlayerPersisted")) {
                tag.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
            }
            if (!(playerTag = tag.m_128469_("PlayerPersisted")).m_128441_(NBT_INFOBOOK_SPAWNED)) {
                playerTag.m_128379_(NBT_INFOBOOK_SPAWNED, true);
                Level world = event.getPlayer().m_20193_();
                Player player = event.getPlayer();
                ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_ON_THE_DYNAMICS_OF_INTEGRATION);
                EntityItemTargetted entity = new EntityItemTargetted(world, (float)(player.m_142538_().m_123341_() + 25) - 50.0f * world.f_46441_.nextFloat(), (float)player.m_142538_().m_123342_() + 25.0f * world.f_46441_.nextFloat(), (float)(player.m_142538_().m_123343_() + 25) - 50.0f * world.f_46441_.nextFloat());
                entity.m_32045_(itemStack);
                entity.setTarget((LivingEntity)player);
                world.m_7967_((Entity)entity);
            }
        }
    }
}

