/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.metadata;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.metadata.IRegistryExportable;
import org.cyclops.cyclopscore.metadata.RegistryExportableRecipeAbstract;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;

public class RegistryExportableSqueezerRecipe
extends RegistryExportableRecipeAbstract<RecipeType<RecipeSqueezer>, RecipeSqueezer, Container> {
    protected RegistryExportableSqueezerRecipe() {
        super(() -> RegistryEntries.RECIPETYPE_SQUEEZER);
    }

    public static JsonObject serializeRecipeStatic(RecipeSqueezer recipe) {
        JsonObject object = new JsonObject();
        ItemStack[] inputs = recipe.getInputIngredient().m_43908_();
        JsonArray arrayInputs = new JsonArray();
        for (ItemStack input : inputs) {
            arrayInputs.add((JsonElement)IRegistryExportable.serializeItemStack((ItemStack)input));
        }
        JsonObject outputObject = new JsonObject();
        FluidStack fluidOutput = recipe.getOutputFluid();
        if (fluidOutput != null) {
            outputObject.add("fluid", (JsonElement)IRegistryExportable.serializeFluidStack((FluidStack)fluidOutput));
        }
        NonNullList<RecipeSqueezer.ItemStackChance> itemOutputs = recipe.getOutputItems();
        JsonArray arrayItemOutputs = new JsonArray();
        boolean i = false;
        for (RecipeSqueezer.ItemStackChance itemOutput : itemOutputs) {
            JsonObject itemOutputObject = IRegistryExportable.serializeItemStack((ItemStack)itemOutput.getItemStack());
            float chance = itemOutput.getChance();
            if (chance > 0.0f) {
                itemOutputObject.addProperty("chance", (Number)Float.valueOf(chance));
            }
            arrayItemOutputs.add((JsonElement)itemOutputObject);
        }
        outputObject.add("items", (JsonElement)arrayItemOutputs);
        object.add("input", (JsonElement)arrayInputs);
        object.add("output", (JsonElement)outputObject);
        return object;
    }

    public JsonObject serializeRecipe(RecipeSqueezer recipe) {
        return RegistryExportableSqueezerRecipe.serializeRecipeStatic(recipe);
    }
}

