/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.features;

import appeng.core.definitions.AEParts;
import appeng.items.parts.PartItem;
import appeng.parts.p2p.P2PTunnelPart;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.ThreadSafe;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.Capability;

@ThreadSafe
public final class P2PTunnelAttunement {
    private static final int INITIAL_CAPACITY = 40;
    static final Map<Item, Item> tunnels = new HashMap<Item, Item>(40);
    static final Map<String, Item> modIdTunnels = new HashMap<String, Item>(40);
    static final Map<Capability<?>, Item> capTunnels = new HashMap(40);
    public static final ItemLike ME_TUNNEL = AEParts.ME_P2P_TUNNEL;
    public static final ItemLike ENERGY_TUNNEL = AEParts.FE_P2P_TUNNEL;
    public static final ItemLike REDSTONE_TUNNEL = AEParts.REDSTONE_P2P_TUNNEL;
    public static final ItemLike FLUID_TUNNEL = AEParts.FLUID_P2P_TUNNEL;
    public static final ItemLike ITEM_TUNNEL = AEParts.ITEM_P2P_TUNNEL;
    public static final ItemLike LIGHT_TUNNEL = AEParts.LIGHT_P2P_TUNNEL;

    private P2PTunnelAttunement() {
    }

    public static synchronized void addItem(ItemLike trigger, ItemLike tunnelPart) {
        Objects.requireNonNull(trigger, "trigger");
        Item triggerItem = trigger.m_5456_();
        Objects.requireNonNull(triggerItem, "trigger.asItem()");
        Preconditions.checkArgument((triggerItem != Items.f_41852_ ? 1 : 0) != 0, (Object)"trigger shouldn't be air!");
        tunnels.put(triggerItem, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart));
    }

    public static synchronized void addItemByMod(String modId, ItemLike tunnelPart) {
        Objects.requireNonNull(modId, "modId");
        modIdTunnels.put(modId, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart));
    }

    public static synchronized <T> void addItemByCap(Capability<?> cap, ItemLike tunnelPart) {
        Objects.requireNonNull(cap, "cap");
        capTunnels.put(cap, P2PTunnelAttunement.validateTunnelPartItem(tunnelPart));
    }

    public static synchronized ItemStack getTunnelPartByTriggerItem(ItemStack trigger) {
        if (trigger.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Item tunnelItem = tunnels.get(trigger.m_41720_());
        if (tunnelItem != null) {
            return new ItemStack((ItemLike)tunnelItem);
        }
        for (Direction face : Direction.values()) {
            for (Map.Entry<Capability<?>, Item> entry : capTunnels.entrySet()) {
                if (!trigger.getCapability(entry.getKey(), face).isPresent()) continue;
                return new ItemStack((ItemLike)entry.getValue());
            }
        }
        for (Map.Entry entry : modIdTunnels.entrySet()) {
            if (trigger.m_41720_().getRegistryName() == null || !trigger.m_41720_().getRegistryName().m_135827_().equals(entry.getKey())) continue;
            return new ItemStack((ItemLike)entry.getValue());
        }
        return ItemStack.f_41583_;
    }

    private static Item validateTunnelPartItem(ItemLike itemLike) {
        Objects.requireNonNull(itemLike, "item");
        Item item = itemLike.m_5456_();
        Objects.requireNonNull(item, "item");
        if (!(item instanceof PartItem)) {
            throw new IllegalArgumentException("Given tunnel part item is not a part");
        }
        PartItem partItem = (PartItem)item;
        if (!P2PTunnelPart.class.isAssignableFrom(partItem.getPartClass())) {
            throw new IllegalArgumentException("Given tunnel part item results in a part that is not a P2P tunnel: " + partItem);
        }
        return item;
    }
}

