/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity;

import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.util.IConfigurableObject;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.AEBaseEntityBlock;
import appeng.client.render.model.AEModelData;
import appeng.core.AELog;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.ICustomNameObject;
import appeng.helpers.IPriorityHost;
import appeng.hooks.ticking.TickHandler;
import appeng.util.CustomNameUtil;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import appeng.util.helpers.ItemComparisonHelper;
import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.IModelData;

public class AEBaseBlockEntity
extends BlockEntity
implements IOrientable,
ICustomNameObject,
ISegmentedInventory {
    private static final Map<BlockEntityType<?>, Item> REPRESENTATIVE_ITEMS = new HashMap();
    @Nullable
    private String customName;
    private Direction forward = Direction.NORTH;
    private Direction up = Direction.UP;
    private boolean setChangedQueued = false;
    private byte queuedForReady = 0;
    private byte readyInvoked = 0;

    public AEBaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
    }

    public static void registerBlockEntityItem(BlockEntityType<?> type, Item wat) {
        REPRESENTATIVE_ITEMS.put(type, wat);
    }

    public boolean notLoaded() {
        return !this.f_58857_.m_46805_(this.f_58858_);
    }

    public BlockEntity getBlockEntity() {
        return this;
    }

    protected Item getItemFromBlockEntity() {
        return REPRESENTATIVE_ITEMS.getOrDefault(this.m_58903_(), Items.f_41852_);
    }

    public final void m_142466_(CompoundTag tag) {
        if (tag.m_128425_("#upd", 7) && tag.m_128440_() == 1) {
            byte[] updateData = tag.m_128463_("#upd");
            if (this.readUpdateData(new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])updateData))) && this.f_58857_ != null) {
                this.requestModelDataUpdate();
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 0);
            }
            return;
        }
        super.m_142466_(tag);
        this.loadTag(tag);
    }

    public void loadTag(CompoundTag data) {
        this.customName = data.m_128441_("customName") ? data.m_128461_("customName") : null;
        try {
            if (this.canBeRotated()) {
                this.forward = Direction.valueOf((String)data.m_128461_("forward"));
                this.up = Direction.valueOf((String)data.m_128461_("up"));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        if (this.canBeRotated()) {
            data.m_128359_("forward", this.getForward().name());
            data.m_128359_("up", this.getUp().name());
        }
        if (this.customName != null) {
            data.m_128359_("customName", this.customName);
        }
    }

    public void onReady() {
    }

    public CompoundTag m_5995_() {
        CompoundTag data = new CompoundTag();
        FriendlyByteBuf stream = new FriendlyByteBuf(Unpooled.buffer());
        this.writeToStream(stream);
        stream.capacity(stream.readableBytes());
        data.m_128382_("#upd", stream.array());
        return data;
    }

    private boolean readUpdateData(FriendlyByteBuf stream) {
        boolean output = false;
        try {
            output = this.readFromStream(stream);
        }
        catch (Throwable t) {
            AELog.warn(t);
        }
        return output;
    }

    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected boolean readFromStream(FriendlyByteBuf data) {
        if (this.canBeRotated()) {
            Direction old_Forward = this.forward;
            Direction old_Up = this.up;
            byte orientation = data.readByte();
            this.forward = Direction.values()[orientation & 7];
            this.up = Direction.values()[orientation >> 3];
            return this.forward != old_Forward || this.up != old_Up;
        }
        return false;
    }

    protected void writeToStream(FriendlyByteBuf data) {
        if (this.canBeRotated()) {
            byte orientation = (byte)(this.up.ordinal() << 3 | this.forward.ordinal());
            data.writeByte((int)orientation);
        }
    }

    public void markForUpdate() {
        this.requestModelDataUpdate();
        if (this.f_58857_ != null && !this.m_58901_() && !this.notLoaded()) {
            AEBaseEntityBlock block;
            BlockState newState;
            boolean alreadyUpdated = false;
            BlockState currentState = this.m_58900_();
            Block block2 = currentState.m_60734_();
            if (block2 instanceof AEBaseEntityBlock && currentState != (newState = (block = (AEBaseEntityBlock)block2).getBlockEntityBlockState(currentState, this))) {
                AELog.blockUpdate(this.f_58858_, currentState, newState, this);
                this.f_58857_.m_46597_(this.f_58858_, newState);
                alreadyUpdated = true;
            }
            if (!alreadyUpdated) {
                this.f_58857_.m_7260_(this.f_58858_, currentState, currentState, 1);
            }
        }
    }

    @Override
    public boolean canBeRotated() {
        return true;
    }

    @Override
    public Direction getForward() {
        return this.forward;
    }

    @Override
    public Direction getUp() {
        return this.up;
    }

    @Override
    public void setOrientation(Direction inForward, Direction inUp) {
        this.forward = inForward;
        this.up = inUp;
        this.markForUpdate();
        Platform.notifyBlocksOfNeighbors(this.f_58857_, this.f_58858_);
        this.saveChanges();
    }

    @OverridingMethodsMustInvokeSuper
    public void exportSettings(SettingsFrom mode, CompoundTag output, @Nullable Player player) {
        CustomNameUtil.setCustomName(output, this.customName);
        if (mode == SettingsFrom.MEMORY_CARD) {
            AEBaseBlockEntity aEBaseBlockEntity = this;
            if (aEBaseBlockEntity instanceof IConfigurableObject) {
                IConfigurableObject configurableObject = (IConfigurableObject)((Object)aEBaseBlockEntity);
                configurableObject.getConfigManager().writeToNBT(output);
            }
            if ((aEBaseBlockEntity = this) instanceof IPriorityHost) {
                IPriorityHost pHost = (IPriorityHost)((Object)aEBaseBlockEntity);
                output.m_128405_("priority", pHost.getPriority());
            }
            if ((aEBaseBlockEntity = this) instanceof IConfigInvHost) {
                IConfigInvHost configInvHost = (IConfigInvHost)((Object)aEBaseBlockEntity);
                configInvHost.getConfig().writeToChildTag(output, "config");
            }
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player) {
        AEBaseBlockEntity aEBaseBlockEntity = this;
        if (aEBaseBlockEntity instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)((Object)aEBaseBlockEntity);
            configurableObject.getConfigManager().readFromNBT(input);
        }
        if ((aEBaseBlockEntity = this) instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)((Object)aEBaseBlockEntity);
            pHost.setPriority(input.m_128451_("priority"));
        }
        if ((aEBaseBlockEntity = this) instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)((Object)aEBaseBlockEntity);
            configInvHost.getConfig().readFromChildTag(input, "config");
        }
    }

    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
    }

    @Override
    public Component getCustomInventoryName() {
        return new TextComponent(this.hasCustomInventoryName() ? this.customName : this.getClass().getSimpleName());
    }

    @Override
    public boolean hasCustomInventoryName() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void securityBreak() {
        this.f_58857_.m_46961_(this.f_58858_, true);
    }

    public boolean isClientSide() {
        Level level = this.m_58904_();
        return level == null || level.m_5776_();
    }

    public void saveChanges() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            this.m_6596_();
        } else {
            this.f_58857_.m_151543_(this.f_58858_);
            if (!this.setChangedQueued) {
                TickHandler.instance().addCallable(null, this::setChangedAtEndOfTick);
                this.setChangedQueued = true;
            }
        }
    }

    private Object setChangedAtEndOfTick(Level level) {
        this.m_6596_();
        this.setChangedQueued = false;
        return null;
    }

    public void setName(String name) {
        this.customName = name;
    }

    @Override
    @Nullable
    @OverridingMethodsMustInvokeSuper
    public InternalInventory getSubInventory(ResourceLocation id) {
        return null;
    }

    public IModelData getModelData() {
        return new AEModelData(this.up, this.forward);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.f_58858_, this.f_58858_.m_142082_(1, 1, 1));
    }

    public InteractionResult disassembleWithWrench(Player player, Level level, BlockHitResult hitResult) {
        BlockPos pos = hitResult.m_82425_();
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        Object[] itemDropCandidates = Platform.getBlockDrops(level, pos);
        ItemStack op = new ItemStack((ItemLike)this.m_58900_().m_60734_());
        for (ItemStack itemStack : itemDropCandidates) {
            if (!ItemComparisonHelper.isEqualItemType(itemStack, op)) continue;
            CompoundTag tag = new CompoundTag();
            this.exportSettings(SettingsFrom.DISMANTLE_ITEM, tag, player);
            if (tag.m_128456_()) continue;
            itemStack.m_41751_(tag);
        }
        block.m_5707_(level, pos, blockState, player);
        level.m_7471_(pos, false);
        block.m_6786_((LevelAccessor)level, pos, this.m_58900_());
        ArrayList itemsToDrop = Lists.newArrayList((Object[])itemDropCandidates);
        Platform.spawnDrops(level, pos, itemsToDrop);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public InteractionResult rotateWithWrench(Player player, Level level, BlockHitResult hitResult) {
        AEBaseBlock aeBlock;
        BlockPos pos = hitResult.m_82425_();
        Block block = this.m_58900_().m_60734_();
        if (block instanceof AEBaseBlock && (aeBlock = (AEBaseBlock)block).rotateAroundFaceAxis((LevelAccessor)level, pos, hitResult.m_82434_())) {
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public byte getQueuedForReady() {
        return this.queuedForReady;
    }

    public void setQueuedForReady(byte queuedForReady) {
        this.queuedForReady = queuedForReady;
    }

    public byte getReadyInvoked() {
        return this.readyInvoked;
    }

    public void setReadyInvoked(byte readyInvoked) {
        this.readyInvoked = readyInvoked;
    }
}

