/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.crafting;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.implementations.blockentities.ICraftingMachine;
import appeng.api.inventories.ISegmentedInventory;
import appeng.api.inventories.InternalInventory;
import appeng.api.inventories.ItemTransfer;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.upgrades.UpgradeInventories;
import appeng.api.util.AECableType;
import appeng.blockentity.grid.AENetworkInvBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.client.render.crafting.AssemblerAnimationStatus;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.network.TargetPoint;
import appeng.core.sync.packets.AssemblerAnimationPacket;
import appeng.crafting.CraftingEvent;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.CraftingPatternItem;
import appeng.menu.NullMenu;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.FilteredInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class MolecularAssemblerBlockEntity
extends AENetworkInvBlockEntity
implements IUpgradeableObject,
IGridTickable,
ICraftingMachine,
IPowerChannelState {
    public static final ResourceLocation INV_MAIN = AppEng.makeId("molecular_assembler");
    private final CraftingContainer craftingInv;
    private final AppEngInternalInventory gridInv = new AppEngInternalInventory(this, 10, 1);
    private final AppEngInternalInventory patternInv = new AppEngInternalInventory(this, 1, 1);
    private final InternalInventory gridInvExt = new FilteredInternalInventory(this.gridInv, new CraftingGridFilter());
    private final InternalInventory internalInv = new CombinedInternalInventory(this.gridInv, this.patternInv);
    private final IUpgradeInventory upgrades;
    private boolean isPowered = false;
    private Direction pushDirection = null;
    private ItemStack myPattern = ItemStack.f_41583_;
    private AECraftingPattern myPlan = null;
    private double progress = 0.0;
    private boolean isAwake = false;
    private boolean forcePlan = false;
    private boolean reboot = true;
    @OnlyIn(value=Dist.CLIENT)
    private AssemblerAnimationStatus animationStatus;

    public MolecularAssemblerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.getMainNode().setIdlePowerUsage(0.0).addService(IGridTickable.class, this);
        this.upgrades = UpgradeInventories.forMachine(AEBlocks.MOLECULAR_ASSEMBLER, this.getUpgradeSlots(), this::saveChanges);
        this.craftingInv = new CraftingContainer((AbstractContainerMenu)new NullMenu(), 3, 3);
    }

    private int getUpgradeSlots() {
        return 5;
    }

    @Override
    public Optional<Component> getDisplayName() {
        if (this.hasCustomInventoryName()) {
            return Optional.of(this.getCustomInventoryName());
        }
        return Optional.of(this.getItemFromBlockEntity().m_41466_());
    }

    @Override
    public boolean pushPattern(IPatternDetails patternDetails, KeyCounter[] table, Direction where) {
        if (this.myPattern.m_41619_()) {
            boolean isEmpty;
            boolean bl = isEmpty = this.gridInv.isEmpty() && this.patternInv.isEmpty();
            if (isEmpty && patternDetails instanceof AECraftingPattern) {
                AECraftingPattern pattern = (AECraftingPattern)patternDetails;
                this.forcePlan = true;
                this.myPlan = pattern;
                this.pushDirection = where;
                this.fillGrid(table, pattern);
                this.updateSleepiness();
                this.saveChanges();
                return true;
            }
        }
        return false;
    }

    private void fillGrid(KeyCounter[] table, AECraftingPattern adapter) {
        block0: for (int sparseIndex = 0; sparseIndex < 9; ++sparseIndex) {
            int requiredAmount;
            AEKey validFluidKey;
            long amount;
            int inputId = adapter.getCompressedIndexFromSparse(sparseIndex);
            if (inputId == -1) continue;
            KeyCounter list = table[inputId];
            GenericStack validFluid = this.myPlan.getValidFluid(sparseIndex);
            if (validFluid != null && (amount = list.get(validFluidKey = validFluid.what())) >= (long)(requiredAmount = (int)validFluid.amount())) {
                this.gridInv.setItemDirect(sparseIndex, GenericStack.wrapInItemStack(validFluidKey, requiredAmount));
                list.remove(validFluidKey, requiredAmount);
                continue;
            }
            for (Object2LongMap.Entry<AEKey> entry : list) {
                Object object;
                if (entry.getLongValue() <= 0L || !((object = entry.getKey()) instanceof AEItemKey)) continue;
                AEItemKey itemKey = (AEItemKey)object;
                this.gridInv.setItemDirect(sparseIndex, itemKey.toStack());
                list.remove(itemKey, 1L);
                continue block0;
            }
        }
        for (KeyCounter list : table) {
            list.removeZeros();
            if (list.isEmpty()) continue;
            throw new RuntimeException("Could not fill grid with some items, including " + list.iterator().next());
        }
    }

    private void updateSleepiness() {
        boolean wasEnabled = this.isAwake;
        boolean bl = this.isAwake = this.myPlan != null && this.hasMats() || this.canPush();
        if (wasEnabled != this.isAwake) {
            this.getMainNode().ifPresent((grid, node) -> {
                if (this.isAwake) {
                    grid.getTickManager().wakeDevice((IGridNode)node);
                } else {
                    grid.getTickManager().sleepDevice((IGridNode)node);
                }
            });
        }
    }

    private boolean canPush() {
        return !this.gridInv.getStackInSlot(9).m_41619_();
    }

    private boolean hasMats() {
        if (this.myPlan == null) {
            return false;
        }
        for (int x = 0; x < this.craftingInv.m_6643_(); ++x) {
            this.craftingInv.m_6836_(x, this.gridInv.getStackInSlot(x));
        }
        return !this.myPlan.getOutput(this.craftingInv, this.m_58904_()).m_41619_();
    }

    @Override
    public boolean acceptsPlans() {
        return this.patternInv.isEmpty();
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        boolean oldPower = this.isPowered;
        this.isPowered = data.readBoolean();
        return this.isPowered != oldPower || c;
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeBoolean(this.isPowered);
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        if (this.forcePlan) {
            ItemStack pattern;
            ItemStack itemStack = pattern = this.myPlan != null ? this.myPlan.getDefinition().toStack() : this.myPattern;
            if (!pattern.m_41619_()) {
                CompoundTag compound = new CompoundTag();
                pattern.m_41739_(compound);
                data.m_128365_("myPlan", (Tag)compound);
                data.m_128405_("pushDirection", this.pushDirection.ordinal());
            }
        }
        this.upgrades.writeToNBT(data, "upgrades");
    }

    @Override
    public void loadTag(CompoundTag data) {
        ItemStack pattern;
        super.loadTag(data);
        this.forcePlan = false;
        this.myPattern = ItemStack.f_41583_;
        this.myPlan = null;
        if (data.m_128441_("myPlan") && !(pattern = ItemStack.m_41712_((CompoundTag)data.m_128469_("myPlan"))).m_41619_()) {
            this.forcePlan = true;
            this.myPattern = pattern;
            this.pushDirection = Direction.values()[data.m_128451_("pushDirection")];
        }
        this.upgrades.readFromNBT(data, "upgrades");
        this.recalculatePlan();
    }

    private void recalculatePlan() {
        Item item;
        this.reboot = true;
        if (this.forcePlan) {
            if (this.m_58904_() != null && this.myPlan == null) {
                Item item2;
                if (!this.myPattern.m_41619_() && (item2 = this.myPattern.m_41720_()) instanceof CraftingPatternItem) {
                    CraftingPatternItem patternItem = (CraftingPatternItem)item2;
                    this.myPlan = patternItem.decode(this.myPattern, this.m_58904_(), false);
                }
                this.myPattern = ItemStack.f_41583_;
                if (this.myPlan == null) {
                    AELog.warn("Unable to restore auto-crafting pattern after load: %s", this.myPattern.m_41783_());
                    this.forcePlan = false;
                }
            }
            return;
        }
        ItemStack is = this.patternInv.getStackInSlot(0);
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof CraftingPatternItem) {
            Level level;
            AECraftingPattern details;
            CraftingPatternItem patternItem = (CraftingPatternItem)item;
            if (!ItemStack.m_41746_((ItemStack)is, (ItemStack)this.myPattern) && (details = patternItem.decode(is, level = this.m_58904_(), false)) != null) {
                this.progress = 0.0;
                this.myPattern = is;
                this.myPlan = details;
            }
        } else {
            this.progress = 0.0;
            this.forcePlan = false;
            this.myPlan = null;
            this.myPattern = ItemStack.f_41583_;
            this.pushDirection = null;
        }
        this.updateSleepiness();
    }

    @Override
    public AECableType getCableConnectionType(Direction dir) {
        return AECableType.COVERED;
    }

    @Override
    public InternalInventory getSubInventory(ResourceLocation id) {
        if (id.equals((Object)ISegmentedInventory.UPGRADES)) {
            return this.upgrades;
        }
        if (id.equals((Object)INV_MAIN)) {
            return this.internalInv;
        }
        return super.getSubInventory(id);
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInv;
    }

    @Override
    protected InternalInventory getExposedInventoryForSide(Direction side) {
        return this.gridInvExt;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.gridInv || inv == this.patternInv) {
            this.recalculatePlan();
        }
    }

    public int getCraftingProgress() {
        return (int)this.progress;
    }

    @Override
    public void addAdditionalDrops(Level level, BlockPos pos, List<ItemStack> drops) {
        super.addAdditionalDrops(level, pos, drops);
        for (ItemStack upgrade : this.upgrades) {
            drops.add(upgrade);
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        this.recalculatePlan();
        this.updateSleepiness();
        return new TickingRequest(1, 1, !this.isAwake, false);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.gridInv.getStackInSlot(9).m_41619_()) {
            this.pushOut(this.gridInv.getStackInSlot(9));
            if (this.gridInv.getStackInSlot(9).m_41619_()) {
                this.saveChanges();
            }
            this.ejectHeldItems();
            this.updateSleepiness();
            this.progress = 0.0;
            return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
        }
        if (this.myPlan == null) {
            this.updateSleepiness();
            return TickRateModulation.SLEEP;
        }
        if (this.reboot) {
            ticksSinceLastCall = 1;
        }
        if (!this.isAwake) {
            return TickRateModulation.SLEEP;
        }
        this.reboot = false;
        int speed = 10;
        switch (this.upgrades.getInstalledUpgrades(AEItems.SPEED_CARD)) {
            case 0: {
                speed = 10;
                this.progress += (double)this.userPower(ticksSinceLastCall, 10, 1.0);
                break;
            }
            case 1: {
                speed = 13;
                this.progress += (double)this.userPower(ticksSinceLastCall, 13, 1.3);
                break;
            }
            case 2: {
                speed = 17;
                this.progress += (double)this.userPower(ticksSinceLastCall, 17, 1.7);
                break;
            }
            case 3: {
                speed = 20;
                this.progress += (double)this.userPower(ticksSinceLastCall, 20, 2.0);
                break;
            }
            case 4: {
                speed = 25;
                this.progress += (double)this.userPower(ticksSinceLastCall, 25, 2.5);
                break;
            }
            case 5: {
                speed = 50;
                this.progress += (double)this.userPower(ticksSinceLastCall, 50, 5.0);
            }
        }
        if (this.progress >= 100.0) {
            for (int x = 0; x < this.craftingInv.m_6643_(); ++x) {
                this.craftingInv.m_6836_(x, this.gridInv.getStackInSlot(x));
            }
            this.progress = 0.0;
            ItemStack output = this.myPlan.getOutput(this.craftingInv, this.m_58904_());
            if (!output.m_41619_()) {
                CraftingEvent.fireAutoCraftingEvent(this.m_58904_(), this.myPlan, output, this.craftingInv);
                this.pushOut(output.m_41777_());
                for (int x = 0; x < this.craftingInv.m_6643_(); ++x) {
                    this.gridInv.setItemDirect(x, Platform.getContainerItem(this.craftingInv.m_8020_(x)));
                }
                if (this.patternInv.isEmpty()) {
                    this.forcePlan = false;
                    this.myPlan = null;
                    this.pushDirection = null;
                }
                this.ejectHeldItems();
                AEItemKey item = AEItemKey.of(output);
                if (item != null) {
                    TargetPoint where = new TargetPoint(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), 32.0, this.f_58857_);
                    NetworkHandler.instance().sendToAllAround(new AssemblerAnimationPacket(this.f_58858_, (byte)speed, item), where);
                }
                this.saveChanges();
                this.updateSleepiness();
                return this.isAwake ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
            }
        }
        return TickRateModulation.FASTER;
    }

    private void ejectHeldItems() {
        if (this.gridInv.getStackInSlot(9).m_41619_()) {
            for (int x = 0; x < 9; ++x) {
                ItemStack is = this.gridInv.getStackInSlot(x);
                if (is.m_41619_() || this.myPlan != null && this.myPlan.isItemValid(x, AEItemKey.of(is), this.f_58857_)) continue;
                this.gridInv.setItemDirect(9, is);
                this.gridInv.setItemDirect(x, ItemStack.f_41583_);
                this.saveChanges();
                return;
            }
        }
    }

    private int userPower(int ticksPassed, int bonusValue, double acceleratorTax) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            return (int)(grid.getEnergyService().extractAEPower((double)(ticksPassed * bonusValue) * acceleratorTax, Actionable.MODULATE, PowerMultiplier.CONFIG) / acceleratorTax);
        }
        return 0;
    }

    private void pushOut(ItemStack output) {
        if (this.pushDirection == null) {
            for (Direction d : Direction.values()) {
                output = this.pushTo(output, d);
            }
        } else {
            output = this.pushTo(output, this.pushDirection);
        }
        if (output.m_41619_() && this.forcePlan) {
            this.forcePlan = false;
            this.recalculatePlan();
        }
        this.gridInv.setItemDirect(9, output);
    }

    private ItemStack pushTo(ItemStack output, Direction d) {
        int newSize;
        if (output.m_41619_()) {
            return output;
        }
        BlockEntity te = this.m_58904_().m_7702_(this.f_58858_.m_142300_(d));
        if (te == null) {
            return output;
        }
        ItemTransfer adaptor = InternalInventory.wrapExternal(te, d.m_122424_());
        if (adaptor == null) {
            return output;
        }
        int size = output.m_41613_();
        int n = newSize = (output = adaptor.addItems(output)).m_41619_() ? 0 : output.m_41613_();
        if (size != newSize) {
            this.saveChanges();
        }
        return output;
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean newState = false;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            boolean bl = newState = this.getMainNode().isActive() && grid.getEnergyService().extractAEPower(1.0, Actionable.SIMULATE, PowerMultiplier.CONFIG) > 1.0E-4;
        }
        if (newState != this.isPowered) {
            this.isPowered = newState;
            this.markForUpdate();
        }
    }

    @Override
    public boolean isPowered() {
        return this.isPowered;
    }

    @Override
    public boolean isActive() {
        return this.isPowered;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAnimationStatus(@Nullable AssemblerAnimationStatus status) {
        this.animationStatus = status;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public AssemblerAnimationStatus getAnimationStatus() {
        return this.animationStatus;
    }

    @Override
    public IUpgradeInventory getUpgrades() {
        return this.upgrades;
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (Capabilities.CRAFTING_MACHINE == capability) {
            return Capabilities.CRAFTING_MACHINE.orEmpty(capability, LazyOptional.of(() -> this));
        }
        return super.getCapability(capability, facing);
    }

    @Nullable
    public AECraftingPattern getCurrentPattern() {
        if (this.isClientSide()) {
            ItemStack patternItem = this.patternInv.getStackInSlot(0);
            IPatternDetails pattern = PatternDetailsHelper.decodePattern(patternItem, this.f_58857_);
            if (pattern instanceof AECraftingPattern) {
                AECraftingPattern craftingPattern = (AECraftingPattern)pattern;
                return craftingPattern;
            }
            return null;
        }
        return this.myPlan;
    }

    private class CraftingGridFilter
    implements IAEItemFilter {
        private CraftingGridFilter() {
        }

        private boolean hasPattern() {
            return MolecularAssemblerBlockEntity.this.myPlan != null && !MolecularAssemblerBlockEntity.this.patternInv.isEmpty();
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return slot == 9;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (slot >= 9) {
                return false;
            }
            if (this.hasPattern()) {
                return MolecularAssemblerBlockEntity.this.myPlan.isItemValid(slot, AEItemKey.of(stack), MolecularAssemblerBlockEntity.this.m_58904_());
            }
            return false;
        }
    }
}

