/*
 * Decompiled with CFR 0.152.
 */
package appeng.blockentity.storage;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.SecurityPermissions;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IColorableBlockEntity;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.events.GridPowerStorageStateChanged;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageCells;
import appeng.api.storage.StorageHelper;
import appeng.api.storage.cells.CellState;
import appeng.api.storage.cells.ICellGuiHandler;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.StorageCell;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.capabilities.Capabilities;
import appeng.core.definitions.AEBlocks;
import appeng.helpers.IPriorityHost;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.DelegatingMEInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.implementations.ChestMenu;
import appeng.menu.locator.MenuLocators;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.CombinedInternalInventory;
import appeng.util.inv.filter.IAEItemFilter;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ChestBlockEntity
extends AENetworkPowerBlockEntity
implements IMEChest,
ITerminalHost,
IPriorityHost,
IColorableBlockEntity,
ServerTickingBlockEntity,
IStorageProvider {
    private static final int BIT_POWER_MASK = -128;
    private static final int BIT_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_MASK = 7;
    private static final int BIT_CELL_STATE_BITS = 3;
    private final AppEngInternalInventory inputInventory = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory cellInventory = new AppEngInternalInventory(this, 1);
    private final InternalInventory internalInventory = new CombinedInternalInventory(this.inputInventory, this.cellInventory);
    private final IActionSource mySrc = new MachineSource(this);
    private final IConfigManager config = new ConfigManager();
    private int priority = 0;
    private int state = 0;
    private boolean wasActive = false;
    private AEColor paintedColor = AEColor.TRANSPARENT;
    private boolean isCached = false;
    private ChestMonitorHandler cellHandler;
    private Accessor accessor;
    private IFluidHandler fluidHandler;
    private Item cellItem = Items.f_41852_;
    private double idlePowerUsage;

    public ChestBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState blockState) {
        super(blockEntityType, pos, blockState);
        this.setInternalMaxPower(PowerMultiplier.CONFIG.multiply(40.0));
        this.getMainNode().addService(IStorageProvider.class, this).setFlags(GridFlags.REQUIRE_CHANNEL);
        this.config.registerSetting(Settings.SORT_BY, SortOrder.NAME);
        this.config.registerSetting(Settings.VIEW_MODE, ViewItems.ALL);
        this.config.registerSetting(Settings.TYPE_FILTER, TypeFilter.ALL);
        this.config.registerSetting(Settings.SORT_DIRECTION, SortDir.ASCENDING);
        this.setInternalPublicPowerStorage(true);
        this.setInternalPowerFlow(AccessRestriction.WRITE);
        this.inputInventory.setFilter(new InputInventoryFilter());
        this.cellInventory.setFilter(new CellInventoryFilter());
    }

    public ItemStack getCell() {
        return this.cellInventory.getStackInSlot(0);
    }

    public void setCell(ItemStack stack) {
        this.cellInventory.setItemDirect(0, Objects.requireNonNull(stack));
    }

    @Override
    protected void PowerEvent(GridPowerStorageStateChanged.PowerEventType x) {
        if (x == GridPowerStorageStateChanged.PowerEventType.REQUEST_POWER) {
            this.getMainNode().ifPresent(grid -> grid.postEvent(new GridPowerStorageStateChanged(this, GridPowerStorageStateChanged.PowerEventType.REQUEST_POWER)));
        } else {
            this.recalculateDisplay();
        }
    }

    private void recalculateDisplay() {
        int oldState = this.state;
        int state = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        if (this.isPowered()) {
            state |= 0xFFFFFF80;
        }
        if (oldState != state) {
            this.state = state;
            this.markForUpdate();
        }
    }

    @Override
    public int getCellCount() {
        return 1;
    }

    private void updateHandler() {
        if (!this.isCached) {
            this.cellHandler = null;
            this.accessor = null;
            this.fluidHandler = null;
            ItemStack is = this.getCell();
            if (!is.m_41619_()) {
                this.isCached = true;
                StorageCell newCell = StorageCells.getCellInventory(is, this::onCellContentChanged);
                if (newCell != null) {
                    this.idlePowerUsage = 1.0 + newCell.getIdleDrain();
                    this.cellHandler = this.wrap(newCell);
                    this.getMainNode().setIdlePowerUsage(this.idlePowerUsage);
                    this.accessor = new Accessor();
                    if (this.cellHandler != null) {
                        this.fluidHandler = new FluidHandler();
                    }
                }
            }
        }
    }

    private ChestMonitorHandler wrap(StorageCell cellInventory) {
        if (cellInventory == null) {
            return null;
        }
        return new ChestMonitorHandler(cellInventory, cellInventory);
    }

    @Override
    public CellState getCellStatus(int slot) {
        if (this.isClientSide()) {
            return CellState.values()[this.state >> slot * 3 & 7];
        }
        this.updateHandler();
        ItemStack cell = this.getCell();
        ICellHandler ch = StorageCells.getHandler(cell);
        if (this.cellHandler != null && ch != null) {
            return this.cellHandler.cellInventory.getStatus();
        }
        return CellState.ABSENT;
    }

    @Override
    @Nullable
    public Item getCellItem(int slot) {
        if (slot != 0) {
            return null;
        }
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return this.cellItem;
        }
        ItemStack cell = this.getCell();
        return cell.m_41619_() ? null : cell.m_41720_();
    }

    @Override
    public boolean isPowered() {
        boolean gridPowered;
        if (this.isClientSide()) {
            return (this.state & 0xFFFFFF80) == -128;
        }
        boolean bl = gridPowered = this.getAECurrentPower() > 64.0;
        if (!gridPowered) {
            gridPowered = this.getMainNode().isPowered();
        }
        return super.getAECurrentPower() > 1.0 || gridPowered;
    }

    @Override
    public boolean isCellBlinking(int slot) {
        return false;
    }

    @Override
    protected double extractAEPower(double amt, Actionable mode) {
        IEnergyService eg;
        double stash = 0.0;
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && (stash = (eg = grid.getEnergyService()).extractAEPower(amt, mode, PowerMultiplier.ONE)) >= amt) {
            return stash;
        }
        return super.extractAEPower(amt - stash, mode) + stash;
    }

    @Override
    public void serverTick() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null) {
            double powerUsed;
            if (!grid.getEnergyService().isNetworkPowered() && (powerUsed = this.extractAEPower(this.idlePowerUsage, Actionable.MODULATE, PowerMultiplier.CONFIG)) + 0.1 >= this.idlePowerUsage != (this.state & 0xFFFFFF80) > 0) {
                this.recalculateDisplay();
            }
        } else {
            double powerUsed = this.extractAEPower(this.idlePowerUsage, Actionable.MODULATE, PowerMultiplier.CONFIG);
            if (powerUsed + 0.1 >= this.idlePowerUsage != (this.state & 0xFFFFFF80) > 0) {
                this.recalculateDisplay();
            }
        }
        if (!this.inputInventory.isEmpty()) {
            this.tryToStoreContents();
        }
    }

    @Override
    protected void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        this.state = 0;
        for (int x = 0; x < this.getCellCount(); ++x) {
            this.state |= this.getCellStatus(x).ordinal() << 3 * x;
        }
        if (this.isPowered()) {
            this.state |= 0xFFFFFF80;
        }
        data.writeByte(this.state);
        data.writeByte(this.paintedColor.ordinal());
        data.m_130130_(Item.m_41393_((Item)this.getCell().m_41720_()));
    }

    @Override
    protected boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        int oldState = this.state;
        this.state = data.readByte();
        AEColor oldPaintedColor = this.paintedColor;
        this.paintedColor = AEColor.values()[data.readByte()];
        this.cellItem = Item.m_41445_((int)data.m_130242_());
        return oldPaintedColor != this.paintedColor || (this.state & 0xDB6DB6DB) != (oldState & 0xDB6DB6DB) || c;
    }

    @Override
    public void loadTag(CompoundTag data) {
        super.loadTag(data);
        this.config.readFromNBT(data);
        this.priority = data.m_128451_("priority");
        if (data.m_128441_("paintedColor")) {
            this.paintedColor = AEColor.values()[data.m_128445_("paintedColor")];
        }
    }

    @Override
    public void m_183515_(CompoundTag data) {
        super.m_183515_(data);
        this.config.writeToNBT(data);
        data.m_128405_("priority", this.priority);
        data.m_128344_("paintedColor", (byte)this.paintedColor.ordinal());
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentActive = this.getMainNode().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            IStorageProvider.requestUpdate(this.getMainNode());
            this.recalculateDisplay();
        }
    }

    @Override
    public MEStorage getInventory() {
        this.updateHandler();
        if (this.cellHandler != null) {
            return this.cellHandler;
        }
        return null;
    }

    @Override
    public InternalInventory getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.cellInventory) {
            this.cellHandler = null;
            this.isCached = false;
            IStorageProvider.requestUpdate(this.getMainNode());
            if (this.f_58857_ != null) {
                Platform.notifyBlocksOfNeighbors(this.f_58857_, this.f_58858_);
                this.markForUpdate();
            }
        }
        if (inv == this.inputInventory && !inv.getStackInSlot(slot).m_41619_()) {
            this.tryToStoreContents();
        }
    }

    @Override
    public InternalInventory getExposedInventoryForSide(Direction side) {
        if (side == this.getForward()) {
            return this.cellInventory;
        }
        return this.inputInventory;
    }

    private void tryToStoreContents() {
        if (!this.inputInventory.isEmpty()) {
            this.updateHandler();
            if (this.cellHandler != null) {
                ItemStack stack = this.inputInventory.getStackInSlot(0);
                if (stack.m_41619_()) {
                    return;
                }
                long inserted = StorageHelper.poweredInsert(this, this.cellHandler, AEItemKey.of(stack), stack.m_41613_(), this.mySrc);
                if (inserted >= (long)stack.m_41613_()) {
                    this.inputInventory.setItemDirect(0, ItemStack.f_41583_);
                } else {
                    stack.m_41774_((int)inserted);
                    this.inputInventory.setItemDirect(0, stack);
                }
            }
        }
    }

    @Override
    public void mountInventories(IStorageMounts storageMounts) {
        if (this.getMainNode().isActive()) {
            this.updateHandler();
            if (this.cellHandler != null) {
                storageMounts.mount(this.cellHandler, this.priority);
            }
        }
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.cellHandler = null;
        this.isCached = false;
        IStorageProvider.requestUpdate(this.getMainNode());
    }

    private void blinkCell(int slot) {
        this.recalculateDisplay();
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.config;
    }

    public boolean openGui(Player p) {
        ICellGuiHandler chg;
        ICellHandler ch;
        this.updateHandler();
        if (this.cellHandler != null && (ch = StorageCells.getHandler(this.getCell())) != null && (chg = StorageCells.getGuiHandler(this.getCell())) != null) {
            chg.openChestGui(p, this, ch, this.getCell());
            return true;
        }
        return false;
    }

    @Override
    public AEColor getColor() {
        return this.paintedColor;
    }

    @Override
    public boolean recolourBlock(Direction side, AEColor newPaintedColor, Player who) {
        if (this.paintedColor == newPaintedColor) {
            return false;
        }
        this.paintedColor = newPaintedColor;
        this.saveChanges();
        this.markForUpdate();
        return true;
    }

    private void onCellContentChanged() {
        if (this.cellHandler != null) {
            this.cellHandler.cellInventory.persist();
        }
        this.f_58857_.m_151543_(this.f_58858_);
    }

    public void openCellInventoryMenu(Player player) {
        MenuOpener.open(ChestMenu.TYPE, player, MenuLocators.forBlockEntity(this));
    }

    @Nullable
    public IFluidHandler getFluidHandler(Direction side) {
        if (side != this.getForward()) {
            return this.fluidHandler;
        }
        return null;
    }

    @Nullable
    public IStorageMonitorableAccessor getMEHandler(Direction side) {
        if (side != this.getForward()) {
            return this.accessor;
        }
        return null;
    }

    @Override
    public ItemStack getMainMenuIcon() {
        return AEBlocks.CHEST.stack();
    }

    @Override
    public void returnToMainMenu(Player player, ISubMenu subMenu) {
        this.openCellInventoryMenu(player);
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        this.updateHandler();
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && this.fluidHandler != null && facing != this.getForward()) {
            return LazyOptional.of(() -> this.fluidHandler);
        }
        if (capability == Capabilities.STORAGE_MONITORABLE_ACCESSOR && this.accessor != null && facing != this.getForward()) {
            return LazyOptional.of(() -> this.accessor);
        }
        return super.getCapability(capability, facing);
    }

    private class InputInventoryFilter
    implements IAEItemFilter {
        private InputInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return false;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            if (ChestBlockEntity.this.isPowered()) {
                ChestBlockEntity.this.updateHandler();
                return ChestBlockEntity.this.cellHandler != null;
            }
            return false;
        }
    }

    private static class CellInventoryFilter
    implements IAEItemFilter {
        private CellInventoryFilter() {
        }

        @Override
        public boolean allowExtract(InternalInventory inv, int slot, int amount) {
            return true;
        }

        @Override
        public boolean allowInsert(InternalInventory inv, int slot, ItemStack stack) {
            return StorageCells.getHandler(stack) != null;
        }
    }

    private class ChestMonitorHandler
    extends DelegatingMEInventory {
        private final StorageCell cellInventory;

        public ChestMonitorHandler(MEStorage inventory, StorageCell cellInventory) {
            super(inventory);
            this.cellInventory = cellInventory;
        }

        @Override
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (source.player().map(player -> !this.securityCheck((Player)player, SecurityPermissions.INJECT)).orElse(false).booleanValue()) {
                return 0L;
            }
            long inserted = super.insert(what, amount, mode, source);
            if (inserted > 0L && mode == Actionable.MODULATE) {
                ChestBlockEntity.this.blinkCell(0);
            }
            return inserted;
        }

        private boolean securityCheck(Player player, SecurityPermissions requiredPermission) {
            return Platform.checkPermissions(player, ChestBlockEntity.this, requiredPermission, false, false);
        }

        @Override
        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (source.player().map(player -> !this.securityCheck((Player)player, SecurityPermissions.EXTRACT)).orElse(false).booleanValue()) {
                return 0L;
            }
            long extracted = super.extract(what, amount, mode, source);
            if (extracted > 0L && mode == Actionable.MODULATE) {
                ChestBlockEntity.this.blinkCell(0);
            }
            return extracted;
        }
    }

    private class Accessor
    implements IStorageMonitorableAccessor {
        private Accessor() {
        }

        @Override
        @Nullable
        public MEStorage getInventory(IActionSource src) {
            if (Platform.canAccess(ChestBlockEntity.this.getMainNode(), src)) {
                return ChestBlockEntity.this.getInventory();
            }
            return null;
        }
    }

    private class FluidHandler
    implements IFluidHandler,
    IFluidTank {
        private FluidHandler() {
        }

        private boolean canAcceptLiquids() {
            return ChestBlockEntity.this.cellHandler != null;
        }

        public FluidStack getFluid() {
            return FluidStack.EMPTY;
        }

        public int getFluidAmount() {
            return 0;
        }

        public int getCapacity() {
            return this.canAcceptLiquids() ? 1000 : 0;
        }

        public boolean isFluidValid(FluidStack stack) {
            return this.canAcceptLiquids();
        }

        public int getTanks() {
            return 1;
        }

        public FluidStack getFluidInTank(int tank) {
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return tank == 0;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            AEFluidKey what;
            ChestBlockEntity.this.updateHandler();
            if (this.canAcceptLiquids() && (what = AEFluidKey.of(resource)) != null) {
                return (int)StorageHelper.poweredInsert(ChestBlockEntity.this, ChestBlockEntity.this.cellHandler, what, resource.getAmount(), ChestBlockEntity.this.mySrc, Actionable.of(action));
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    }
}

