/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.config.YesNo;
import appeng.api.stacks.AEKey;
import appeng.api.storage.AEKeyFilter;
import appeng.client.gui.me.common.KeySorters;
import appeng.client.gui.widgets.IScrollSource;
import appeng.client.gui.widgets.ISortSource;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.IClientRepo;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;

public class Repo
implements IClientRepo {
    public static final Comparator<GridInventoryEntry> AMOUNT_ASC = Comparator.comparingDouble(entry -> (double)entry.getStoredAmount() / (double)entry.getWhat().getAmountPerUnit());
    public static final Comparator<GridInventoryEntry> AMOUNT_DESC = AMOUNT_ASC.reversed();
    private int rowSize = 9;
    private String searchString = "";
    private boolean hasPower;
    private final BiMap<Long, GridInventoryEntry> entries = HashBiMap.create();
    private final ArrayList<GridInventoryEntry> view = new ArrayList();
    private IPartitionList partitionList;
    private Runnable updateViewListener;
    private final IScrollSource src;
    private final ISortSource sortSrc;

    public Repo(IScrollSource src, ISortSource sortSrc) {
        this.src = src;
        this.sortSrc = sortSrc;
    }

    public void setPartitionList(IPartitionList partitionList) {
        if (partitionList != this.partitionList) {
            this.partitionList = partitionList;
            this.updateView();
        }
    }

    @Override
    public final void handleUpdate(boolean fullUpdate, List<GridInventoryEntry> entries) {
        if (fullUpdate) {
            this.clear();
        }
        for (GridInventoryEntry entry : entries) {
            this.handleUpdate(entry);
        }
        this.updateView();
    }

    private void handleUpdate(GridInventoryEntry serverEntry) {
        GridInventoryEntry localEntry = (GridInventoryEntry)this.entries.get((Object)serverEntry.getSerial());
        if (localEntry == null) {
            if (serverEntry.getWhat() == null) {
                AELog.warn("First time seeing serial %s, but incomplete info received", serverEntry.getSerial());
                return;
            }
            if (serverEntry.isMeaningful()) {
                this.entries.put((Object)serverEntry.getSerial(), (Object)serverEntry);
            }
            return;
        }
        if (!serverEntry.isMeaningful()) {
            this.entries.remove((Object)serverEntry.getSerial());
        } else if (serverEntry.getWhat() == null) {
            this.entries.put((Object)serverEntry.getSerial(), (Object)new GridInventoryEntry(serverEntry.getSerial(), localEntry.getWhat(), serverEntry.getStoredAmount(), serverEntry.getRequestableAmount(), serverEntry.isCraftable()));
        } else {
            this.entries.put((Object)serverEntry.getSerial(), (Object)serverEntry);
        }
    }

    public final void updateView() {
        Pattern m;
        String innerSearch;
        this.view.clear();
        this.view.ensureCapacity(this.entries.size());
        SearchMode searchMode = SearchMode.NAME;
        if (AEConfig.instance().getSearchTooltips() != YesNo.NO) {
            searchMode = SearchMode.NAME_OR_TOOLTIP;
        }
        if ((innerSearch = this.searchString).startsWith("@")) {
            searchMode = SearchMode.MOD;
            innerSearch = innerSearch.substring(1);
        }
        try {
            m = Pattern.compile(innerSearch.toLowerCase(), 66);
        }
        catch (PatternSyntaxException ignored) {
            m = Pattern.compile(Pattern.quote(innerSearch.toLowerCase()), 66);
        }
        ViewItems viewMode = this.sortSrc.getSortDisplay();
        AEKeyFilter typeFilter = this.sortSrc.getTypeFilter().getFilter();
        for (GridInventoryEntry entry : this.entries.values()) {
            if (this.partitionList != null && !this.partitionList.isListed(entry.getWhat()) || viewMode == ViewItems.CRAFTABLE && !entry.isCraftable() || viewMode == ViewItems.STORED && entry.getStoredAmount() == 0L || !typeFilter.matches(entry.getWhat()) || !this.matchesSearch(searchMode, m, entry.getWhat())) continue;
            this.view.add(entry);
        }
        SortOrder sortOrder = this.sortSrc.getSortBy();
        SortDir sortDir = this.sortSrc.getSortDir();
        this.view.sort(this.getComparator(sortOrder, sortDir));
        if (this.updateViewListener != null) {
            this.updateViewListener.run();
        }
    }

    private Comparator<? super GridInventoryEntry> getComparator(SortOrder sortOrder, SortDir sortDir) {
        if (sortOrder == SortOrder.AMOUNT) {
            return sortDir == SortDir.ASCENDING ? AMOUNT_ASC : AMOUNT_DESC;
        }
        return Comparator.comparing(GridInventoryEntry::getWhat, this.getKeyComparator(sortOrder, sortDir));
    }

    @Nullable
    public final GridInventoryEntry get(int idx) {
        if ((idx += this.src.getCurrentScroll() * this.rowSize) >= this.view.size()) {
            return null;
        }
        return this.view.get(idx);
    }

    public final int size() {
        return this.view.size();
    }

    public final void clear() {
        this.entries.clear();
        this.view.clear();
    }

    public final boolean hasPower() {
        return this.hasPower;
    }

    public final void setPower(boolean hasPower) {
        this.hasPower = hasPower;
    }

    public final int getRowSize() {
        return this.rowSize;
    }

    public final void setRowSize(int rowSize) {
        this.rowSize = rowSize;
    }

    public final String getSearchString() {
        return this.searchString;
    }

    public final void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    protected boolean matchesSearch(SearchMode searchMode, Pattern searchPattern, AEKey what) {
        if (searchMode == SearchMode.MOD) {
            return searchPattern.matcher(what.getModId()).find();
        }
        String displayName = what.getDisplayName().getString();
        if (searchPattern.matcher(displayName).find()) {
            return true;
        }
        if (searchMode == SearchMode.NAME_OR_TOOLTIP) {
            List<Component> tooltip = Platform.getTooltip(what);
            for (Component line : tooltip) {
                if (!searchPattern.matcher(line.getString()).find()) continue;
                return true;
            }
        }
        return false;
    }

    private Comparator<AEKey> getKeyComparator(SortOrder sortBy, SortDir sortDir) {
        return KeySorters.getComparator(sortBy, sortDir);
    }

    @Override
    public Set<GridInventoryEntry> getAllEntries() {
        return this.entries.values();
    }

    public final void setUpdateViewListener(Runnable updateViewListener) {
        this.updateViewListener = updateViewListener;
    }

    protected static enum SearchMode {
        MOD,
        NAME,
        NAME_OR_TOOLTIP;

    }
}

