/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.widgets.IResizableWidget;
import appeng.client.gui.widgets.ITooltip;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AETextField
extends EditBox
implements IResizableWidget,
ITooltip {
    private static final Blitter BLITTER = Blitter.texture("guis/text_field.png", 128, 128);
    private static final int PADDING = 2;
    private final int _fontPad;
    private int selectionColor = -16711936;
    private List<Component> tooltipMessage = Collections.emptyList();

    public AETextField(Font fontRenderer, int xPos, int yPos, int width, int height) {
        super(fontRenderer, xPos + 2, yPos + 2, width - 4 - fontRenderer.m_92895_("_"), height - 4, TextComponent.f_131282_);
        this._fontPad = fontRenderer.m_92895_("_");
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (super.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.m_93696_() && this.m_94204_() && keyCode != 258 && keyCode != 256;
    }

    @Override
    public void move(Point pos) {
        super.m_94214_(pos.getX() + 2);
        this.f_93621_ = pos.getY() + 2;
    }

    @Override
    public void resize(int width, int height) {
        super.m_93674_(width - 4 - this._fontPad);
        this.f_93619_ = height - 4;
    }

    public void selectAll() {
        this.m_94192_(0);
        this.m_94208_(this.m_94216_());
    }

    public void setSelectionColor(int color) {
        this.selectionColor = color;
    }

    public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partial) {
        if (this.m_94213_()) {
            int yOffset = 0;
            if (!this.m_94222_()) {
                yOffset = 12;
            } else if (this.m_93696_()) {
                yOffset = 24;
            }
            int left = this.f_93620_ - 2;
            int top = this.f_93621_ - 2;
            int right = left + this.f_93618_ + 4 + this._fontPad;
            BLITTER.src(0, yOffset, 1, 12).dest(left, top).blit(poseStack, this.m_93252_());
            int backgroundWidth = Math.min(126, right - left - 2);
            BLITTER.src(1, yOffset, backgroundWidth, 12).dest(left + 1, top).blit(poseStack, this.m_93252_());
            BLITTER.src(127, yOffset, 1, 12).dest(right - 1, top).blit(poseStack, this.m_93252_());
            super.m_6303_(poseStack, mouseX, mouseY, partial);
        }
    }

    public void m_94135_(int startX, int startY, int endX, int endY) {
        if (!this.m_93696_()) {
            return;
        }
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        ++startX;
        --endX;
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        startY -= 2;
        endX = Mth.m_14045_((int)endX, (int)this.f_93620_, (int)(this.f_93620_ + this.f_93618_));
        startX = Mth.m_14045_((int)startX, (int)this.f_93620_, (int)(this.f_93620_ + this.f_93618_));
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tessellator.m_85915_();
        float red = (float)(this.selectionColor >> 16 & 0xFF) / 255.0f;
        float blue = (float)(this.selectionColor >> 8 & 0xFF) / 255.0f;
        float green = (float)(this.selectionColor & 0xFF) / 255.0f;
        float alpha = (float)(this.selectionColor >> 24 & 0xFF) / 255.0f;
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        RenderSystem.m_69479_();
        RenderSystem.m_69835_((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferbuilder.m_5483_((double)startX, (double)endY, 0.0).m_85950_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)endX, (double)endY, 0.0).m_85950_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)endX, (double)startY, 0.0).m_85950_(red, green, blue, alpha).m_5752_();
        bufferbuilder.m_5483_((double)startX, (double)startY, 0.0).m_85950_(red, green, blue, alpha).m_5752_();
        tessellator.m_85914_();
        RenderSystem.m_69462_();
    }

    @Override
    public Rect2i getTooltipArea() {
        return new Rect2i(this.f_93620_ - 2, this.f_93621_ - 2, this.f_93618_ + 4 + this._fontPad, this.f_93619_ + 4);
    }

    @Override
    public boolean isTooltipAreaVisible() {
        return this.f_93624_;
    }

    @Override
    @NotNull
    public List<Component> getTooltipMessage() {
        return this.tooltipMessage;
    }

    public void setTooltipMessage(List<Component> tooltipMessage) {
        this.tooltipMessage = Objects.requireNonNull(tooltipMessage);
    }
}

