/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.config.FuzzyMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyService;
import appeng.api.networking.security.ISecurityService;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.AELog;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.helpers.IMenuCraftingPacket;
import appeng.items.storage.ViewCellItem;
import appeng.util.CraftingRecipeUtil;
import appeng.util.prioritylist.IPartitionList;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;

public class FillCraftingGridFromRecipePacket
extends BasePacket {
    private ResourceLocation recipeId;
    private NonNullList<ItemStack> ingredientTemplates;

    public FillCraftingGridFromRecipePacket(FriendlyByteBuf stream) {
        this.recipeId = stream.readBoolean() ? stream.m_130281_() : null;
        this.ingredientTemplates = NonNullList.m_122780_((int)stream.readInt(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.ingredientTemplates.size(); ++i) {
            this.ingredientTemplates.set(i, (Object)stream.m_130267_());
        }
    }

    public FillCraftingGridFromRecipePacket(@Nullable ResourceLocation recipeId, NonNullList<ItemStack> ingredientTemplates) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (recipeId != null) {
            data.writeBoolean(true);
            data.m_130085_(recipeId);
        } else {
            data.writeBoolean(false);
        }
        data.writeInt(ingredientTemplates.size());
        for (ItemStack stack : ingredientTemplates) {
            data.m_130055_(stack);
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, ServerPlayer player) {
        AbstractContainerMenu menu = player.f_36096_;
        if (!(menu instanceof IMenuCraftingPacket)) {
            return;
        }
        IMenuCraftingPacket cct = (IMenuCraftingPacket)menu;
        if (!cct.useRealItems()) {
            AELog.warn("Trying to use real items for crafting in a pattern encoding terminal", new Object[0]);
            return;
        }
        IGridNode node = cct.getNetworkNode();
        if (node == null) {
            return;
        }
        IGrid grid = node.getGrid();
        ISecurityService security = grid.getSecurityService();
        IEnergyService energy = grid.getEnergyService();
        InternalInventory craftMatrix = cct.getCraftingMatrix();
        MEStorage storage = grid.getStorageService().getInventory();
        KeyCounter cachedStorage = grid.getStorageService().getCachedInventory();
        IPartitionList filter = ViewCellItem.createItemFilter(cct.getViewCells());
        NonNullList<Ingredient> ingredients = this.getDesiredIngredients((Player)player);
        for (int x = 0; x < craftMatrix.size(); ++x) {
            ItemStack currentItem = craftMatrix.getStackInSlot(x);
            Ingredient ingredient = (Ingredient)ingredients.get(x);
            if (!currentItem.m_41619_()) {
                if (ingredient.test(currentItem)) continue;
                if (security.hasPermission((Player)player, SecurityPermissions.INJECT)) {
                    AEItemKey in = AEItemKey.of(currentItem);
                    long inserted = StorageHelper.poweredInsert(energy, storage, in, currentItem.m_41613_(), cct.getActionSource());
                    if (inserted < (long)currentItem.m_41613_()) {
                        currentItem = currentItem.m_41777_();
                        currentItem.m_41774_((int)inserted);
                    } else {
                        currentItem = ItemStack.f_41583_;
                    }
                }
                player.m_150109_().m_36054_(currentItem);
                craftMatrix.setItemDirect(x, currentItem.m_41619_() ? ItemStack.f_41583_ : currentItem);
            }
            if (ingredient.m_43947_()) continue;
            if (currentItem.m_41619_() && security.hasPermission((Player)player, SecurityPermissions.EXTRACT)) {
                List<AEItemKey> request = this.findBestMatchingItemStack(ingredient, filter, cachedStorage);
                for (AEItemKey what : request) {
                    long extracted = StorageHelper.poweredExtraction(energy, storage, what, 1L, cct.getActionSource());
                    if (extracted <= 0L) continue;
                    currentItem = what.toStack(Ints.saturatedCast((long)extracted));
                    break;
                }
            }
            if (currentItem.m_41619_()) {
                currentItem = this.takeIngredientFromPlayer(player, ingredient);
            }
            craftMatrix.setItemDirect(x, currentItem);
        }
        menu.m_6199_(craftMatrix.toContainer());
    }

    private ItemStack takeIngredientFromPlayer(ServerPlayer player, Ingredient ingredient) {
        Inventory playerInv = player.m_150109_();
        for (int i = 0; i < playerInv.f_35974_.size(); ++i) {
            ItemStack result;
            ItemStack item = playerInv.m_8020_(i);
            if (!ingredient.test(item) || (result = item.m_41620_(1)).m_41619_()) continue;
            return result;
        }
        return ItemStack.f_41583_;
    }

    private NonNullList<Ingredient> getDesiredIngredients(Player player) {
        Recipe recipe;
        if (this.recipeId != null && (recipe = (Recipe)player.m_183503_().m_7465_().m_44043_(this.recipeId).orElse(null)) != null) {
            return CraftingRecipeUtil.ensure3by3CraftingMatrix(recipe);
        }
        NonNullList ingredients = NonNullList.m_122780_((int)9, (Object)Ingredient.f_43901_);
        Preconditions.checkArgument((ingredients.size() == this.ingredientTemplates.size() ? 1 : 0) != 0, (String)"Got %d ingredient templates from client, expected %d", (int)this.ingredientTemplates.size(), (int)ingredients.size());
        for (int i = 0; i < ingredients.size(); ++i) {
            ItemStack template = (ItemStack)this.ingredientTemplates.get(i);
            if (template.m_41619_()) continue;
            ingredients.set(i, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{template}));
        }
        return ingredients;
    }

    private List<AEItemKey> findBestMatchingItemStack(Ingredient ingredient, IPartitionList filter, KeyCounter storage) {
        return Arrays.stream(ingredient.m_43908_()).map(AEItemKey::of).filter(r -> r != null && (filter == null || filter.isListed((AEKey)r))).flatMap(s -> storage.findFuzzy((AEKey)s, FuzzyMode.IGNORE_ALL).stream()).filter(e -> ingredient.test(((AEItemKey)e.getKey()).toStack())).sorted((a, b) -> Long.compare(b.getLongValue(), a.getLongValue())).map(e -> (AEItemKey)e.getKey()).toList();
    }
}

