/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.client.gui.me.interfaceterminal.InterfaceTerminalScreen;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InterfaceTerminalPacket
extends BasePacket {
    private boolean clearExistingData;
    private long inventoryId;
    private CompoundTag in;

    public InterfaceTerminalPacket(FriendlyByteBuf stream) {
        this.clearExistingData = stream.readBoolean();
        this.inventoryId = stream.readLong();
        this.in = stream.m_130260_();
    }

    private InterfaceTerminalPacket(boolean clearExistingData, long inventoryId, CompoundTag din) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer((int)2048));
        data.writeInt(this.getPacketID());
        data.writeBoolean(clearExistingData);
        data.writeLong(inventoryId);
        data.m_130079_(din);
        this.configureWrite(data);
    }

    public static InterfaceTerminalPacket clearExistingData() {
        return new InterfaceTerminalPacket(true, -1L, new CompoundTag());
    }

    public static InterfaceTerminalPacket inventory(long id, CompoundTag data) {
        return new InterfaceTerminalPacket(false, id, data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientPacketData(INetworkInfo network, Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof InterfaceTerminalScreen) {
            InterfaceTerminalScreen interfaceTerminal = (InterfaceTerminalScreen)screen;
            interfaceTerminal.postInventoryUpdate(this.clearExistingData, this.inventoryId, this.in);
        }
    }
}

