/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.parts.IPartHost;
import appeng.api.parts.SelectedPart;
import appeng.core.sync.BasePacket;
import appeng.core.sync.network.INetworkInfo;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class PartLeftClickPacket
extends BasePacket {
    private BlockHitResult hitResult;
    private boolean alternateUseMode;

    public PartLeftClickPacket(FriendlyByteBuf stream) {
        this.hitResult = stream.m_130283_();
        this.alternateUseMode = stream.readBoolean();
    }

    public PartLeftClickPacket(BlockHitResult hitResult, boolean alternateUseMode) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.m_130062_(hitResult);
        data.writeBoolean(alternateUseMode);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, ServerPlayer player) {
        Vec3 localPos = this.hitResult.m_82450_().m_82492_((double)this.hitResult.m_82425_().m_123341_(), (double)this.hitResult.m_82425_().m_123342_(), (double)this.hitResult.m_82425_().m_123343_());
        BlockEntity blockEntity = player.f_19853_.m_7702_(this.hitResult.m_82425_());
        if (blockEntity instanceof IPartHost) {
            IPartHost partHost = (IPartHost)blockEntity;
            SelectedPart selectedPart = partHost.selectPartLocal(localPos);
            if (selectedPart.part != null) {
                if (!this.alternateUseMode) {
                    selectedPart.part.onClicked((Player)player, localPos);
                } else {
                    selectedPart.part.onShiftClicked((Player)player, localPos);
                }
            }
        }
    }
}

