/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.crafting.IPatternDetails;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.crafting.pattern.AEPatternHelper;
import appeng.crafting.pattern.IAEPatternDetails;
import appeng.crafting.pattern.ProcessingPatternEncoding;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;

public class AEProcessingPattern
implements IAEPatternDetails {
    public static final int MAX_INPUT_SLOTS = 18;
    public static final int MAX_OUTPUT_SLOTS = 6;
    private final AEItemKey definition;
    private final GenericStack[] sparseInputs;
    private final GenericStack[] sparseOutputs;
    private final Input[] inputs;
    private final GenericStack[] condensedOutputs;

    public AEProcessingPattern(AEItemKey definition) {
        this.definition = definition;
        CompoundTag tag = Objects.requireNonNull(definition.getTag());
        this.sparseInputs = ProcessingPatternEncoding.getProcessingInputs(tag);
        this.sparseOutputs = ProcessingPatternEncoding.getProcessingOutputs(tag);
        GenericStack[] condensedInputs = AEPatternHelper.condenseStacks(this.sparseInputs);
        this.inputs = new Input[condensedInputs.length];
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i] = new Input(condensedInputs[i]);
        }
        GenericStack primaryOutput = this.sparseOutputs[0];
        this.condensedOutputs = AEPatternHelper.condenseStacks(this.sparseOutputs);
        int primaryOutputIndex = -1;
        for (int i = 0; i < this.condensedOutputs.length; ++i) {
            if (!primaryOutput.what().equals(this.condensedOutputs[i].what())) continue;
            primaryOutputIndex = i;
        }
        Preconditions.checkState((primaryOutputIndex >= 0 ? 1 : 0) != 0, (Object)"Could not find primary output after condensing stacks.");
        if (primaryOutputIndex > 0) {
            GenericStack condensedPrimaryOutput = this.condensedOutputs[primaryOutputIndex];
            System.arraycopy(this.condensedOutputs, 0, this.condensedOutputs, 1, primaryOutputIndex);
            this.condensedOutputs[0] = condensedPrimaryOutput;
        }
    }

    public int hashCode() {
        return this.definition.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass() && ((AEProcessingPattern)obj).definition.equals(this.definition);
    }

    @Override
    public AEItemKey getDefinition() {
        return this.definition;
    }

    @Override
    public IPatternDetails.IInput[] getInputs() {
        return this.inputs;
    }

    @Override
    public GenericStack[] getOutputs() {
        return this.condensedOutputs;
    }

    @Override
    public GenericStack[] getSparseInputs() {
        return this.sparseInputs;
    }

    @Override
    public GenericStack[] getSparseOutputs() {
        return this.sparseOutputs;
    }

    private static class Input
    implements IPatternDetails.IInput {
        private final GenericStack[] template;
        private final long multiplier;

        private Input(GenericStack stack) {
            this.template = new GenericStack[]{new GenericStack(stack.what(), 1L)};
            this.multiplier = stack.amount();
        }

        @Override
        public GenericStack[] getPossibleInputs() {
            return this.template;
        }

        @Override
        public long getMultiplier() {
            return this.multiplier;
        }

        @Override
        public boolean isValid(AEKey input, Level level) {
            return input.matches(this.template[0]);
        }

        @Override
        @Nullable
        public AEKey getContainerItem(AEKey template) {
            return null;
        }
    }
}

