/*
 * Decompiled with CFR 0.152.
 */
package appeng.init.worldgen;

import appeng.api.features.AEWorldGen;
import appeng.api.features.AEWorldGenType;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.init.worldgen.WorldgenIds;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public final class InitBiomeModifications {
    private InitBiomeModifications() {
    }

    public static void init(BiomeLoadingEvent e) {
        InitBiomeModifications.addQuartzWorldGen(e);
    }

    private static void addQuartzWorldGen(BiomeLoadingEvent e) {
        if (InitBiomeModifications.shouldGenerateIn(e.getName(), AEConfig.instance().isGenerateQuartzOre(), AEWorldGenType.CERTUS_QUARTZ, e.getCategory())) {
            PlacedFeature quartzOrePlaced = InitBiomeModifications.getPlacedFeature(WorldgenIds.QUARTZ_ORE);
            e.getGeneration().m_186664_(GenerationStep.Decoration.UNDERGROUND_ORES, quartzOrePlaced);
        }
    }

    private static PlacedFeature getPlacedFeature(ResourceLocation id) {
        return (PlacedFeature)BuiltinRegistries.f_194653_.m_6612_(id).orElseThrow(() -> new RuntimeException("Placed feature " + id + " is not registered"));
    }

    public static boolean shouldGenerateIn(ResourceLocation id, boolean enabled, AEWorldGenType worldGenType, Biome.BiomeCategory category) {
        if (id == null) {
            return false;
        }
        if (!enabled) {
            AELog.debug("Not generating %s in %s because it is disabled in the config", new Object[]{worldGenType, id});
            return false;
        }
        if (category == Biome.BiomeCategory.THEEND || category == Biome.BiomeCategory.NETHER || category == Biome.BiomeCategory.NONE) {
            AELog.debug("Not generating %s in %s because it's of category %s", new Object[]{worldGenType, id, category});
            return false;
        }
        if (AEWorldGen.isWorldGenDisabledForBiome(worldGenType, id)) {
            AELog.debug("Not generating %s in %s because the biome is blacklisted by another mod or the config", new Object[]{worldGenType, id});
            return false;
        }
        return true;
    }
}

