/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.implementations.items.IGrowableCrystal;
import appeng.core.AEConfig;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import appeng.entity.GrowingCrystalEntity;
import appeng.items.AEBaseItem;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CrystalSeedItem
extends AEBaseItem
implements IGrowableCrystal {
    public static final String TAG_GROWTH_TICKS = "p";
    public static final String TAG_PREVENT_MAGNET = "PreventRemoteMovement";
    public static final int GROWTH_TICKS_REQUIRED = 24000;
    private final ItemLike grownItem;

    public CrystalSeedItem(Item.Properties properties, ItemLike grownItem) {
        super(properties);
        this.grownItem = Objects.requireNonNull(grownItem);
    }

    @Override
    @Nullable
    public ItemStack triggerGrowth(ItemStack is) {
        int growthTicks = CrystalSeedItem.getGrowthTicks(is) + 1;
        if (growthTicks >= 24000) {
            return new ItemStack(this.grownItem, is.m_41613_());
        }
        CrystalSeedItem.setGrowthTicks(is, growthTicks);
        return is;
    }

    public static int getGrowthTicks(ItemStack is) {
        CompoundTag tag = is.m_41783_();
        return tag != null ? tag.m_128451_(TAG_GROWTH_TICKS) : 0;
    }

    public static void setGrowthTicks(ItemStack is, int ticks) {
        ticks = Mth.m_14045_((int)ticks, (int)0, (int)24000);
        is.m_41784_().m_128405_(TAG_GROWTH_TICKS, ticks);
    }

    @Override
    public float getMultiplier(BlockState state, @Nullable Level level, @Nullable BlockPos pos) {
        Tag tag;
        String improvedFluidTagName = AEConfig.instance().getImprovedFluidTag();
        if (improvedFluidTagName != null && (tag = FluidTags.m_144299_().m_13404_(new ResourceLocation(improvedFluidTagName))) != null && state.m_60819_().m_76153_(tag)) {
            return AEConfig.instance().getImprovedFluidMultiplier();
        }
        if (level != null && level.m_46472_() == Level.f_46429_) {
            return state.m_60819_().m_76153_((Tag)FluidTags.f_13132_) ? 1.0f : 0.0f;
        }
        return state.m_60819_().m_76153_((Tag)FluidTags.f_13131_) ? 1.0f : 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        lines.add((Component)Tooltips.of(ButtonToolTips.DoesntDespawn, new Object[0]));
        lines.add((Component)Tooltips.ofPercent((double)CrystalSeedItem.getGrowthTicks(stack) / 24000.0));
        super.m_7373_(stack, level, lines, advancedTooltips);
    }

    public int getEntityLifespan(ItemStack itemStack, Level level) {
        return Integer.MAX_VALUE;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(Level level, Entity location, ItemStack itemstack) {
        GrowingCrystalEntity egc = new GrowingCrystalEntity(level, location.m_20185_(), location.m_20186_(), location.m_20189_(), itemstack);
        egc.m_20256_(location.m_20184_());
        egc.m_32010_(40);
        egc.getPersistentData().m_128379_(TAG_PREVENT_MAGNET, true);
        return egc;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_41389_(group)) {
            items.add((Object)new ItemStack((ItemLike)this, 1));
            ItemStack almostFullGrown = new ItemStack((ItemLike)this, 1);
            CrystalSeedItem.setGrowthTicks(almostFullGrown, 23999);
            items.add((Object)almostFullGrown);
        }
    }
}

