/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.core.settings.TickRates;
import appeng.menu.implementations.IOBusMenu;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackTransferContextImpl;
import appeng.parts.automation.StackWorldBehaviors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ImportBusPart
extends IOBusPart {
    private StackImportStrategy importStrategy;

    public ImportBusPart(IPartItem<?> partItem) {
        super(TickRates.ImportBus, partItem);
    }

    @Override
    protected boolean doBusWork(IGrid grid) {
        if (this.importStrategy == null) {
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos fromPos = self.m_58899_().m_142300_(this.getSide());
            Direction fromSide = this.getSide().m_122424_();
            this.importStrategy = StackWorldBehaviors.createImportFacade((ServerLevel)this.getLevel(), fromPos, fromSide);
        }
        StackTransferContextImpl context = new StackTransferContextImpl(grid.getStorageService(), grid.getEnergyService(), this.source, this.getOperationsPerTick(), this.getFilter());
        this.importStrategy.transfer(context);
        return context.hasDoneWork();
    }

    @Override
    protected MenuType<?> getMenuType() {
        return IOBusMenu.IMPORT_TYPE;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 13.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
    }

    @Override
    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }
}

