/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.StackImportStrategy;
import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.networking.storage.IStorageService;
import appeng.api.stacks.GenericStack;
import appeng.core.AELog;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.automation.HandlerStrategy;
import appeng.util.BlockApiCache;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

class StorageImportStrategy<C, S>
implements StackImportStrategy {
    private final BlockApiCache<C> apiCache;
    private final Direction fromSide;
    private final HandlerStrategy<C, S> conversion;

    public StorageImportStrategy(Capability<C> capability, HandlerStrategy<C, S> conversion, ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.apiCache = BlockApiCache.create(capability, level, fromPos);
        this.fromSide = fromSide;
        this.conversion = conversion;
    }

    @Override
    public boolean transfer(StackTransferContext context) {
        if (!context.isKeyTypeEnabled(this.conversion.getKeyType())) {
            return false;
        }
        C adjacentHandler = this.apiCache.find(this.fromSide);
        if (adjacentHandler == null) {
            return false;
        }
        ExternalStorageFacade adjacentStorage = this.conversion.getFacade(adjacentHandler);
        long remainingTransferAmount = (long)context.getOperationsRemaining() * (long)this.conversion.getKeyType().getAmountPerOperation();
        IStorageService inv = context.getInternalStorage();
        for (int i = 0; i < adjacentStorage.getSlots(); ++i) {
            GenericStack resource = adjacentStorage.getStackInSlot(i);
            if (resource == null || !context.isInFilter(resource.what())) continue;
            long amountForThisResource = inv.getInventory().insert(resource.what(), remainingTransferAmount, Actionable.SIMULATE, context.getActionSource());
            long amount = adjacentStorage.extract(resource.what(), amountForThisResource, Actionable.MODULATE, context.getActionSource());
            if (amount <= 0L) continue;
            long inserted = inv.getInventory().insert(resource.what(), amount, Actionable.MODULATE, context.getActionSource());
            if (inserted < amount) {
                AELog.warn("Extracted %dx%s from adjacent storage and voided it because network refused insert", amount - inserted, resource.what());
            }
            long opsUsed = Math.max(1L, inserted / (long)this.conversion.getKeyType().getAmountPerOperation());
            context.reduceOperationsRemaining(opsUsed);
        }
        return false;
    }

    public static StackImportStrategy createItem(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageImportStrategy<IItemHandler, ItemStack>(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, HandlerStrategy.ITEMS, level, fromPos, fromSide);
    }

    public static StackImportStrategy createFluid(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        return new StorageImportStrategy<IFluidHandler, FluidStack>(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, HandlerStrategy.FLUIDS, level, fromPos, fromSide);
    }
}

