/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class RedstoneP2PTunnelPart
extends P2PTunnelPart<RedstoneP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels("part/p2p/p2p_tunnel_redstone");
    private int power;
    private boolean recursive = false;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public RedstoneP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 0.5f;
    }

    private void setNetworkReady() {
        RedstoneP2PTunnelPart in;
        if (this.isOutput() && (in = (RedstoneP2PTunnelPart)this.getInput()) != null) {
            this.putInput(in.power);
        }
    }

    private void putInput(Object o) {
        int newPower;
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.isOutput() && this.getMainNode().isActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeighbors();
        }
        this.recursive = false;
    }

    private void notifyNeighbors() {
        Level level = this.getBlockEntity().m_58904_();
        Platform.notifyBlocksOfNeighbors(level, this.getBlockEntity().m_58899_());
        for (Direction face : Direction.values()) {
            Platform.notifyBlocksOfNeighbors(level, this.getBlockEntity().m_58899_().m_142300_(face));
        }
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        this.setNetworkReady();
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.power = tag.m_128451_("power");
    }

    @Override
    public void writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128405_("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    @Override
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (!this.isOutput()) {
            BlockPos target = this.getBlockEntity().m_58899_().m_142300_(this.getSide());
            BlockState state = this.getBlockEntity().m_58904_().m_8055_(target);
            Block b = state.m_60734_();
            if (b != null && !this.isOutput()) {
                Direction srcSide = this.getSide();
                if (b instanceof RedStoneWireBlock) {
                    srcSide = Direction.UP;
                }
                this.power = b.m_6378_(state, (BlockGetter)this.getBlockEntity().m_58904_(), target, srcSide);
                this.power = Math.max(this.power, b.m_6378_(state, (BlockGetter)this.getBlockEntity().m_58904_(), target, srcSide));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isOutput() ? this.power : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isOutput() ? this.power : 0;
    }

    private void sendToOutput(int power) {
        for (RedstoneP2PTunnelPart rs : this.getOutputs()) {
            rs.putInput(power);
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

