/*
 * Decompiled with CFR 0.152.
 */
package appeng.server.subcommands;

import appeng.server.ISubCommand;
import appeng.worldgen.meteorite.MeteoriteStructure;
import appeng.worldgen.meteorite.MeteoriteStructurePiece;
import appeng.worldgen.meteorite.PlacedMeteoriteSettings;
import com.google.common.math.StatsAccumulator;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class TestMeteoritesCommand
implements ISubCommand {
    @Override
    public void addArguments(LiteralArgumentBuilder<CommandSourceStack> builder) {
        builder.then(Commands.m_82127_((String)"force").executes(ctx -> {
            TestMeteoritesCommand.test(((CommandSourceStack)ctx.getSource()).m_81377_(), (CommandSourceStack)ctx.getSource(), true);
            return 1;
        }));
    }

    @Override
    public void call(MinecraftServer srv, CommandContext<CommandSourceStack> ctx, CommandSourceStack sender) {
        TestMeteoritesCommand.test(srv, sender, false);
    }

    private static void test(MinecraftServer srv, CommandSourceStack sender, boolean force) {
        BlockPos centerBlock;
        ServerLevel level;
        int radius = 100;
        ServerPlayer player = null;
        try {
            player = sender.m_81375_();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (player != null) {
            level = player.m_183503_();
            centerBlock = new BlockPos(player.m_20185_(), 0.0, player.m_20189_());
        } else {
            level = srv.m_129880_(Level.f_46428_);
            centerBlock = level.m_8900_();
        }
        ChunkPos center = new ChunkPos(centerBlock);
        ChunkGenerator generator = level.m_7726_().m_8481_();
        ArrayList<PlacedMeteoriteSettings> found = new ArrayList<PlacedMeteoriteSettings>();
        int chunksChecked = 0;
        for (int cx = center.f_45578_ - radius; cx <= center.f_45578_ + radius; ++cx) {
            for (int cz = center.f_45579_ - radius; cz <= center.f_45579_ + radius; ++cz) {
                ChunkAccess chunk;
                MeteoriteStructurePiece piece;
                ++chunksChecked;
                ChunkPos cp = new ChunkPos(cx, cz);
                BlockPos p = new BlockPos(cp.m_45604_(), 0, cp.m_45605_());
                BlockPos nearest = generator.m_62161_(level, MeteoriteStructure.INSTANCE, p, 0, false);
                if (nearest == null || (piece = TestMeteoritesCommand.getMeteoritePieceFromChunk(chunk = level.m_46819_(cx, cz, ChunkStatus.f_62315_))) == null) continue;
                found.add(piece.getSettings());
            }
        }
        StatsAccumulator stats = new StatsAccumulator();
        for (PlacedMeteoriteSettings settings2 : found) {
            double closestOther = Double.NaN;
            for (PlacedMeteoriteSettings otherSettings : found) {
                if (otherSettings == settings2) continue;
                double d = settings2.getPos().m_123331_((Vec3i)otherSettings.getPos());
                if (!Double.isNaN(closestOther) && !(d < closestOther)) continue;
                closestOther = d;
            }
            if (Double.isNaN(closestOther)) continue;
            stats.add(Math.sqrt(closestOther));
        }
        found.sort(Comparator.comparingDouble(settings -> settings.getPos().m_123331_((Vec3i)centerBlock)));
        TestMeteoritesCommand.sendLine(sender, "Chunks checked: %d", chunksChecked);
        TestMeteoritesCommand.sendLine(sender, "Meteorites found: %d", found.size());
        if (stats.count() > 0L) {
            TestMeteoritesCommand.sendLine(sender, "Closest: min=%.2f max=%.2f mean=%.2f stddev=%.2f", stats.min(), stats.max(), stats.mean(), stats.populationStandardDeviation());
        }
        int closestCount = Math.min(10, found.size());
        for (int i = 0; i < closestCount; ++i) {
            PlacedMeteoriteSettings settings3 = (PlacedMeteoriteSettings)found.get(i);
            BlockPos pos = settings3.getPos();
            String state = "not final";
            if (force && settings3.getFallout() == null) {
                ChunkAccess chunk = level.m_46865_(pos);
                MeteoriteStructurePiece piece = TestMeteoritesCommand.getMeteoritePieceFromChunk(chunk);
                if (piece == null) {
                    state = "removed";
                } else {
                    settings3 = piece.getSettings();
                    pos = settings3.getPos();
                }
            }
            TextComponent restOfLine = settings3.getFallout() == null ? new TextComponent(String.format(Locale.ROOT, ", radius=%.2f [%s]", Float.valueOf(settings3.getMeteoriteRadius()), state)) : new TextComponent(String.format(Locale.ROOT, ", radius=%.2f, crater=%s, fallout=%s", Float.valueOf(settings3.getMeteoriteRadius()), settings3.getCraterType().name().toLowerCase(), settings3.getFallout().name().toLowerCase()));
            TextComponent msg = new TextComponent(" #" + (i + 1) + " ");
            msg.m_7220_(TestMeteoritesCommand.getClickablePosition(level, settings3, pos)).m_7220_((Component)restOfLine);
            String biomeId = level.m_45837_(pos).map(bk -> bk.m_135782_().toString()).orElse("unknown");
            MutableComponent tooltip = new TextComponent(settings3 + "\nBiome: ").m_6881_().m_130946_(biomeId);
            msg.m_130938_(arg_0 -> TestMeteoritesCommand.lambda$test$3((Component)tooltip, arg_0));
            sender.m_81354_((Component)msg, true);
        }
    }

    private static Component getClickablePosition(ServerLevel level, PlacedMeteoriteSettings settings, BlockPos pos) {
        BlockPos tpPos = pos.m_6630_((int)Math.ceil(settings.getMeteoriteRadius()));
        int surfaceY = level.m_5452_(Heightmap.Types.WORLD_SURFACE, tpPos).m_123342_();
        if (surfaceY > tpPos.m_123342_()) {
            tpPos = new BlockPos(tpPos.m_123341_(), surfaceY, tpPos.m_123343_());
        }
        String displayText = String.format(Locale.ROOT, "pos=%d,%d,%d", tpPos.m_123341_(), tpPos.m_123342_(), tpPos.m_123343_());
        String tpCommand = String.format(Locale.ROOT, "/tp @s %d %d %d", tpPos.m_123341_(), tpPos.m_123342_(), tpPos.m_123343_());
        return new TextComponent(displayText).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, tpCommand)));
    }

    private static MeteoriteStructurePiece getMeteoritePieceFromChunk(ChunkAccess chunk) {
        StructureStart start = chunk.m_7253_(MeteoriteStructure.INSTANCE);
        if (start != null && start.m_73602_().size() > 0 && start.m_73602_().get(0) instanceof MeteoriteStructurePiece) {
            return (MeteoriteStructurePiece)((Object)start.m_73602_().get(0));
        }
        return null;
    }

    private static void sendLine(CommandSourceStack sender, String text, Object ... args) {
        sender.m_81354_((Component)new TextComponent(String.format(Locale.ROOT, text, args)), true);
    }

    private static /* synthetic */ Style lambda$test$3(Component tooltip, Style style) {
        return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)tooltip));
    }
}

