/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.core.definitions.AEBlocks;
import appeng.spatial.SpatialStorageDimensionIds;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryLookupCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.blending.Blender;

public class SpatialStorageChunkGenerator
extends ChunkGenerator {
    public static final int MIN_Y = 0;
    public static final int HEIGHT = 256;
    public static final Codec<SpatialStorageChunkGenerator> CODEC = RegistryLookupCodec.m_135622_((ResourceKey)Registry.f_122885_).xmap(SpatialStorageChunkGenerator::new, SpatialStorageChunkGenerator::getBiomeRegistry).stable().codec();
    private final Registry<Biome> biomeRegistry;
    private final NoiseColumn columnSample;
    private final BlockState defaultBlockState = AEBlocks.MATRIX_FRAME.block().m_49966_();

    public SpatialStorageChunkGenerator(Registry<Biome> biomeRegistry) {
        super((BiomeSource)SpatialStorageChunkGenerator.createBiomeSource(biomeRegistry), SpatialStorageChunkGenerator.createSettings());
        this.biomeRegistry = biomeRegistry;
        Object[] columnSample = new BlockState[256];
        Arrays.fill(columnSample, this.defaultBlockState);
        this.columnSample = new NoiseColumn(0, (BlockState[])columnSample);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    private static FixedBiomeSource createBiomeSource(Registry<Biome> biomeRegistry) {
        return new FixedBiomeSource((Biome)biomeRegistry.m_123013_(SpatialStorageDimensionIds.BIOME_KEY));
    }

    public Registry<Biome> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    private static StructureSettings createSettings() {
        return new StructureSettings(Optional.empty(), Collections.emptyMap());
    }

    public int m_6331_() {
        return 256;
    }

    public int m_142062_() {
        return 0;
    }

    public Climate.Sampler m_183403_() {
        return (i, j, k) -> Climate.m_186781_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
    }

    public void m_183621_(WorldGenRegion region, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        this.fillChunk(chunk);
        chunk.m_8092_(false);
    }

    private void fillChunk(ChunkAccess chunk) {
        BlockPos.MutableBlockPos mutPos = new BlockPos.MutableBlockPos();
        for (int cx = 0; cx < 16; ++cx) {
            mutPos.m_142451_(cx);
            for (int cz = 0; cz < 16; ++cz) {
                mutPos.m_142443_(cz);
                for (int cy = 0; cy < 256; ++cy) {
                    mutPos.m_142448_(cy);
                    chunk.m_6978_((BlockPos)mutPos, this.defaultBlockState, false);
                }
            }
        }
    }

    public int m_6337_() {
        return 0;
    }

    public ChunkGenerator m_6819_(long seed) {
        return this;
    }

    public CompletableFuture<ChunkAccess> m_183489_(Executor executor, Blender blender, StructureFeatureManager structureFeatureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_142647_(int x, int z, Heightmap.Types heightmapType, LevelHeightAccessor levelHeightAccessor) {
        return 0;
    }

    public NoiseColumn m_141914_(int x, int z, LevelHeightAccessor levelHeightAccessor) {
        return this.columnSample;
    }

    public void m_183516_(WorldGenRegion worldGenRegion, long l, BiomeManager biomeManager, StructureFeatureManager structureFeatureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public void m_6929_(WorldGenRegion level) {
    }
}

