/*
 * Decompiled with CFR 0.152.
 */
package appeng.util;

import appeng.api.config.Setting;
import appeng.api.util.IConfigManager;
import appeng.api.util.UnsupportedSettingException;
import appeng.core.AELog;
import appeng.util.IConfigManagerListener;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public final class ConfigManager
implements IConfigManager {
    private final Map<Setting<?>, Enum<?>> settings = new IdentityHashMap();
    @Nullable
    private final IConfigManagerListener listener;

    public ConfigManager(IConfigManagerListener listener) {
        this.listener = listener;
    }

    public ConfigManager() {
        this.listener = null;
    }

    @Override
    public Set<Setting<?>> getSettings() {
        return this.settings.keySet();
    }

    @Override
    public <T extends Enum<T>> void registerSetting(Setting<T> setting, T defaultValue) {
        this.settings.put(setting, defaultValue);
    }

    @Override
    public <T extends Enum<T>> T getSetting(Setting<T> setting) {
        Enum<?> oldValue = this.settings.get(setting);
        if (oldValue == null) {
            throw new UnsupportedSettingException("Setting " + setting.getName() + " is not supported.");
        }
        return (T)((Enum)setting.getEnumClass().cast(oldValue));
    }

    @Override
    public <T extends Enum<T>> void putSetting(Setting<T> setting, T newValue) {
        if (!this.settings.containsKey(setting)) {
            throw new UnsupportedSettingException("Setting " + setting.getName() + " is not supported.");
        }
        this.settings.put(setting, newValue);
        if (this.listener != null) {
            this.listener.onSettingChanged(this, setting);
        }
    }

    @Override
    public void writeToNBT(CompoundTag tagCompound) {
        for (Map.Entry<Setting<?>, Enum<?>> entry : this.settings.entrySet()) {
            tagCompound.m_128359_(entry.getKey().getName(), this.settings.get(entry.getKey()).toString());
        }
    }

    @Override
    public void readFromNBT(CompoundTag tagCompound) {
        for (Setting<?> setting : this.settings.keySet()) {
            try {
                if (!tagCompound.m_128425_(setting.getName(), 8)) continue;
                String value = tagCompound.m_128461_(setting.getName());
                setting.setFromString(this, value);
            }
            catch (IllegalArgumentException e) {
                AELog.debug(e);
            }
        }
    }
}

