/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.blocks;

import com.davenonymous.bonsaitrees3.config.CommonConfig;
import com.davenonymous.bonsaitrees3.registry.SoilCompatibility;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.bonsaitrees3.setup.Registration;
import com.davenonymous.libnonymous.base.BaseBlockEntity;
import com.davenonymous.libnonymous.helper.EnchantmentHelper;
import com.davenonymous.libnonymous.helper.RedstoneMode;
import com.davenonymous.libnonymous.helper.SpawnHelper;
import com.davenonymous.libnonymous.serialization.Store;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;

public class BonsaiPotBlockEntity
extends BaseBlockEntity<BonsaiPotBlockEntity> {
    private SoilInfo soilInfo = null;
    private SaplingInfo saplingInfo = null;
    @Store(sendInUpdatePackage=true)
    public int modelRotation = -1;
    @Store(sendInUpdatePackage=true)
    protected int growTicks;
    @Store(sendInUpdatePackage=true)
    protected int requiredTicks;
    @Store(sendInUpdatePackage=true)
    public RedstoneMode redstoneMode = RedstoneMode.IGNORE_POWER;
    @Store(sendInUpdatePackage=true)
    private final ItemStackHandler soilItemStacks = this.createSoilInputItemHandler();
    private final LazyOptional<IItemHandler> soilItemStackHandler = LazyOptional.of(() -> this.soilItemStacks);
    @Store(sendInUpdatePackage=true)
    private final ItemStackHandler saplingItemStacks = this.createSaplingInputItemHandler();
    @Store
    private final ItemStackHandler outputItemStacks = this.createOutputItemHandler();
    private final LazyOptional<IItemHandler> outputItemStackHandler = LazyOptional.of(() -> this.outputItemStacks);
    @Store(sendInUpdatePackage=true)
    private final ItemStackHandler upgradeItemStacks = this.createUpgradesItemHandler();
    private final LazyOptional<IItemHandler> upgradeItemStackHandler = LazyOptional.of(() -> this.upgradeItemStacks);
    private final LazyOptional<IItemHandler> combinedItemStackHandler = LazyOptional.of(this::createCombinedItemHandler);
    private boolean autoCut = false;
    private boolean hopping = false;
    private boolean hasSilkTouch = false;
    private boolean hasBeeHive = false;
    private int fortune = 0;
    private int efficiency = 0;
    private int hoppingCooldown = 0;
    private int cuttingCooldown = 0;
    public static final ModelProperty<BlockState> SOIL_BLOCK = new ModelProperty();
    public static final ModelProperty<FluidState> FLUID_BLOCK = new ModelProperty();

    public BonsaiPotBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.BONSAI_POT_BLOCKENTITY.get(), pos, state);
    }

    protected void initialize() {
        super.initialize();
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        if (this.modelRotation == -1) {
            this.modelRotation = this.m_58904_().f_46441_.nextInt(4);
        }
    }

    public void tickBoth() {
        super.tickBoth();
        this.updateInfoObjects();
        this.updateGrowth();
    }

    public void tickServer() {
        super.tickServer();
        this.hopOutput();
    }

    public void hopOutput() {
        if (!this.hopping) {
            return;
        }
        if (this.hoppingCooldown > 0) {
            --this.hoppingCooldown;
            return;
        }
        IItemHandler belowHandler = this.getNeighborInventory(Direction.DOWN);
        if (belowHandler == null) {
            return;
        }
        boolean changed = false;
        for (int slot = 0; slot < this.outputItemStacks.getSlots(); ++slot) {
            ItemStack simulatedReturnStack;
            ItemStack stack = this.outputItemStacks.getStackInSlot(slot);
            if (stack.m_41619_() || (simulatedReturnStack = ItemHandlerHelper.insertItemStacked((IItemHandler)belowHandler, (ItemStack)stack, (boolean)true)).equals(stack, false)) continue;
            ItemStack returnStack = ItemHandlerHelper.insertItemStacked((IItemHandler)belowHandler, (ItemStack)stack, (boolean)false);
            this.outputItemStacks.setStackInSlot(slot, returnStack.m_41777_());
            changed = true;
        }
        if (changed) {
            this.m_6596_();
            this.notifyClients(false);
        } else {
            this.hoppingCooldown = (Integer)CommonConfig.hoppingCooldown.get();
        }
    }

    @Nonnull
    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(SOIL_BLOCK, (Object)this.getSoilBlock()).withInitial(FLUID_BLOCK, (Object)this.getFluidBlock()).build();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(1.0).m_82363_(0.0, 1.0, 0.0);
    }

    public boolean hasSoil() {
        ItemStack soilStack = this.soilItemStacks.getStackInSlot(0);
        return !soilStack.m_41619_();
    }

    private void updateSoilBlock() {
        ItemStack soilStack = this.soilItemStacks.getStackInSlot(0);
        if (soilStack.m_41619_()) {
            this.soilInfo = null;
            return;
        }
        this.soilInfo = Registration.RECIPE_HELPER_SOIL.getSoilForItem(this.m_58904_(), soilStack);
    }

    public ItemStack setSoil(ItemStack soilStack) {
        ItemStack result = this.soilItemStacks.insertItem(0, soilStack, false);
        this.updateInfoObjects();
        this.m_6596_();
        this.notifyClients();
        return result;
    }

    public FluidState getFluidBlock() {
        if (this.soilInfo == null) {
            return Fluids.f_76191_.m_76145_();
        }
        return this.soilInfo.fluidState;
    }

    public BlockState getSoilBlock() {
        if (this.soilInfo == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return this.soilInfo.blockState;
    }

    public SoilInfo getSoilInfo() {
        return this.soilInfo;
    }

    public boolean hasSapling() {
        ItemStack saplingStack = this.saplingItemStacks.getStackInSlot(0);
        return !saplingStack.m_41619_();
    }

    public ItemStack getSapling() {
        return this.saplingItemStacks.getStackInSlot(0);
    }

    private void updateSaplingInfo() {
        ItemStack saplingStack = this.saplingItemStacks.getStackInSlot(0);
        if (saplingStack.m_41619_()) {
            this.saplingInfo = null;
            return;
        }
        this.saplingInfo = Registration.RECIPE_HELPER_SAPLING.getSaplingInfoForItem(this.m_58904_(), saplingStack);
    }

    public ItemStack setSapling(ItemStack saplingStack) {
        ItemStack result = this.saplingItemStacks.insertItem(0, saplingStack, false);
        this.updateInfoObjects();
        this.growTicks = 0;
        this.modelRotation = this.m_58904_() != null ? this.m_58904_().f_46441_.nextInt(4) : 0;
        this.m_6596_();
        this.notifyClients();
        return result;
    }

    public SaplingInfo getSaplingInfo() {
        return this.saplingInfo;
    }

    private void updateModules() {
        this.hopping = false;
        this.autoCut = false;
        this.hasSilkTouch = false;
        this.hasBeeHive = false;
        this.fortune = 0;
        this.efficiency = 0;
        for (int slot = 0; slot < this.upgradeItemStacks.getSlots(); ++slot) {
            ItemStack stack = this.upgradeItemStacks.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            if (stack.m_150930_(Blocks.f_50717_.m_5456_()) || stack.m_150930_(Blocks.f_50718_.m_5456_())) {
                this.hasBeeHive = true;
            }
            if (stack.m_150930_(Blocks.f_50332_.m_5456_())) {
                this.hopping = true;
            }
            if (stack.m_41720_().canPerformAction(stack, ToolActions.AXE_DIG) && (!stack.m_41763_() || stack.m_41773_() < stack.m_41776_())) {
                this.autoCut = true;
            }
            EnchantmentHelper enchantmentHelper = new EnchantmentHelper(stack);
            if (((Boolean)CommonConfig.sumEnchantmentLevels.get()).booleanValue()) {
                this.fortune += enchantmentHelper.getLevel(Enchantments.f_44987_);
                this.efficiency += enchantmentHelper.getLevel(Enchantments.f_44984_);
            } else {
                this.fortune = Math.max(this.fortune, enchantmentHelper.getLevel(Enchantments.f_44987_));
                this.efficiency = Math.max(this.efficiency, enchantmentHelper.getLevel(Enchantments.f_44984_));
            }
            this.hasSilkTouch = this.hasSilkTouch || enchantmentHelper.has(Enchantments.f_44985_);
        }
        this.hopping = (Boolean)CommonConfig.enableHoppingUpgrade.get() != false && this.hopping;
        this.autoCut = (Boolean)CommonConfig.enableAutoCuttingUpgrade.get() != false && this.autoCut;
        this.fortune = (Boolean)CommonConfig.enableFortuneUpgrade.get() != false ? this.fortune : 0;
        this.efficiency = (Boolean)CommonConfig.enableEfficiencyUpgrade.get() != false ? this.efficiency : 0;
    }

    protected void updateInfoObjects() {
        this.updateSaplingInfo();
        this.updateSoilBlock();
        this.updateModules();
        if (this.soilInfo != null && this.saplingInfo != null) {
            int ticks = this.saplingInfo.getRequiredTicks();
            float soilModifier = this.soilInfo.getTickModifier();
            this.requiredTicks = (int)Math.ceil((float)ticks * soilModifier);
            if (this.efficiency > 0) {
                this.requiredTicks = (int)((double)this.requiredTicks - Math.floor((float)ticks * 0.05f * (float)this.efficiency));
            }
        } else {
            this.requiredTicks = Integer.MAX_VALUE;
        }
    }

    public boolean cutTree(boolean isAutoCut) {
        if (this.saplingInfo == null || this.soilInfo == null) {
            this.updateInfoObjects();
        }
        if (this.saplingInfo == null || this.soilInfo == null || this.m_58904_() == null) {
            return false;
        }
        if (this.growTicks < this.requiredTicks) {
            return false;
        }
        if (this.m_58904_().m_5776_()) {
            return false;
        }
        boolean hasNeigborSignal = this.m_58904_().m_46753_(this.m_58899_());
        if (this.redstoneMode == RedstoneMode.REQUIRE_POWER && !hasNeigborSignal) {
            return false;
        }
        if (this.redstoneMode == RedstoneMode.REJECT_POWER && hasNeigborSignal) {
            return false;
        }
        if (isAutoCut && ((Boolean)CommonConfig.autoCuttingDamagesItems.get()).booleanValue()) {
            boolean shouldTakeDamage;
            boolean bl = shouldTakeDamage = this.f_58857_.f_46441_.nextDouble() <= (Double)CommonConfig.autoCuttingDamageChance.get();
            if (shouldTakeDamage) {
                for (int slotNum = 0; slotNum < this.getUpgradeItemStacks().getSlots(); ++slotNum) {
                    ItemStack stack = this.getUpgradeItemStacks().getStackInSlot(slotNum);
                    if (stack.m_41619_() || !stack.m_41720_().canPerformAction(stack, ToolActions.AXE_DIG)) continue;
                    if (!stack.m_41629_(1, this.f_58857_.f_46441_, null)) break;
                    stack.m_41774_(1);
                    stack.m_41721_(0);
                    break;
                }
            }
        }
        List<ItemStack> drops = this.saplingInfo.getRandomizedDrops(this.m_58904_().f_46441_, this.fortune, this.hasSilkTouch, this.hasBeeHive);
        boolean allFit = true;
        for (ItemStack stack : drops) {
            ItemStack insertedStack = ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputItemStacks, (ItemStack)stack, (boolean)true);
            if (!insertedStack.m_150930_(stack.m_41720_()) || insertedStack.m_41613_() != stack.m_41613_()) continue;
            allFit = false;
            break;
        }
        if (allFit) {
            for (ItemStack stack : drops) {
                ItemHandlerHelper.insertItemStacked((IItemHandler)this.outputItemStacks, (ItemStack)stack, (boolean)false);
            }
            this.setGrowTicks(0);
            this.modelRotation = this.m_58904_().f_46441_.nextInt(4);
            this.m_6596_();
            this.notifyClients();
            return true;
        }
        return false;
    }

    public boolean isGrowing() {
        return this.hasSapling() && this.growTicks < this.requiredTicks;
    }

    public double getProgress() {
        if (!this.hasSapling() || !this.hasSoil() || this.requiredTicks == 0) {
            return 0.0;
        }
        return (double)this.growTicks / (double)this.requiredTicks;
    }

    public double getProgress(float partialTicks) {
        if (!this.hasSapling() || !this.hasSoil() || this.requiredTicks == 0) {
            return 0.0;
        }
        double result = ((double)this.growTicks + (double)partialTicks) / (double)this.requiredTicks;
        if (result >= 0.999) {
            result = 1.0;
        }
        return result;
    }

    public void updateGrowth() {
        if (!this.hasSapling() || !this.hasSoil()) {
            this.setGrowTicks(0);
            return;
        }
        if (SoilCompatibility.INSTANCE.isReady && !SoilCompatibility.INSTANCE.canTreeGrowOnSoil(this.saplingInfo, this.soilInfo)) {
            this.setGrowTicks(0);
            return;
        }
        if (this.m_58904_() != null && this.getProgress() >= 1.0 && this.autoCut) {
            if (this.cuttingCooldown > 0) {
                --this.cuttingCooldown;
            } else {
                boolean success = this.cutTree(true);
                if (!success) {
                    this.cuttingCooldown = (Integer)CommonConfig.cuttingCooldown.get();
                }
            }
        }
        if (this.getProgress() < 1.0) {
            this.setGrowTicks(this.growTicks + 1);
        }
    }

    public void setGrowTicks(int growTicks) {
        this.growTicks = growTicks;
        this.m_6596_();
    }

    public void boostProgress() {
        if (!this.isGrowing()) {
            return;
        }
        this.growTicks += this.requiredTicks / 4;
        if (this.growTicks >= this.requiredTicks) {
            this.growTicks = this.requiredTicks;
        }
        this.notifyClients();
    }

    public void onDataLoaded() {
        if (this.f_58857_ != null) {
            this.updateInfoObjects();
            if (this.f_58857_ instanceof ClientLevel) {
                ModelDataManager.requestModelDataRefresh((BlockEntity)this);
            }
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
    }

    public ItemStackHandler getUpgradeItemStacks() {
        return this.upgradeItemStacks;
    }

    public ItemStackHandler getSaplingItemStacks() {
        return this.saplingItemStacks;
    }

    public ItemStackHandler getSoilItemStacks() {
        return this.soilItemStacks;
    }

    public ItemStackHandler getOutputItemStacks() {
        return this.outputItemStacks;
    }

    public static boolean isUpgradeItem(ItemStack stack) {
        EnchantmentHelper enchantments;
        if (stack.m_150930_(Blocks.f_50332_.m_5456_())) {
            return true;
        }
        if (stack.m_150930_(Blocks.f_50718_.m_5456_()) || stack.m_150930_(Blocks.f_50717_.m_5456_())) {
            return true;
        }
        if (stack.m_41720_().canPerformAction(stack, ToolActions.AXE_DIG)) {
            return true;
        }
        return stack.m_41720_() instanceof EnchantedBookItem && (enchantments = new EnchantmentHelper(stack)).hasAny(new Enchantment[]{Enchantments.f_44985_, Enchantments.f_44987_, Enchantments.f_44984_});
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == null) {
                return this.combinedItemStackHandler.cast();
            }
            if (side == Direction.UP) {
                return this.upgradeItemStackHandler.cast();
            }
            if (side == Direction.DOWN) {
                return this.outputItemStackHandler.cast();
            }
            return this.soilItemStackHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    private ItemStackHandler createSoilInputItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                SoilInfo soilInfo = Registration.RECIPE_HELPER_SOIL.getSoilForItem(BonsaiPotBlockEntity.this.f_58857_, stack);
                return soilInfo != null;
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
                BonsaiPotBlockEntity.this.updateInfoObjects();
                BonsaiPotBlockEntity.this.notifyClients();
            }
        };
    }

    @Nonnull
    private ItemStackHandler createSaplingInputItemHandler() {
        return new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                SaplingInfo saplingInfo = Registration.RECIPE_HELPER_SAPLING.getSaplingInfoForItem(BonsaiPotBlockEntity.this.f_58857_, stack);
                return saplingInfo != null;
            }

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                ItemStack previous = this.getStackInSlot(slot);
                if (!ItemStack.m_150942_((ItemStack)previous, (ItemStack)stack)) {
                    BonsaiPotBlockEntity.this.growTicks = 0;
                    BonsaiPotBlockEntity.this.m_6596_();
                    BonsaiPotBlockEntity.this.notifyClients();
                }
                super.setStackInSlot(slot, stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
                BonsaiPotBlockEntity.this.updateInfoObjects();
                BonsaiPotBlockEntity.this.notifyClients();
            }
        };
    }

    @Nonnull
    private ItemStackHandler createOutputItemHandler() {
        return new ItemStackHandler(6){

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
            }
        };
    }

    private ItemStackHandler createUpgradesItemHandler() {
        return new ItemStackHandler(4){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return BonsaiPotBlockEntity.isUpgradeItem(stack);
            }

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                BonsaiPotBlockEntity.this.m_6596_();
                BonsaiPotBlockEntity.this.notifyClients();
            }
        };
    }

    @Nonnull
    private IItemHandler createCombinedItemHandler() {
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{this.soilItemStacks, this.saplingItemStacks, this.upgradeItemStacks}){

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.f_41583_;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return stack;
            }
        };
    }

    public void dropItemStackContents() {
        if (this.m_58904_() == null || this.m_58904_().m_5776_()) {
            return;
        }
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.upgradeItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.outputItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.soilItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
        SpawnHelper.dropItemHandlerContents((IItemHandler)this.saplingItemStacks, (Level)this.m_58904_(), (BlockPos)this.m_58899_());
    }
}

