/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.client;

import com.davenonymous.bonsaitrees3.blocks.BonsaiPotBlockEntity;
import com.davenonymous.bonsaitrees3.client.TreeModels;
import com.davenonymous.bonsaitrees3.config.ClientConfig;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.libnonymous.render.MultiModelBlockRenderer;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class BonsaiPotRenderer
implements BlockEntityRenderer<BonsaiPotBlockEntity> {
    public static final ResourceLocation WATER = new ResourceLocation("minecraft", "block/water_still");

    public BonsaiPotRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BonsaiPotBlockEntity pPotBlock, float pPartialTick, PoseStack poseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (!pPotBlock.hasSapling() || !pPotBlock.hasSoil()) {
            return;
        }
        if (pPotBlock.m_58904_() == null) {
            return;
        }
        SaplingInfo saplingInfo = pPotBlock.getSaplingInfo();
        if (saplingInfo == null) {
            return;
        }
        Boolean renderItemInstead = (Boolean)ClientConfig.alwaysRenderAsItem.get();
        MultiblockBlockModel multiBlock = TreeModels.get(saplingInfo.m_6423_());
        if (multiBlock == null) {
            renderItemInstead = true;
        }
        float scaleRatio = 1.0f;
        if (!renderItemInstead.booleanValue()) {
            scaleRatio = (float)multiBlock.getScaleRatio(true);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, (double)0.1f, 0.5);
        poseStack.m_85841_(scaleRatio, scaleRatio, scaleRatio);
        float maxSize = 0.9f;
        poseStack.m_85841_(maxSize, maxSize, maxSize);
        float progress = (float)pPotBlock.getProgress(pPartialTick);
        poseStack.m_85841_(progress, progress, progress);
        if (renderItemInstead.booleanValue()) {
            Block blockToRender;
            if (saplingInfo.ingredient != null && saplingInfo.ingredient.m_43908_().length > 0 && (blockToRender = Block.m_49814_((Item)saplingInfo.ingredient.m_43908_()[0].m_41720_())) != Blocks.f_50016_) {
                poseStack.m_85841_(maxSize, maxSize, maxSize);
                poseStack.m_85837_(-0.5, 0.0, -0.5);
                Minecraft.m_91087_().m_91289_().renderSingleBlock(blockToRender.m_49966_(), poseStack, pBufferSource, pPackedLight, pPackedOverlay, (IModelData)EmptyModelData.INSTANCE);
            }
        } else {
            float rotate = (float)pPotBlock.modelRotation * 90.0f;
            poseStack.m_85845_(new Quaternion(Vector3f.f_122225_, rotate, true));
            float translateOffsetX = (float)(multiBlock.width + 1) / 2.0f;
            float translateOffsetY = 0.0f;
            float translateOffsetZ = (float)(multiBlock.depth + 1) / 2.0f;
            poseStack.m_85837_((double)(-translateOffsetX), (double)(-translateOffsetY), (double)(-translateOffsetZ));
            RenderType rendertype = RenderType.m_110466_();
            if (Minecraft.m_91087_().f_91066_.f_92115_.m_90773_() >= GraphicsStatus.FABULOUS.m_90773_()) {
                rendertype = RenderType.m_110463_();
            }
            VertexConsumer buffer = pBufferSource.m_6299_(rendertype);
            MultiModelBlockRenderer.renderMultiBlockModel((MultiblockBlockModel)multiBlock, (BlockAndTintGetter)pPotBlock.m_58904_(), (VertexConsumer)buffer, (PoseStack)poseStack, (int)pPackedLight);
        }
        poseStack.m_85849_();
    }
}

