/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.bonsaitrees3.compat.jei;

import com.davenonymous.bonsaitrees3.client.TreeModels;
import com.davenonymous.bonsaitrees3.config.CommonConfig;
import com.davenonymous.bonsaitrees3.registry.SoilCompatibility;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingDrop;
import com.davenonymous.bonsaitrees3.registry.sapling.SaplingInfo;
import com.davenonymous.bonsaitrees3.registry.soil.SoilInfo;
import com.davenonymous.libnonymous.render.MultiModelBlockRenderer;
import com.davenonymous.libnonymous.serialization.MultiblockBlockModel;
import com.davenonymous.libnonymous.utils.TickTimeHelper;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.lwjgl.opengl.GL11;

public class BonsaiRecipeWrapper
implements IRecipeCategoryExtension,
ITooltipCallback<ItemStack> {
    SaplingInfo sapling;
    public float[] slotChances;
    public SaplingDrop[] slotDrop;
    public Map<ResourceLocation, Float> tickModifiers;
    public static ITickTimer tickTimer = null;

    public BonsaiRecipeWrapper(SaplingInfo sapling) {
        this.sapling = sapling;
    }

    public void drawInfo(int recipeWidth, int recipeHeight, PoseStack pose, double mouseX, double mouseY) {
        MultiblockBlockModel model = TreeModels.get(this.sapling.m_6423_());
        if (model == null) {
            return;
        }
        pose.m_85836_();
        pose.m_85837_(50.0, 20.0, 100.0);
        pose.m_85841_(36.0f, 36.0f, 36.0f);
        float scale = (float)model.getScaleRatio(true);
        pose.m_85841_(scale, scale, scale);
        pose.m_85845_(Quaternion.m_175225_((Vector3f)new Vector3f(155.0f, 1.0f, 0.0f)));
        if (tickTimer != null) {
            pose.m_85845_(Quaternion.m_175225_((Vector3f)new Vector3f(0.0f, (float)tickTimer.getValue(), 0.0f)));
        }
        pose.m_85837_((double)((float)(model.width + 1) / -2.0f), (double)((float)(model.height + 1) / -2.0f), (double)((float)(model.depth + 1) / -2.0f));
        MultiBufferSource.BufferSource bufferSource = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer buffer = bufferSource.m_6299_(RenderType.m_110463_());
        GL11.glFrontFace((int)2304);
        MultiModelBlockRenderer.renderMultiBlockModel((MultiblockBlockModel)model, (BlockAndTintGetter)Minecraft.m_91087_().f_91073_, (VertexConsumer)buffer, (PoseStack)pose, (int)0xF000F0);
        bufferSource.m_109911_();
        GL11.glFrontFace((int)2305);
        pose.m_85849_();
    }

    public void onTooltip(int slot, boolean isInput, ItemStack stack, List<Component> tooltip) {
        if (stack.m_41619_()) {
            return;
        }
        if (isInput) {
            if (slot == 0) {
                String timeToGrow = TickTimeHelper.getDuration((int)this.sapling.baseTicks);
                tooltip.add(tooltip.size() - 1, (Component)new TextComponent(ChatFormatting.YELLOW + I18n.m_118938_((String)"jei.bonsaitrees3.growtime", (Object[])new Object[]{timeToGrow})));
            }
            if (slot == 1) {
                float tickModifier = this.tickModifiers.getOrDefault(stack.m_41720_().getRegistryName(), Float.valueOf(1.0f)).floatValue();
                String timeToGrow = TickTimeHelper.getDuration((int)((int)((float)this.sapling.baseTicks * tickModifier)));
                tooltip.add(tooltip.size() - 1, (Component)new TextComponent(ChatFormatting.YELLOW + I18n.m_118938_((String)"jei.bonsaitrees3.soiltime", (Object[])new Object[]{timeToGrow})));
            }
        } else {
            if (((Boolean)CommonConfig.showChanceInJEI.get()).booleanValue()) {
                tooltip.add(tooltip.size() - 1, (Component)new TextComponent(ChatFormatting.YELLOW + I18n.m_118938_((String)"jei.bonsaitrees3.chance", (Object[])new Object[]{(int)(this.slotDrop[slot - 2].chance * 100.0f)})));
            }
            if (this.slotDrop[slot - 2].requiresSilkTouch) {
                tooltip.add(tooltip.size() - 1, (Component)new TextComponent(ChatFormatting.RED + I18n.m_118938_((String)"jei.bonsaitrees3.requiresSilkTouch", (Object[])new Object[0])));
            }
            if (this.slotDrop[slot - 2].requiresBees) {
                tooltip.add(tooltip.size() - 1, (Component)new TextComponent(ChatFormatting.RED + I18n.m_118938_((String)"jei.bonsaitrees3.requiresBees", (Object[])new Object[0])));
            }
        }
    }

    public void setIngredients(IIngredients iIngredients) {
        ArrayList<List<Object>> inputs = new ArrayList<List<Object>>();
        inputs.add(Collections.singletonList(this.sapling.ingredient.m_43908_()[0]));
        this.tickModifiers = new HashMap<ResourceLocation, Float>();
        ArrayList<ItemStack> soilStacks = new ArrayList<ItemStack>();
        for (SoilInfo soil : SoilCompatibility.INSTANCE.getValidSoilsForSapling(this.sapling)) {
            ItemStack representation = soil.ingredient.m_43908_()[0];
            this.tickModifiers.put(representation.m_41720_().getRegistryName(), Float.valueOf(soil.getTickModifier()));
            soilStacks.add(representation);
        }
        inputs.add(soilStacks);
        iIngredients.setInputLists(VanillaTypes.ITEM, inputs);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        this.slotChances = new float[this.sapling.drops.size()];
        this.slotDrop = new SaplingDrop[this.sapling.drops.size()];
        int slot = 0;
        for (SaplingDrop drop : this.sapling.drops) {
            ItemStack dropStack = drop.resultStack.m_41777_();
            dropStack.m_41764_(drop.rolls);
            drops.add(dropStack);
            this.slotChances[slot] = drop.chance;
            this.slotDrop[slot] = drop;
            ++slot;
        }
        iIngredients.setOutputs(VanillaTypes.ITEM, drops);
    }
}

