/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curiousshulkerboxes.common.capability;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioShulkerBox
implements ICurio {
    private static final String ANIMATION_TAG = "Animation";
    private static final String PROGRESS_TAG = "Progress";
    private static final String OLD_PROGRESS_TAG = "OldProgress";
    protected ItemStack stack;
    protected Object model;
    private ShulkerBoxBlockEntity.AnimationStatus animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
    private float progress;
    private float progressOld;

    public CurioShulkerBox(ItemStack stack) {
        this.stack = stack;
    }

    public void setAnimationStatus(ShulkerBoxBlockEntity.AnimationStatus status) {
        this.animationStatus = status;
    }

    public float getProgress(float partialTicks) {
        return this.progressOld + (this.progress - this.progressOld) * partialTicks;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public void curioTick(SlotContext slotContext) {
        this.progressOld = this.progress;
        switch (this.animationStatus) {
            case CLOSED: {
                this.progress = 0.0f;
                break;
            }
            case OPENING: {
                this.progress += 0.1f;
                if (!(this.progress >= 1.0f)) break;
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENED;
                this.progress = 1.0f;
                break;
            }
            case CLOSING: {
                this.progress -= 0.1f;
                if (!(this.progress <= 0.0f)) break;
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
                this.progress = 0.0f;
                break;
            }
            case OPENED: {
                this.progress = 1.0f;
            }
        }
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext) {
        return new ICurio.SoundInfo(SoundEvents.f_12408_, 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(SlotContext slotContext) {
        return true;
    }

    public boolean canSync(SlotContext slotContext) {
        return true;
    }

    @Nonnull
    public CompoundTag writeSyncData(SlotContext slotContext) {
        CompoundTag compound = new CompoundTag();
        int state = switch (this.animationStatus) {
            case ShulkerBoxBlockEntity.AnimationStatus.OPENING -> 1;
            case ShulkerBoxBlockEntity.AnimationStatus.CLOSING -> 2;
            case ShulkerBoxBlockEntity.AnimationStatus.OPENED -> 3;
            default -> 0;
        };
        compound.m_128405_(ANIMATION_TAG, state);
        compound.m_128350_(PROGRESS_TAG, this.progress);
        compound.m_128350_(OLD_PROGRESS_TAG, this.progressOld);
        return compound;
    }

    public void readSyncData(SlotContext slotContext, CompoundTag compound) {
        int state = compound.m_128451_(ANIMATION_TAG);
        switch (state) {
            case 0: {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSED;
                break;
            }
            case 1: {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENING;
                break;
            }
            case 2: {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.CLOSING;
                break;
            }
            case 3: {
                this.animationStatus = ShulkerBoxBlockEntity.AnimationStatus.OPENED;
            }
        }
        this.progress = compound.m_128457_(PROGRESS_TAG);
        this.progressOld = compound.m_128457_(OLD_PROGRESS_TAG);
    }
}

