/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;

public class MahouLightningBoltEntity
extends Entity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private final boolean effectOnly;
    @Nullable
    private ServerPlayer caster;
    public static final String entityName = "sky_lightning_bolt_entity";

    public MahouLightningBoltEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
        this.f_19811_ = true;
        this.lightningState = 2;
        this.boltVertex = this.f_19796_.nextLong();
        this.boltLivingTime = this.f_19796_.nextInt(3) + 1;
        this.effectOnly = true;
        Difficulty difficulty = world.m_46791_();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public MahouLightningBoltEntity(Level world) {
        super(ModEntities.LIGHTNING_BOLT, world);
        this.f_19811_ = true;
        this.lightningState = 2;
        this.boltVertex = this.f_19796_.nextLong();
        this.boltLivingTime = this.f_19796_.nextInt(3) + 1;
        this.effectOnly = true;
        Difficulty difficulty = world.m_46791_();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public MahouLightningBoltEntity(Level worldIn, double x, double y, double z, boolean effectOnlyIn) {
        super(ModEntities.LIGHTNING_BOLT, worldIn);
        this.f_19811_ = true;
        this.m_7678_(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.f_19796_.nextLong();
        this.boltLivingTime = this.f_19796_.nextInt(3) + 1;
        this.effectOnly = effectOnlyIn;
        Difficulty difficulty = worldIn.m_46791_();
        if (difficulty == Difficulty.NORMAL || difficulty == Difficulty.HARD) {
            this.igniteBlocks(4);
        }
    }

    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    public void setCaster(@Nullable ServerPlayer casterIn) {
        this.caster = casterIn;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.lightningState == 2) {
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.nextFloat() * 0.2f);
            this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.nextFloat() * 0.2f);
        }
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.m_146870_();
            } else if (this.lightningState < -this.f_19796_.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.f_19796_.nextLong();
                this.igniteBlocks(0);
            }
        }
        if (this.lightningState >= 0) {
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_6580_(2);
            } else if (!this.effectOnly) {
                double d0 = 3.0;
                List list = this.f_19853_.m_6249_((Entity)this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), Entity::m_6084_);
                for (Entity entity : list) {
                    LightningBolt fake = (LightningBolt)EntityType.f_20465_.m_20615_(this.f_19853_);
                    if (fake == null) continue;
                    fake.m_20219_(new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()));
                    fake.m_20874_(false);
                    if (ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBolt)fake)) continue;
                    entity.m_8038_((ServerLevel)this.f_19853_, fake);
                    entity.m_7311_(0);
                }
                if (this.caster != null) {
                    CriteriaTriggers.f_10554_.m_21721_(this.caster, (Collection)list);
                }
            }
        }
    }

    private void igniteBlocks(int extraIgnitions) {
        if (MTConfig.EMRYS_BOLT_FIRE && !this.effectOnly && !this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46131_)) {
            BlockState blockstate = Blocks.f_50083_.m_49966_();
            BlockPos blockpos = new BlockPos(this.m_20182_());
            if (this.f_19853_.m_8055_(blockpos).m_60795_() && blockstate.m_60710_((LevelReader)this.f_19853_, blockpos)) {
                this.f_19853_.m_46597_(blockpos, blockstate);
            }
            for (int i = 0; i < extraIgnitions; ++i) {
                BlockPos blockpos1 = blockpos.m_142082_(this.f_19796_.nextInt(3) - 1, this.f_19796_.nextInt(3) - 1, this.f_19796_.nextInt(3) - 1);
                if (!this.f_19853_.m_8055_(blockpos1).m_60795_() || !blockstate.m_60710_((LevelReader)this.f_19853_, blockpos1)) continue;
                this.f_19853_.m_46597_(blockpos1, blockstate);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_6783_(double distance) {
        double d0 = 64.0 * MahouLightningBoltEntity.m_20150_();
        return distance < d0 * d0;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag compound) {
    }

    protected void m_7380_(CompoundTag compound) {
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

