/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class MorganBallEntity
extends Entity {
    private static final String TAG_SPHERE_SIZE = "MAHOUTSUKAI_SPHERE_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_COLOR_R2 = "MAHOUTSUKAI_COLOR_R2";
    private static final String TAG_COLOR_G2 = "MAHOUTSUKAI_COLOR_G2";
    private static final String TAG_COLOR_B2 = "MAHOUTSUKAI_COLOR_B2";
    private static final String TAG_DISTANCE = "MAHOUTSUKAI_DISTANCE";
    private static final String TAG_SPIKE_LENGTH = "MAHOUTSUKAI_SPIKE_LENGTH";
    private static final String TAG_TARGETS = "MAHOUTSUKAI_TARGETS";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> SPHERE_SIZE = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R2 = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G2 = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B2 = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DISTANCE = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> SPIKE_LENGTH = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<CompoundTag> TARGETS = SynchedEntityData.m_135353_(MorganBallEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
    public LivingEntity caster;
    public float damage;
    public int dyingTicks = 0;
    public float prev_spike_len;
    public float prev_sphere_size;
    ArrayList<LivingEntity> targets;
    public ArrayList<Float> yaws;
    public ArrayList<Float> pitchs;
    public ArrayList<Float> ds;
    public int m = 0;
    public int earlydeath = 0;
    public float rate = 0.4f;
    public static final String entityName = "morgan_ball_entity";
    public float maxsize = 1.3f;

    public MorganBallEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MorganBallEntity(Level world) {
        super(ModEntities.MORGAN_BALL, world);
        this.f_19811_ = true;
    }

    public MorganBallEntity(Level world, LivingEntity c, float r, float g, float b, float a, float r2, float g2, float b2, float size, float damage) {
        this(world);
        this.setColor(r, g, b, a, r2, g2, b2);
        this.sizer(size);
        this.caster = c;
        this.damage = damage;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(SPHERE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_R2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B2, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DISTANCE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPIKE_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGETS, (Object)new CompoundTag());
    }

    public void m_8119_() {
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
        Vec3 newpos = this.m_20182_().m_82549_(this.m_20184_());
        BlockPos pos = new BlockPos(newpos.m_82549_(this.m_20184_().m_82490_((double)this.getSphereSize())));
        if (this.f_19853_.m_8055_(pos).m_60795_()) {
            this.m_6021_(newpos.f_82479_, newpos.f_82480_, newpos.f_82481_);
        }
        if (!this.f_19853_.f_46443_) {
            if (this.caster == null || !(this.caster.m_21205_().m_41720_() instanceof Morgan)) {
                this.m_146870_();
                return;
            }
            if (this.dyingTicks <= 0) {
                if (this.earlydeath > 0) {
                    this.setSphereSize(this.getSphereSize() - 0.04f);
                    if (this.getSphereSize() <= 0.0f) {
                        this.m_146870_();
                    }
                } else {
                    this.setSphereSize(Math.min(this.maxsize, this.getSphereSize() + 0.02f));
                }
                if (this.m_20182_().m_82557_(this.caster.m_20182_()) > (double)(MTConfig.MORGAN_MAX_BALL_RANGE * MTConfig.MORGAN_MAX_BALL_RANGE)) {
                    this.m_20256_(this.m_20184_().m_82490_((double)0.3f));
                } else {
                    this.m_20256_(this.m_20184_().m_82490_((double)1.02f));
                }
                if (this.caster.m_21205_().m_41720_() instanceof Morgan && !(this.caster.m_21211_().m_41720_() instanceof Morgan)) {
                    if (this.getSphereSize() > 1.0f && this.earlydeath <= 0) {
                        ++this.dyingTicks;
                    } else {
                        ++this.earlydeath;
                    }
                }
            } else {
                if (this.targets == null) {
                    int radius = MTConfig.MORGAN_SPIKE_RANGE;
                    AABB aabb = new AABB(this.m_20185_() - (double)radius, this.m_20186_() - (double)radius, this.m_20189_() - (double)radius, this.m_20185_() + (double)radius, this.m_20186_() + (double)radius, this.m_20189_() + (double)radius);
                    List ts = this.f_19853_.m_6443_(LivingEntity.class, aabb, a -> !a.equals((Object)this.caster));
                    this.targets = new ArrayList();
                    for (LivingEntity t : ts) {
                        this.targets.add(t);
                    }
                    this.setDataTargets(this.setTargets(this.targets));
                } else if (this.m > 6) {
                    this.setSpikeLength(Math.max(0.0f, this.getSpikeLength() - this.rate));
                    if (this.getSpikeLength() == 0.0f) {
                        ++this.earlydeath;
                    }
                    if (this.earlydeath > 0) {
                        this.setSphereSize(this.getSphereSize() - 0.04f);
                        if (this.getSphereSize() <= 0.0f) {
                            this.m_146870_();
                        }
                    }
                    if (this.m == 7) {
                        ArrayList<LivingEntity> spikeTargets = this.getTargets(this.getDataTargets());
                        for (LivingEntity s : spikeTargets) {
                            if (ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.caster.m_142081_(), (Entity)s)) continue;
                            EffectUtil.magicAttack(s, this.damage / (float)spikeTargets.size(), this.caster);
                            Vec3 d = s.m_20299_(1.0f).m_82546_(this.m_20182_());
                            MorganBallEntity.boop((Entity)s, (float)d.m_82553_() / 4.0f, d.f_82479_, d.f_82480_, d.f_82481_);
                        }
                    }
                    ++this.m;
                } else if (this.getSpikeLength() >= 1.0f) {
                    ++this.m;
                } else {
                    this.setSpikeLength(this.getSpikeLength() + this.rate);
                }
                ++this.dyingTicks;
            }
        } else {
            ArrayList<LivingEntity> spikeTargets = this.getTargets(this.getDataTargets());
            this.yaws = new ArrayList();
            this.pitchs = new ArrayList();
            this.ds = new ArrayList();
            for (LivingEntity e : spikeTargets) {
                this.addYawPitchDist(e);
            }
        }
        this.prev_spike_len = this.getSpikeLength();
        this.prev_sphere_size = this.getSphereSize();
    }

    public void addYawPitchDist(LivingEntity e) {
        if (e != null) {
            Vec3 v = e.m_20299_(1.0f).m_82546_(this.m_20182_());
            float d = (float)v.m_82553_() + 1.5f;
            v = v.m_82541_();
            float pitch = (float)Math.asin(-v.f_82480_);
            float yaw = (float)Math.atan2(v.f_82479_, v.f_82481_);
            this.yaws.add(Float.valueOf(EffectUtil.toDegrees(yaw)));
            this.pitchs.add(Float.valueOf(EffectUtil.toDegrees(pitch) + 90.0f));
            this.ds.add(Float.valueOf(d));
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public void m_6123_(Player entityIn) {
    }

    public void setColor(float r, float g, float b, float a, float r2, float g2, float b2) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_R2, (Object)Float.valueOf(r2));
        this.f_19804_.m_135381_(COLOR_G2, (Object)Float.valueOf(g2));
        this.f_19804_.m_135381_(COLOR_B2, (Object)Float.valueOf(b2));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_R2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G2)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B2)).floatValue()};
    }

    protected void m_20101_() {
    }

    @Nullable
    public AABB m_142469_() {
        return ZERO_AABB;
    }

    public void sizer(float s) {
        this.setSphereSize(s);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setSphereSize(compound.m_128457_(TAG_SPHERE_SIZE));
        this.setSpikeLength(compound.m_128457_(TAG_SPIKE_LENGTH));
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A), compound.m_128457_(TAG_COLOR_R2), compound.m_128457_(TAG_COLOR_G2), compound.m_128457_(TAG_COLOR_B2));
        this.setDistance(compound.m_128457_(TAG_DISTANCE));
        this.setDataTargets(compound.m_128469_(TAG_TARGETS));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_SPHERE_SIZE, this.getSphereSize());
        compound.m_128350_(TAG_SPIKE_LENGTH, this.getSpikeLength());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128350_(TAG_COLOR_R2, colors[4]);
        compound.m_128350_(TAG_COLOR_G2, colors[5]);
        compound.m_128350_(TAG_COLOR_B2, colors[6]);
        compound.m_128350_(TAG_DISTANCE, this.getDistance());
        compound.m_128365_(TAG_TARGETS, (Tag)this.getDataTargets());
    }

    public AABB m_6921_() {
        return bb;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getSphereSize() {
        return ((Float)this.f_19804_.m_135370_(SPHERE_SIZE)).floatValue();
    }

    public void setSphereSize(float s) {
        this.f_19804_.m_135381_(SPHERE_SIZE, (Object)Float.valueOf(s));
    }

    public float getSpikeLength() {
        return ((Float)this.f_19804_.m_135370_(SPIKE_LENGTH)).floatValue();
    }

    public void setSpikeLength(float s) {
        this.f_19804_.m_135381_(SPIKE_LENGTH, (Object)Float.valueOf(s));
    }

    public ArrayList<LivingEntity> getTargets(CompoundTag nbt) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        if (nbt != null) {
            int k = 0;
            while (nbt.m_128441_("target" + k)) {
                Entity e = this.f_19853_.m_6815_(nbt.m_128451_("target" + k));
                if (e instanceof LivingEntity) {
                    lst.add((LivingEntity)e);
                }
                ++k;
            }
        }
        return lst;
    }

    public CompoundTag setTargets(ArrayList<LivingEntity> targets) {
        CompoundTag nbt = new CompoundTag();
        for (int k = 0; k < targets.size(); ++k) {
            if (!targets.get(k).m_6084_()) continue;
            nbt.m_128405_("target" + k, targets.get(k).m_142049_());
        }
        return nbt;
    }

    public CompoundTag getDataTargets() {
        return (CompoundTag)this.f_19804_.m_135370_(TARGETS);
    }

    public void setDataTargets(CompoundTag nbt) {
        this.f_19804_.m_135381_(TARGETS, (Object)nbt);
    }

    public float getDistance() {
        return ((Float)this.f_19804_.m_135370_(DISTANCE)).floatValue();
    }

    public void setDistance(float d) {
        this.f_19804_.m_135381_(DISTANCE, (Object)Float.valueOf(d));
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.m_20256_(new Vec3(motionX, motionY, motionZ));
    }
}

