/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class FallenDownEntity
extends Entity {
    Player player;
    public static final String entityName = "fallen_down_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(FallenDownEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.m_135353_(FallenDownEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Boolean> FIRED = SynchedEntityData.m_135353_(FallenDownEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;

    public FallenDownEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(ModEntities.FALLEN_DOWN, worldIn);
        this.f_19811_ = true;
    }

    public FallenDownEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public FallenDownEntity(Level world) {
        super(ModEntities.FALLEN_DOWN, world);
        this.f_19811_ = true;
    }

    public FallenDownEntity(Level world, LivingEntity caster) {
        this(world);
        this.setCasterUUID(caster.m_142081_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(FIRED, (Object)false);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setFired(compound.m_128471_(TAG_FIRED));
        if (compound.m_128403_(TAG_CASTER)) {
            this.setCasterUUID(compound.m_128342_(TAG_CASTER));
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128379_(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.m_128362_(TAG_CASTER, this.getCasterUUID());
        }
    }

    public float getGrowingLife() {
        return 50.0f;
    }

    public void m_8119_() {
        int radius = Math.min(this.getLife() / 20 + 1, 30);
        radius = MTConfig.FALLEN_DOWN_RADIUS;
        if (!this.f_19853_.f_46443_ && ServerHandler.tickCounter % 4L == 0L) {
            ServerPlayer caster = null;
            if (this.f_19853_.m_142572_() != null) {
                caster = this.f_19853_.m_142572_().m_6846_().m_11259_(this.getCasterUUID());
            }
            int mana = MTConfig.FALLEN_DOWN_MANA_PER_TICK;
            if (caster == null || !(caster.m_21211_().m_41720_() instanceof FallenDownSpellScroll) && !(caster.m_21211_().m_41720_() instanceof MysticCode)) {
                this.m_146870_();
            }
            if (caster == null) {
                this.m_146870_();
                return;
            }
            if (PlayerManaManager.drainMana((Player)caster, mana, false, false, true, false) == mana && this.getLife() > 20) {
                ((ServerLevel)this.f_19853_).f_46438_ = Math.min((float)this.getLife() / 40.0f, 4.8f);
                AABB aabb = new AABB((double)(this.m_142538_().m_123341_() - radius), 0.0, (double)(this.m_142538_().m_123343_() - radius), (double)(this.m_142538_().m_123341_() + radius), 255.0, (double)(this.m_142538_().m_123343_() + radius));
                List lst = this.f_19853_.m_6249_((Entity)this, aabb, a -> a instanceof LivingEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.getCasterUUID(), a) && a.m_20096_());
                ArrayList<BlockPos> blocksBreak = new ArrayList<BlockPos>();
                ArrayList<BlockPos> blocksFall = new ArrayList<BlockPos>();
                for (Entity e : lst) {
                    Vec3 motion = e.m_20184_();
                    double motionX = motion.m_7096_();
                    double motionY = motion.m_7098_();
                    double motionZ = motion.m_7094_();
                    motionX *= 0.2;
                    motionY = motionY > 0.0 ? (motionY *= 0.2) : (motionY *= 1.7);
                    motionZ *= 0.2;
                    BlockPos ep = e.m_142538_();
                    int break_radius = 3;
                    int depth = 4;
                    for (int i = -break_radius - 1; i <= break_radius; ++i) {
                        for (int j = -break_radius - 1; j <= break_radius; ++j) {
                            BlockPos tmp;
                            int k;
                            int m = 0;
                            if (i * i + j * j >= break_radius * break_radius) continue;
                            for (k = ep.m_123342_() - depth; k < ep.m_123342_(); ++k) {
                                tmp = new BlockPos(ep.m_123341_() + i, k, ep.m_123343_() + j);
                                if (!FallenDownEntity.okToBreak(this.f_19853_.m_8055_(tmp), this.f_19853_, tmp)) continue;
                                if (m >= depth / 2) {
                                    blocksFall.add(tmp);
                                } else {
                                    blocksBreak.add(tmp);
                                }
                                ++m;
                            }
                            k = (int)((float)ep.m_123342_() + e.m_20206_());
                            while ((float)k < (float)ep.m_123342_() + e.m_20206_() + (float)(depth / 2)) {
                                tmp = new BlockPos(ep.m_123341_() + i, k, ep.m_123343_() + j);
                                blocksFall.add(tmp);
                                ++k;
                            }
                        }
                    }
                }
                this.tryFakeExplosionFallenDown(blocksBreak, (Player)caster, (ServerLevel)this.f_19853_, "", false, false);
                this.tryFakeExplosionFallenDown(blocksFall, (Player)caster, (ServerLevel)this.f_19853_, "", false, true);
            }
        }
        this.setLife(this.getLife() + 1);
    }

    public void tryFakeExplosionFallenDown(List<BlockPos> affected, Player caster, ServerLevel world, String name, boolean drop, boolean fall) {
        if (caster == null && this.player == null) {
            this.player = new SafeFakePlayer(world, name);
        } else if (caster != null) {
            this.player = caster;
        }
        Collections.shuffle(affected);
        FakeExplosion explosion = new FakeExplosion((Level)world, (Entity)this.player, this.player.m_20185_(), this.player.m_20186_(), this.player.m_20189_(), 10.0f, affected);
        ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(this.player.f_19853_, (Explosion)explosion, new ArrayList());
        MinecraftForge.EVENT_BUS.post((Event)ee);
        int limit = 0;
        if (!ee.isCanceled()) {
            for (BlockPos p : ee.getAffectedBlocks()) {
                if (limit >= MTConfig.FALLEN_DOWN_BLOCK_BREAK_PER_TICK) break;
                BlockState bs = this.player.f_19853_.m_8055_(p);
                if (!FallenDownEntity.okToBreak(bs, this.player.f_19853_, p)) continue;
                if (!fall) {
                    if (drop) {
                        Block.m_49892_((BlockState)bs, (LevelAccessor)world, (BlockPos)p, (BlockEntity)world.m_7702_(p));
                    }
                    this.player.f_19853_.m_7471_(p, false);
                    this.player.f_19853_.m_46597_(p, Blocks.f_50016_.m_49966_());
                } else if (world.m_46859_(p.m_7495_()) || FallingBlock.m_53241_((BlockState)world.m_8055_(p.m_7495_())) && p.m_123342_() >= 0) {
                    FallingBlockEntity fallingblockentity = new FallingBlockEntity((Level)world, (double)p.m_123341_() + 0.5, (double)p.m_123342_(), (double)p.m_123343_() + 0.5, world.m_8055_(p));
                    world.m_7967_((Entity)fallingblockentity);
                }
                ++limit;
            }
        }
    }

    public static boolean okToBreak(BlockState bs, Level w, BlockPos p) {
        return bs.m_60734_() != Blocks.f_50752_ && !bs.m_60795_() && w.m_7702_(p) == null;
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.f_19804_.m_135370_(FIRED);
    }

    public void setFired(boolean f) {
        this.f_19804_.m_135381_(FIRED, (Object)f);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

