/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.networking.BeamPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticStaffBeamMahoujinEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_BEAM_SIZE = "MAHOUTSUKAI_BEAM_SIZE";
    private static final String TAG_BEAM_LENGTH = "MAHOUTSUKAI_BEAM_LENGTH";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_SPHERE_SIZE = "MAHOUTSUKAI_SPHERE_SIZE";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_DYING = "MAHOUTSUKAI_DYING";
    public float prev_beam_size;
    public float prev_beam_len;
    public float prev_sphere_size;
    public float prev_mini_roll;
    public static int dyingticks = 6;
    public double prevx;
    public double prevy;
    public double prevz;
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BEAM_SIZE = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> BEAM_LENGTH = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> SPHERE_SIZE = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_R = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_G = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_B = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COLOR_A = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DYING = SynchedEntityData.m_135353_(MysticStaffBeamMahoujinEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String entityName = "mahoujin_beam_entity";
    Player caster = null;

    public MysticStaffBeamMahoujinEntity(PlayMessages.SpawnEntity packet, Level worldIn) {
        super(ModEntities.BEAM_MAHOUJIN, worldIn);
        this.f_19811_ = true;
    }

    public MysticStaffBeamMahoujinEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public MysticStaffBeamMahoujinEntity(Level world) {
        super(ModEntities.BEAM_MAHOUJIN, world);
        this.f_19811_ = true;
    }

    public MysticStaffBeamMahoujinEntity(Level world, Player caster, float r, float g, float b) {
        this(world);
        this.caster = caster;
        this.setCaster(caster.m_142081_());
        this.setColor(r, g, b, 1.0f);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(BEAM_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(BEAM_LENGTH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COLOR_R, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_G, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_B, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(COLOR_A, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(SPHERE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CASTER, Optional.of(UUID.randomUUID()));
        this.f_19804_.m_135372_(DYING, (Object)0);
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19859_ = this.f_19857_;
        boolean circle_size_min_time = false;
        int circle_size_max_time = 15;
        int mini_speed_min_time = 15;
        int mini_speed_max_time = 35;
        int sphere_size_min_time = 25;
        int sphere_size_max_time = 35;
        int beam_size_min_time = 40;
        int beam_size_max_time = 45;
        int beam_len_min_time = 40;
        int beam_len_max_time = 45;
        float goal_circle_size = 1.5f;
        float goal_mini_speed = 6.0f;
        float goal_beam_size = 0.7f;
        float goal_beam_len = 64.0f;
        float goal_sphere_size = 0.7f;
        this.prev_beam_size = this.getBeamSize();
        this.prev_beam_len = this.getBeamLength();
        this.prev_sphere_size = this.getSphereSize();
        this.prev_mini_roll = this.getRotationRoll();
        if (this.getLife() == sphere_size_min_time - 3 && !this.f_19853_.f_46443_) {
            for (ServerPlayer p : ((ServerLevel)this.f_19853_).m_6907_()) {
                if (p.f_19853_ != this.f_19853_) continue;
                PacketHandler.sendTo(p, new BeamPacket(this.m_142049_()));
            }
        }
        if (this.getCaster() != null && this.caster == null) {
            this.caster = this.f_19853_.m_46003_(this.getCaster());
        }
        if (this.caster != null && this.getDying() <= 0) {
            this.casterPosition(false);
            if (!(this.caster.m_21211_().m_41720_() instanceof MysticStaff)) {
                this.setDying(1);
                MahouTsukaiMod.proxy.speedUp();
            }
            if (this.getLife() == beam_len_min_time + 1) {
                this.boopCaster();
                if (this.caster instanceof ServerPlayer) {
                    ModTriggers.BEAM.trigger((ServerPlayer)this.caster);
                }
            } else if (this.getLife() < beam_len_min_time + 1 || this.getLife() > beam_len_max_time + 4) {
                this.holdCaster();
            }
        } else if (this.getDying() <= 0) {
            this.setDying(1);
        }
        int life = this.getLife();
        this.setCircleSize(goal_circle_size);
        if (this.getDying() <= 0) {
            this.setRotationSpeed(life < mini_speed_min_time ? 0.0f : (life > mini_speed_max_time ? goal_mini_speed : goal_mini_speed * ((float)life - (float)mini_speed_min_time) / ((float)mini_speed_max_time - (float)mini_speed_min_time)));
            this.setBeamSize(life < beam_size_min_time ? 0.0f : (life > beam_size_max_time ? goal_beam_size : goal_beam_size * ((float)life - (float)beam_size_max_time) / ((float)beam_size_max_time - (float)beam_size_min_time)));
            this.setSphereSize(life < sphere_size_min_time ? 0.0f : (life > sphere_size_max_time ? goal_sphere_size : goal_sphere_size * ((float)life - (float)sphere_size_min_time) / ((float)sphere_size_max_time - (float)sphere_size_min_time)));
            this.setBeamLength(life < beam_len_min_time ? 0.0f : (life > beam_len_max_time ? goal_beam_len : goal_beam_len * ((float)life - (float)beam_len_min_time) / ((float)beam_len_max_time - (float)beam_len_min_time)));
            this.setRotationSpeed(Math.max(this.getRotationSpeed(), 0.0f));
            this.setBeamSize(Math.max(this.getBeamSize(), 0.0f));
            this.setSphereSize(Math.max(this.getSphereSize(), 0.0f));
            this.setBeamLength(Math.max(this.getBeamLength(), 0.0f));
        } else {
            float factor = ((float)dyingticks - 1.0f) / (float)dyingticks;
            this.setRotationSpeed(factor * this.getRotationSpeed());
            this.setBeamSize(factor * this.getBeamSize());
            this.setSphereSize(factor * this.getSphereSize());
            if (this.getDying() > dyingticks * 3) {
                this.m_146870_();
            }
            this.setDying(this.getDying() + 1);
        }
        this.setRotationYaw(this.getRotationYaw() % 360.0f);
        if (this.getRotationYaw() < 0.0f) {
            this.setRotationYaw(this.getRotationYaw() + 360.0f);
        }
        if (this.getRotationYaw() > 360.0f) {
            this.setRotationYaw(this.getRotationYaw() - 360.0f);
        }
        this.setLife(this.getLife() + 1);
        this.setRotationRoll(this.getRotationRoll() + this.getRotationSpeed());
        if (!this.f_19853_.f_46443_ && this.getDying() <= 0 && this.getLife() > beam_len_min_time) {
            this.bakuretsu(beam_len_min_time);
        }
    }

    public void holdCaster() {
        this.caster.m_20334_(0.0, 0.0, 0.0);
        this.caster.f_19864_ = true;
    }

    public void boopCaster() {
        double strength = 0.03;
        this.caster.f_19812_ = true;
        Vec3 v = this.caster.m_20154_();
        float f = Mth.m_14116_((float)((float)(v.f_82479_ * v.f_82479_ + v.f_82481_ * v.f_82481_ + v.f_82480_ * v.f_82480_)));
        double motionX = 0.0;
        double motionZ = 0.0;
        double motionY = 0.0;
        motionX -= v.f_82479_ / (double)f * strength;
        motionZ -= v.f_82481_ / (double)f * strength;
        motionY -= v.f_82480_ / (double)f * strength;
        if (this.caster.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.1) {
                motionY = 0.1;
            }
        }
        this.caster.m_20334_(motionX, motionY, motionZ);
        this.caster.f_19864_ = true;
    }

    public void bakuretsu(int beam_start) {
        IMahou mahou;
        int mana = MTConfig.MYSTIC_STAFF_BEAM_MANA_PER_TICK;
        int seconds = (this.getLife() - beam_start) / 20;
        double damage = MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_FACTOR;
        if (MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_SCALES && (mahou = Utils.getPlayerMahou(this.caster)) != null) {
            damage *= (double)mahou.getMaxMana();
        }
        for (int i = 0; i < seconds; ++i) {
            damage *= MTConfig.MYSTIC_STAFF_BEAM_DAMAGE_ACCELERATION;
        }
        if (PlayerManaManager.drainMana(this.caster, mana, false, false) == mana) {
            HashSet<BlockPos> blocks = new HashSet<BlockPos>();
            int blockspertick = MTConfig.MYSTIC_STAFF_BEAM_MAX_BLOCK_BREAK_PER_TICK;
            float pt = this.getRotationPitch();
            float yw = this.getRotationYaw();
            Vec3 direction = Vec3.m_82498_((float)(90.0f - pt), (float)(360.0f - yw + 180.0f)).m_82541_();
            Vec3 pos = this.m_20182_();
            boolean keepbreaking = true;
            ArrayList<Entity> lst = new ArrayList<Entity>();
            for (float i = 0.0f; i < this.getBeamLength(); i += 1.0f) {
                Vec3 diskcenter = pos.m_82549_(direction.m_82490_((double)i));
                AABB aabb = new AABB(new BlockPos(diskcenter).m_142082_(-2, -2, -2), new BlockPos(diskcenter).m_142082_(2, 2, 2));
                for (Entity e : this.f_19853_.m_6249_((Entity)null, aabb, Entity::m_6084_)) {
                    if (e == this.caster || e instanceof MysticStaffBeamMahoujinEntity || !(e instanceof LivingEntity) || ContractMahoujinTileEntity.isImmuneToSpell(this.f_19853_, this.getCaster(), e)) continue;
                    lst.add(e);
                }
                if (blocks.size() >= blockspertick) {
                    keepbreaking = false;
                }
                if (!keepbreaking) continue;
                for (int j = -3; j <= 3; ++j) {
                    for (int k = -3; k <= 3; ++k) {
                        for (int m = -3; m <= 3; ++m) {
                            BlockPos p = new BlockPos((double)j + diskcenter.f_82479_, (double)k + diskcenter.f_82480_, (double)m + diskcenter.f_82481_);
                            if (!(p.m_123299_(diskcenter.f_82479_, diskcenter.f_82480_, diskcenter.f_82481_, true) <= 7.0)) continue;
                            BlockState bs = this.f_19853_.m_8055_(p);
                            boolean whitelisted = false;
                            if (MTConfig.MYSTIC_STAFF_BEAM_BLOCK_WHITELIST.size() > 0) {
                                whitelisted = EffectUtil.inBlockBlacklist(bs.m_60734_(), MTConfig.MYSTIC_STAFF_BEAM_BLOCK_WHITELIST);
                            }
                            if (bs.m_60795_() || whitelisted) continue;
                            blocks.add(p);
                        }
                    }
                }
            }
            EffectUtil.tryFakeExplosion(new ArrayList<BlockPos>(blocks), this.caster, "mahou_beam", false, lst);
            for (Entity e : lst) {
                EffectUtil.magicAttack((LivingEntity)e, (float)damage, (LivingEntity)this.caster);
            }
        } else {
            this.setDying(1);
        }
    }

    public void casterPosition(boolean casterpos) {
        this.prevx = this.m_20185_();
        this.prevy = this.m_20186_();
        this.prevz = this.m_20189_();
        this.f_19860_ = this.getRotationPitch();
        this.f_19859_ = this.getRotationYaw();
        this.setRotationPitch(90.0f - this.caster.f_19858_);
        this.setRotationYaw(360.0f - this.caster.f_19857_ + 180.0f);
        this.f_19857_ = this.getRotationYaw();
        this.f_19858_ = this.getRotationPitch();
        if (casterpos) {
            Vec3 v = this.caster.m_20154_().m_82490_((double)1.4f).m_82549_(this.caster.m_20299_(1.0f));
            this.m_6034_(v.f_82479_, v.f_82480_, v.f_82481_);
        }
    }

    public void setColor(float r, float g, float b, float a) {
        this.f_19804_.m_135381_(COLOR_R, (Object)Float.valueOf(r));
        this.f_19804_.m_135381_(COLOR_G, (Object)Float.valueOf(g));
        this.f_19804_.m_135381_(COLOR_B, (Object)Float.valueOf(b));
        this.f_19804_.m_135381_(COLOR_A, (Object)Float.valueOf(a));
    }

    public float[] getColor() {
        return new float[]{((Float)this.f_19804_.m_135370_(COLOR_R)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_G)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_B)).floatValue(), ((Float)this.f_19804_.m_135370_(COLOR_A)).floatValue()};
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setRotationYaw(compound.m_128457_(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.m_128457_(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.m_128457_(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.m_128457_("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setCircleSize(compound.m_128457_("MAHOUTSUKAI_ROTATION_SPEED"));
        this.setLife(compound.m_128451_(TAG_LIFE));
        this.setBeamSize(compound.m_128457_(TAG_BEAM_SIZE));
        this.setBeamLength(compound.m_128457_(TAG_BEAM_LENGTH));
        this.setCaster(compound.m_128342_(TAG_CASTER));
        this.setColor(compound.m_128457_(TAG_COLOR_R), compound.m_128457_(TAG_COLOR_G), compound.m_128457_(TAG_COLOR_B), compound.m_128457_(TAG_COLOR_A));
        this.setDying(compound.m_128451_(TAG_DYING));
        this.setSphereSize(compound.m_128457_(TAG_SPHERE_SIZE));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.m_128350_(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.m_128350_(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.m_128350_("MAHOUTSUKAI_ROTATION_SPEED", this.getRotationSpeed());
        compound.m_128350_("MAHOUTSUKAI_ROTATION_SPEED", this.getCircleSize());
        compound.m_128405_(TAG_LIFE, this.getLife());
        compound.m_128362_(TAG_CASTER, this.getCaster());
        compound.m_128350_(TAG_BEAM_LENGTH, this.getBeamLength());
        compound.m_128350_(TAG_BEAM_SIZE, this.getBeamSize());
        float[] colors = this.getColor();
        compound.m_128350_(TAG_COLOR_R, colors[0]);
        compound.m_128350_(TAG_COLOR_G, colors[1]);
        compound.m_128350_(TAG_COLOR_B, colors[2]);
        compound.m_128350_(TAG_COLOR_A, colors[3]);
        compound.m_128350_(TAG_SPHERE_SIZE, this.getSphereSize());
        compound.m_128405_(TAG_DYING, this.getDying());
    }

    protected void m_20101_() {
    }

    @Nullable
    public AABB m_142469_() {
        return ZERO_AABB;
    }

    public void m_7334_(Entity entityIn) {
    }

    public AABB m_6921_() {
        return ZERO_AABB;
    }

    public boolean m_6783_(double distance) {
        return true;
    }

    public boolean m_6000_(double x, double y, double z) {
        return true;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getRotationYaw() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.f_19804_.m_135381_(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.f_19804_.m_135381_(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.f_19804_.m_135381_(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.f_19804_.m_135381_(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.f_19804_.m_135370_(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.f_19804_.m_135381_(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public float getBeamSize() {
        return ((Float)this.f_19804_.m_135370_(BEAM_SIZE)).floatValue();
    }

    public void setBeamSize(float b) {
        this.f_19804_.m_135381_(BEAM_SIZE, (Object)Float.valueOf(b));
    }

    public float getBeamLength() {
        return ((Float)this.f_19804_.m_135370_(BEAM_LENGTH)).floatValue();
    }

    public void setBeamLength(float b) {
        this.f_19804_.m_135381_(BEAM_LENGTH, (Object)Float.valueOf(b));
    }

    public UUID getCaster() {
        return ((Optional)this.f_19804_.m_135370_(CASTER)).orElse(UUID.fromString("00000000-0000-0000-0000-000000000000"));
    }

    public void setCaster(UUID uuid) {
        this.f_19804_.m_135381_(CASTER, Optional.of(uuid));
    }

    public int getDying() {
        return (Integer)this.f_19804_.m_135370_(DYING);
    }

    public void setDying(int d) {
        this.f_19804_.m_135381_(DYING, (Object)d);
    }

    public float getSphereSize() {
        return ((Float)this.f_19804_.m_135370_(SPHERE_SIZE)).floatValue();
    }

    public void setSphereSize(float d) {
        this.f_19804_.m_135381_(SPHERE_SIZE, (Object)Float.valueOf(d));
    }
}

