/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class RhongomyniadEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_STACK = "MAHOUTSUKAI_STACK";
    private static final AABB ZERO_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AABB bb = new AABB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final EntityDataAccessor<Float> ROTATION_YAW = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_ROLL = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_PITCH = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ROTATION_SPEED = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> CIRCLE_SIZE = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> LIFE = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<UUID>> CASTER_UUID = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<ItemStack> STACK = SynchedEntityData.m_135353_(RhongomyniadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final String entityName = "rhongomyniad_entity";

    public RhongomyniadEntity(EntityType entityEntityType, Level world) {
        super(entityEntityType, world);
    }

    public RhongomyniadEntity(Level world) {
        super(ModEntities.RHONGOMYNIAD, world);
        this.f_19811_ = true;
    }

    public RhongomyniadEntity(Level world, Player caster, float size, ItemStack stack) {
        this(world);
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(caster.m_142081_()));
        this.sizer(size);
        this.setStack(stack);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_SPEED, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(LIFE, (Object)0);
        this.f_19804_.m_135372_(CASTER_UUID, Optional.empty());
        this.f_19804_.m_135372_(STACK, (Object)ItemStack.f_41583_);
    }

    public static void rhongomyniadRightClick(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getPlayer();
        Entity e = event.getTarget();
        if (e instanceof RhongomyniadEntity) {
            RhongomyniadEntity re = (RhongomyniadEntity)e;
            if (!re.f_19853_.f_46443_ && re.getCasterUUID() != null && player.m_142081_().equals(re.getCasterUUID())) {
                if (re.getStack() != null && re.m_6084_()) {
                    re.f_19853_.m_7967_((Entity)new ItemEntity(re.f_19853_, re.m_20185_(), re.m_20186_(), re.m_20189_(), re.getStack()));
                    re.m_146870_();
                } else {
                    re.m_146870_();
                }
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.f_19859_ = this.f_19857_;
        if (this.f_19859_ < 0.0f) {
            this.f_19859_ += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.f_19857_ = this.getRotationYaw();
        this.f_19858_ = this.getRotationPitch();
        this.m_19915_(this.f_19857_, this.f_19858_);
        if (!this.f_19853_.f_46443_) {
            this.setLife(this.getLife() + 1);
            if (this.getLife() % 40 == 0) {
                float range = 20.0f;
                if (RhongomyniadEntity.operate(this.f_19853_, this.getCasterUUID(), this.m_142538_())) {
                    AABB aabb = new AABB(this.m_20185_() - (double)range, this.m_20186_() - (double)range, this.m_20189_() - (double)range, this.m_20185_() + (double)range, this.m_20186_() + (double)range, this.m_20189_() + (double)range);
                    List lst = this.f_19853_.m_45976_(LivingEntity.class, aabb);
                    int max_smites = MTConfig.RHONGOMYNIAD_MAX_SMITES;
                    int smites = 0;
                    for (LivingEntity e : lst) {
                        boolean immune;
                        if (smites >= max_smites) continue;
                        boolean bl = immune = MTConfig.RHONGOMYNIAD_RESPECT_IMMUNE && ContractMahoujinTileEntity.isImmuneToSpell(e.f_19853_, this.getCasterUUID(), (Entity)e);
                        if (!Caliburn.specialTarget(e) || immune) continue;
                        RhongomyniadEntity.strike(e, this);
                        ++smites;
                    }
                }
            }
        }
    }

    public static void strike(LivingEntity e, RhongomyniadEntity rhongo) {
        if (Utils.getLanceMahou(rhongo.getStack()) != null) {
            float damage = Utils.getLanceMahou(rhongo.getStack()).getAttackDamage();
            SmiteEntity smite = new SmiteEntity(e.f_19853_, e, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, damage);
            smite.m_6034_(e.m_20185_(), e.m_20186_(), e.m_20189_());
            e.f_19853_.m_7967_((Entity)smite);
        }
    }

    public static boolean operate(Level world, UUID casterUUID, BlockPos pos) {
        int mana_drain = MTConfig.RHONGOMYNIAD_MANA_COST;
        if (casterUUID != null && pos != null && world != null) {
            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(pos, world, casterUUID, mana_drain);
            Player caster = world.m_46003_(casterUUID);
            if (nearbyBatteriesGaveMana || caster != null && PlayerManaManager.drainMana(caster, mana_drain, false, true) == mana_drain) {
                return true;
            }
        }
        return false;
    }

    public static void rhongomyniadLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().m_7639_();
        if (source instanceof LivingEntity && !Caliburn.specialTarget(target)) {
            float range = MTConfig.RHONGOMYNIAD_RANGE;
            AABB aabb = new AABB(source.m_20185_() - (double)range, source.m_20186_() - (double)range, source.m_20189_() - (double)range, source.m_20185_() + (double)range, source.m_20186_() + (double)range, source.m_20189_() + (double)range);
            List lst = target.f_19853_.m_45976_(RhongomyniadEntity.class, aabb);
            for (RhongomyniadEntity e : lst) {
                boolean immune = MTConfig.RHONGOMYNIAD_RESPECT_IMMUNE && ContractMahoujinTileEntity.isImmuneToSpell(e.f_19853_, e.getCasterUUID(), source);
                if (immune || !RhongomyniadEntity.operate(source.f_19853_, e.getCasterUUID(), e.m_142538_())) continue;
                RhongomyniadEntity.strike((LivingEntity)source, e);
            }
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_6123_(Player entityIn) {
    }

    protected void m_20101_() {
    }

    public UUID getCasterUUID() {
        return ((Optional)this.f_19804_.m_135370_(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.f_19804_.m_135381_(CASTER_UUID, Optional.of(uuid));
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void m_7378_(CompoundTag compound) {
        this.setRotationYaw(compound.m_128457_(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.m_128457_(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.m_128457_(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.m_128457_(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.m_128457_(TAG_CIRCLE_SIZE));
        this.setLife(compound.m_128451_(TAG_LIFE));
        if (compound.m_128403_(TAG_CASTER)) {
            this.setCasterUUID(compound.m_128342_(TAG_CASTER));
        }
        if (compound.m_128441_(TAG_STACK)) {
            ItemStack stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)compound.m_128423_(TAG_STACK)));
            stack.m_41764_(1);
            this.setStack(stack);
        }
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128350_(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.m_128350_(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.m_128350_(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.m_128350_(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.m_128350_(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.m_128405_(TAG_LIFE, this.getLife());
        if (this.getCasterUUID() != null) {
            compound.m_128362_(TAG_CASTER, this.getCasterUUID());
        }
        if (this.getStack() != null) {
            compound.m_128365_(TAG_STACK, (Tag)this.getStack().serializeNBT());
        }
    }

    public AABB m_6921_() {
        return bb;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getRotationYaw() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.f_19804_.m_135381_(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.f_19804_.m_135381_(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.f_19804_.m_135381_(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.f_19804_.m_135370_(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.f_19804_.m_135381_(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.f_19804_.m_135370_(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.f_19804_.m_135381_(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.f_19804_.m_135370_(LIFE);
    }

    public void setLife(int l) {
        this.f_19804_.m_135381_(LIFE, (Object)l);
    }

    public ItemStack getStack() {
        return (ItemStack)this.f_19804_.m_135370_(STACK);
    }

    public void setStack(ItemStack s) {
        this.f_19804_.m_135381_(STACK, (Object)s);
    }
}

