/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.morgan;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouStorage;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.settingsmahou.MahouSettings;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.MorganRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class Morgan
extends SwordItem {
    protected String name = "morgan";
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_morgan_attack";
    public static String MT_ATTACK_CAP = "mahoutsukai_morgan_innate_cap";
    public static HashMap<UUID, MorganStorage> staffs = new HashMap();

    public Morgan() {
        super((Tier)Tiers.IRON, 3, -2.4f, new Item.Properties().m_41491_(ModItems.MAHOUTSUKAI_CREATIVE_TAB).m_41503_(MTConfig.POWER_CONSOLIDATION_DURABILITY));
        this.setRegistryName(this.name);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Morgan.setattacktonbt(stack, worldIn);
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CaliburnMahouProvider();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.POWER_CONSOLIDATION_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        if (ret == null) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            return (CompoundTag)CaliburnMahouStorage.writeNBT(mahou);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, Level world) {
        if (stack != null && !world.f_46443_) {
            ICaliburnMahou mahou;
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if ((mahou = Utils.getCaliburnMahou(stack)) != null) {
                nbt.m_128350_(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
                nbt.m_128347_(MT_ATTACK_CAP, mahou.getInnateCap());
            }
            stack.m_41751_(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        ICaliburnMahou mahou;
        CompoundTag nbt;
        if (stack != null && stack.m_41782_() && (nbt = stack.m_41783_()) != null && nbt.m_128441_(MT_ATTACK_DAMAGE) && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            if (MTConfig.POWER_CONSOLIDATION_TIERS.size() <= 0) {
                mahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, Math.max(nbt.m_128457_(MT_ATTACK_DAMAGE), mahou.getAttackDamage())));
            } else {
                if (nbt.m_128441_(MT_ATTACK_CAP)) {
                    mahou.setInnateCap(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, nbt.m_128457_(MT_ATTACK_CAP)));
                } else {
                    mahou.setInnateCap(MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
                }
                mahou.setAttackDamage((float)Math.min(mahou.getInnateCap(), (double)Math.max(nbt.m_128457_(MT_ATTACK_DAMAGE), mahou.getAttackDamage())));
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundTag nbtt) {
        if (nbtt != null) {
            ICaliburnMahou caliburnMahou = Utils.getCaliburnMahou(stack);
            CaliburnMahou serverCaliburnMahou = new CaliburnMahou();
            CaliburnMahouStorage.readNBT(serverCaliburnMahou, (Tag)nbtt);
            if (caliburnMahou != null) {
                if (MTConfig.POWER_CONSOLIDATION_TIERS.size() <= 0) {
                    caliburnMahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, serverCaliburnMahou.getAttackDamage()));
                } else {
                    caliburnMahou.setInnateCap(Math.min((double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, serverCaliburnMahou.getInnateCap()));
                    caliburnMahou.setAttackDamage((float)Math.min(serverCaliburnMahou.getInnateCap(), (double)serverCaliburnMahou.getAttackDamage()));
                }
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        if (handIn == InteractionHand.MAIN_HAND) {
            player.m_6672_(InteractionHand.MAIN_HAND);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(handIn));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        ICaliburnMahou mahou;
        MorganStorage storage = null;
        if (staffs.containsKey(player.m_142081_())) {
            storage = staffs.get(player.m_142081_());
        } else {
            storage = new MorganStorage();
            staffs.put(player.m_142081_(), storage);
        }
        if (!player.f_19853_.f_46443_ && (mahou = Utils.getCaliburnMahou(stack)) != null && player instanceof Player && storage.ball == null && !EffectUtil.hasBuff(player, ModEffects.CM_COOLDOWN) && PlayerManaManager.drainMana((Player)player, MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST, false, false) == MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST) {
            List<Integer> settings = MahouSettings.getIntSettings((Player)player, MahouSettings.Spell.MORGAN_BALL);
            storage.ball = new MorganBallEntity(player.f_19853_, player, MahouSettings.colorConvert(settings.get(0)), MahouSettings.colorConvert(settings.get(1)), MahouSettings.colorConvert(settings.get(2)), 0.3f, MahouSettings.colorConvert(settings.get(3)), MahouSettings.colorConvert(settings.get(4)), MahouSettings.colorConvert(settings.get(5)), 0.0f, mahou.getAttackDamage());
            Vec3 eye = player.m_20299_(1.0f);
            storage.ball.m_6034_(eye.f_82479_, eye.f_82480_, eye.f_82481_);
            storage.ball.m_20256_(player.m_20154_().m_82541_().m_82490_((double)0.3f));
            player.f_19853_.m_7967_((Entity)storage.ball);
            EffectUtil.buff(player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity player, int useTicks) {
        if (staffs.containsKey(player.m_142081_())) {
            storage = staffs.get(player.m_142081_());
        } else {
            storage = new MorganStorage();
            staffs.put(player.m_142081_(), storage);
        }
        storage.ball = null;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        HashMultimap multimapret = HashMultimap.create();
        float damage = 3.0f;
        Morgan.getattackfromnbt(stack);
        if (slot == EquipmentSlot.MAINHAND && multimap != null) {
            ICaliburnMahou mahou;
            if (stack != null && (mahou = Utils.getCaliburnMahou(stack)) != null) {
                damage = mahou.getAttackDamage();
            }
            if (Attributes.f_22281_ != null && Attributes.f_22283_ != null) {
                for (Attribute k : multimap.keySet()) {
                    if (k.equals(Attributes.f_22281_) || k.equals(Attributes.f_22283_)) continue;
                    multimapret.putAll((Object)k, (Iterable)multimap.get((Object)k));
                }
                multimapret.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
                multimapret.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.600000095367432, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimapret;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(MorganRenderer::new);
    }

    public class MorganStorage {
        public MorganBallEntity ball = null;
    }
}

