/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.mysticcode;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.item.spells.boundary.BoundarySpellScroll;
import stepsword.mahoutsukai.render.item.MysticCodeFirstSorceryRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MysticCodeFirstSorcery
extends MysticCode
implements MenuProvider {
    public MysticCodeFirstSorcery() {
        super("mystic_code_first_sorcery", new Item.Properties().m_41503_(MTConfig.FIRST_SORCERY_DURABILITY));
        this.addPropertyOverrides();
    }

    @Override
    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        ItemStack ammo;
        int slot;
        IItemHandler inventory;
        if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCodeFirstSorcery.getSlot(stack)) >= 0 && slot < 3 && (ammo = inventory.getStackInSlot(slot)).m_41720_() instanceof SpellScroll) {
            ((SpellScroll)ammo.m_41720_()).useAction(ammo, worldIn, entityLiving, false);
            stack.m_41622_(1, entityLiving, a -> {});
            if (!worldIn.f_46443_) {
                this.saveCapabilityToStack(stack);
            }
        }
        if (!worldIn.f_46443_) {
            MysticCodeFirstSorcery.triggerUpdate((ServerPlayer)entityLiving, stack);
        }
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    @Override
    public InteractionResult m_6225_(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player != null) {
            ItemStack ammo;
            int slot;
            IItemHandler inventory;
            Level worldIn = player.f_19853_;
            InteractionHand hand = ctx.m_43724_();
            BlockPos pos = ctx.m_8083_();
            Direction facing = ctx.m_43719_();
            ItemStack stack = player.m_21120_(hand);
            if (player.m_20163_()) {
                if (!worldIn.f_46443_) {
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this);
                }
                return InteractionResult.SUCCESS;
            }
            if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCodeFirstSorcery.getSlot(stack)) >= 0 && slot < 3 && !EffectUtil.inItemBlacklist((ammo = inventory.getStackInSlot(slot)).m_41720_(), MTConfig.MYSTIC_CODE_FIRST_SORCERY_BLACKLIST)) {
                if (ammo.m_41720_() instanceof BoundarySpellScroll) {
                    InteractionResult s = ((BoundarySpellScroll)ammo.m_41720_()).boundaryScrollUse(player, worldIn, ammo, pos, facing, false);
                    stack.m_41622_(1, (LivingEntity)player, a -> {});
                    if (!worldIn.f_46443_) {
                        this.saveCapabilityToStack(stack);
                    }
                    return s;
                }
                player.m_6672_(hand);
            }
            if (!worldIn.f_46443_) {
                MysticCodeFirstSorcery.triggerUpdate((ServerPlayer)player, stack);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.FAIL;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.MYSTIC_CODE_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.FIRST_SORCERY_DURABILITY;
    }

    @Override
    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(MysticCodeFirstSorceryRenderer::new);
    }
}

