/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.mystic;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouStorage;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.tile.mystic.CupOfHeavenMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class CupOfHeavenSpellScroll
extends SpellScroll {
    public CupOfHeavenSpellScroll() {
        super("cup_of_heaven");
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.HEAVENS_CUP_MANA_COST;
    }

    @Override
    public void useAction(ItemStack stack, Level worldIn, LivingEntity entityLiving, boolean consume) {
        if (!worldIn.f_46443_ && entityLiving instanceof Player) {
            Player user = (Player)entityLiving;
            IScrollMahou scrollMahou = this.getCapability(stack);
            if (scrollMahou != null && (user.m_142081_().equals(scrollMahou.getCasterUUID()) || scrollMahou.getCasterUUID() == null || scrollMahou.getCasterUUID().equals(FaeEssence.faeID) || scrollMahou.getCasterUUID().equals(new UUID(0L, 0L)) || user.m_7500_())) {
                if (this.shouldConsume(user, scrollMahou, consume)) {
                    stack.m_41774_(1);
                }
                stack.m_41751_((CompoundTag)ScrollMahouStorage.writeNBT(scrollMahou));
            }
        }
    }

    @Override
    public boolean doSpell(Player user, IScrollMahou scrollMahou) {
        IMahou mahou;
        if (scrollMahou != null && (mahou = Utils.getPlayerMahou(user)) != null) {
            double d = MTConfig.HEAVENS_CUP_START_DISTANCE;
            Stream lst = BlockPos.m_121990_((BlockPos)user.m_142538_().m_142022_(-d, (double)(-user.m_142538_().m_123342_()), -d), (BlockPos)user.m_142538_().m_142022_(d, (double)user.f_19853_.m_151558_(), d));
            double minD = d * d * 4.0;
            CupOfHeavenMahoujinTileEntity start = null;
            Vec3 v = user.m_20182_();
            ArrayList<BlockPos> lst2 = Utils.findTilesInRange((LivingEntity)user, (int)d, a -> a instanceof CupOfHeavenMahoujinTileEntity);
            for (BlockPos p : lst2) {
                double curr;
                CupOfHeavenMahoujinTileEntity mte;
                BlockEntity te = user.f_19853_.m_7702_(p);
                if (!(te instanceof CupOfHeavenMahoujinTileEntity) || (mte = (CupOfHeavenMahoujinTileEntity)te).getCasterUUID() == null || !mte.getCasterUUID().equals(user.m_142081_()) || !((curr = CupOfHeavenSpellScroll.distanceTo(p, v, d * d * 4.0)) < minD)) continue;
                minD = curr;
                start = mte;
            }
            if (start != null) {
                HashSet<BlockPos> network = start.buildNetwork(null, user.m_142081_());
                if (network.size() > 2) {
                    final List<BlockPos> hull = CupOfHeavenSpellScroll.convexHull(network);
                    int internal = network.size() - hull.size();
                    BlockPos minZ = null;
                    BlockPos minX = null;
                    BlockPos maxX = null;
                    BlockPos maxZ = null;
                    for (BlockPos p : network) {
                        if (minX == null || minX.m_123341_() > p.m_123341_()) {
                            minX = p;
                        }
                        if (maxX == null || maxX.m_123341_() < p.m_123341_()) {
                            maxX = p;
                        }
                        if (minZ == null || minZ.m_123343_() > p.m_123343_()) {
                            minZ = p;
                        }
                        if (maxZ != null && maxZ.m_123343_() >= p.m_123343_()) continue;
                        maxZ = p;
                    }
                    final double maxx = maxX.m_123341_();
                    AABB aabb = new AABB(new BlockPos(minX.m_123341_(), 0, minZ.m_123343_()), new BlockPos(maxX.m_123341_(), user.f_19853_.m_151558_(), maxZ.m_123343_()));
                    List affected = user.f_19853_.m_6443_(LivingEntity.class, aabb, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

                        public boolean apply(@Nullable LivingEntity input) {
                            return input != null && CupOfHeavenSpellScroll.isInside(hull, input.m_20182_(), maxx);
                        }
                    });
                    int duration = MTConfig.HEAVENS_CUP_DURATION;
                    int a2 = 0;
                    int a3 = 0;
                    int a5 = 0;
                    int a7 = 0;
                    int a11 = 0;
                    int a13 = 0;
                    int g = internal;
                    int external = hull.size();
                    while (internal % 2 == 0 && internal > 0) {
                        ++a2;
                        internal /= 2;
                    }
                    while (internal % 3 == 0 && internal > 0) {
                        ++a3;
                        internal /= 3;
                    }
                    while (internal % 5 == 0 && internal > 0) {
                        ++a5;
                        internal /= 5;
                    }
                    while (internal % 7 == 0 && internal > 0) {
                        ++a7;
                        internal /= 7;
                    }
                    while (internal % 11 == 0 && internal > 0) {
                        ++a11;
                        internal /= 11;
                    }
                    while (internal % 13 == 0 && internal > 0) {
                        ++a13;
                        internal /= 13;
                    }
                    while (external % 2 == 0 && external > 0) {
                        ++a2;
                        external /= 2;
                    }
                    while (external % 3 == 0 && external > 0) {
                        ++a3;
                        external /= 3;
                    }
                    while (external % 5 == 0 && external > 0) {
                        ++a5;
                        external /= 5;
                    }
                    while (external % 7 == 0 && external > 0) {
                        ++a7;
                        external /= 7;
                    }
                    while (external % 11 == 0 && external > 0) {
                        ++a11;
                        external /= 11;
                    }
                    while (external % 13 == 0 && external > 0) {
                        ++a13;
                        external /= 13;
                    }
                    int manacost = 2 * a2 + 3 * a3 + 5 * a5 + 7 * a7 + 11 * a11 + 13 * a13;
                    manacost = (int)((double)manacost * Math.ceil(Math.sqrt((maxZ.m_123343_() - minZ.m_123343_()) * (maxX.m_123341_() - minX.m_123341_()))));
                    if (PlayerManaManager.drainMana(user, manacost *= MTConfig.HEAVENS_CUP_MANA_COST, false, false) == manacost) {
                        for (LivingEntity a4 : affected) {
                            if (a2 > 0) {
                                a4.m_7292_(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_TWO_EFFECT), duration, a2 - 1));
                            }
                            if (a3 > 0) {
                                a4.m_7292_(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_THREE_EFFECT), duration, a3 - 1));
                            }
                            if (a5 > 0) {
                                a4.m_7292_(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_FIVE_EFFECT), duration, a5 - 1));
                            }
                            if (a7 > 0) {
                                a4.m_7292_(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_SEVEN_EFFECT), duration, a7 - 1));
                            }
                            if (a11 > 0) {
                                a4.m_7292_(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_ELEVEN_EFFECT), duration, a11 - 1));
                            }
                            if (a13 <= 0) continue;
                            a4.m_7292_(new MobEffectInstance(CupOfHeavenSpellScroll.getRegisteredMobEffect(MTConfig.HEAVENS_CUP_THIRTEEN_EFFECT), duration, a13 - 1));
                        }
                        if (a2 > 0 && a3 > 0 && a5 > 0 && a7 > 0 && a11 > 0 && a13 > 0) {
                            ModTriggers.GREATER_GRAIL.trigger((ServerPlayer)user);
                            user.m_5661_((Component)new TextComponent(ChatFormatting.AQUA + "Greater Grail found. External size: " + hull.size() + ". Internal size: " + g), true);
                        } else {
                            if (a2 <= 0 && a3 <= 0 && a5 <= 0 && a7 <= 0 && a11 <= 0 && a13 <= 0) {
                                user.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Lesser Grail found, but internal count is imbalanced. External size: " + hull.size() + ". Internal size: " + g), true);
                                return false;
                            }
                            ModTriggers.LESSER_GRAIL.trigger((ServerPlayer)user);
                            user.m_5661_((Component)new TextComponent(ChatFormatting.GREEN + "Lesser Grail found. External size: " + hull.size() + ". Internal size: " + g), true);
                        }
                        return true;
                    }
                    user.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Not enough mana to activate grail. External size: " + hull.size() + ". Internal size: " + g + ". Mana needed: " + manacost + "."), true);
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public static boolean onSegment(BlockPos p, Vec3 q, BlockPos r) {
        BlockPos bpq = new BlockPos(q);
        return bpq.m_123341_() <= Math.max(p.m_123341_(), r.m_123341_()) && bpq.m_123341_() >= Math.min(p.m_123341_(), r.m_123341_()) && bpq.m_123343_() <= Math.max(p.m_123343_(), r.m_123343_()) && bpq.m_123343_() >= Math.min(p.m_123343_(), r.m_123343_());
    }

    static boolean isInside(List<BlockPos> polygon, Vec3 p, double maxX) {
        int next;
        if (polygon.size() < 2) {
            return false;
        }
        if (polygon.size() == 2) {
            return CupOfHeavenSpellScroll.onSegment(polygon.get(0), p, polygon.get(1).m_142082_(1, 0, 1));
        }
        Vec3 extreme = new Vec3(maxX + 5000000.0, 0.0, p.f_82481_);
        int count = 0;
        int i = 0;
        do {
            next = (i + 1) % polygon.size();
            if (!CupOfHeavenSpellScroll.doIntersect(EffectUtil.fromBlockPos(polygon.get(i)), EffectUtil.fromBlockPos(polygon.get(next)), p, extreme)) continue;
            if (CupOfHeavenSpellScroll.orientation(EffectUtil.fromBlockPos(polygon.get(i)), p, EffectUtil.fromBlockPos(polygon.get(next))) == 0) {
                return CupOfHeavenSpellScroll.onSegment(polygon.get(i), p, polygon.get(next));
            }
            ++count;
        } while ((i = next) != 0);
        return count % 2 == 1;
    }

    public static double distanceTo(BlockPos from, Vec3 to, double d) {
        if (from != null && to != null) {
            BlockPos a = new BlockPos(from.m_123341_(), 0, from.m_123343_());
            return a.m_123299_(to.f_82479_, 0.0, to.f_82481_, false);
        }
        return d;
    }

    public static List<BlockPos> convexHull(HashSet<BlockPos> ps) {
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        ArrayList<Vec3> pts = new ArrayList<Vec3>();
        Object minV = null;
        HashSet<BlockPos> points = new HashSet<BlockPos>();
        boolean found = false;
        for (BlockPos p : ps) {
            found = false;
            for (BlockPos z : points) {
                if (z.m_123343_() != p.m_123343_() || z.m_123341_() != p.m_123341_()) continue;
                found = true;
            }
            if (found) continue;
            points.add(p);
        }
        for (BlockPos p : points) {
            Vec3 tmpV = EffectUtil.fromBlockPos(p);
            pts.add(tmpV);
        }
        pts.sort((a, b) -> {
            if (a.f_82481_ == b.f_82481_) {
                if (a.f_82479_ > b.f_82479_) {
                    return -1;
                }
                if (a.f_82479_ < b.f_82479_) {
                    return 1;
                }
                return 0;
            }
            if (a.f_82481_ < b.f_82481_) {
                return -1;
            }
            if (a.f_82481_ > b.f_82481_) {
                return 1;
            }
            return 0;
        });
        Vec3 initial = (Vec3)pts.get(0);
        pts.remove(initial);
        if (initial != null) {
            pts.sort((a, b) -> {
                double cross = (a.f_82479_ - initial.f_82479_) * (b.f_82481_ - initial.f_82481_) - (b.f_82479_ - initial.f_82479_) * (a.f_82481_ - initial.f_82481_);
                if (cross > 0.0) {
                    return 1;
                }
                if (cross < 0.0) {
                    return -1;
                }
                double adist = (a.f_82479_ - initial.f_82479_) * (a.f_82479_ - initial.f_82479_) + (a.f_82481_ - initial.f_82481_) * (a.f_82481_ - initial.f_82481_);
                double bdist = (b.f_82479_ - initial.f_82479_) * (b.f_82479_ - initial.f_82479_) + (b.f_82481_ - initial.f_82481_) * (b.f_82481_ - initial.f_82481_);
                if (adist < bdist) {
                    return 1;
                }
                if (adist > bdist) {
                    return -1;
                }
                return 0;
            });
        }
        for (int m = 1; m < pts.size(); ++m) {
            Vec3 a2 = (Vec3)pts.get(m);
            Vec3 b2 = (Vec3)pts.get(m - 1);
            double cross = (a2.f_82479_ - initial.f_82479_) * (b2.f_82481_ - initial.f_82481_) - (b2.f_82479_ - initial.f_82479_) * (a2.f_82481_ - initial.f_82481_);
            double cotanA = -(a2.f_82479_ - initial.f_82479_) / (a2.f_82481_ - initial.f_82481_);
            double cotanB = -(b2.f_82479_ - initial.f_82479_) / (b2.f_82481_ - initial.f_82481_);
            if (cross != 0.0) continue;
            pts.remove(m);
            --m;
        }
        Stack<Vec3> stack = new Stack<Vec3>();
        stack.push(initial);
        for (Vec3 pt : pts) {
            while (stack.size() > 1 && CupOfHeavenSpellScroll.ccw(CupOfHeavenSpellScroll.nextToTop(stack), stack.peek(), pt) <= 0) {
                stack.pop();
            }
            stack.push(pt);
        }
        while (!stack.empty()) {
            Vec3 tmp = (Vec3)stack.pop();
            ret.add(new BlockPos(tmp.f_82479_, tmp.f_82480_, tmp.f_82481_));
        }
        return ret;
    }

    public static Vec3 nextToTop(Stack<Vec3> s) {
        Vec3 tmp = s.pop();
        Vec3 ret = s.peek();
        s.push(tmp);
        return ret;
    }

    public static int ccw(Vec3 a, Vec3 b, Vec3 c) {
        double area2 = (-b.f_82479_ + a.f_82479_) * (c.f_82481_ - a.f_82481_) - (b.f_82481_ - a.f_82481_) * (-c.f_82479_ + a.f_82479_);
        double ball = 1.0E-7;
        if (area2 < ball && area2 > 0.0) {
            return 0;
        }
        if (area2 > -ball && area2 < 0.0) {
            return 0;
        }
        if (area2 < 0.0) {
            return -1;
        }
        if (area2 > 0.0) {
            return 1;
        }
        return 0;
    }

    public static boolean doIntersect(Vec3 p1, Vec3 q1, Vec3 p2, Vec3 q2) {
        int o1 = CupOfHeavenSpellScroll.orientation(p1, q1, p2);
        int o2 = CupOfHeavenSpellScroll.orientation(p1, q1, q2);
        int o3 = CupOfHeavenSpellScroll.orientation(p2, q2, p1);
        int o4 = CupOfHeavenSpellScroll.orientation(p2, q2, q1);
        if (o1 != o2 && o3 != o4) {
            return true;
        }
        if (o1 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p1), p2, new BlockPos(q1))) {
            return true;
        }
        if (o2 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p1), q2, new BlockPos(q1))) {
            return true;
        }
        if (o3 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p2), p1, new BlockPos(q2))) {
            return true;
        }
        return o4 == 0 && CupOfHeavenSpellScroll.onSegment(new BlockPos(p2), q1, new BlockPos(q2));
    }

    public static int orientation(Vec3 p, Vec3 q, Vec3 r) {
        double val = (q.f_82481_ - p.f_82481_) * (-r.f_82479_ + q.f_82479_) - (-q.f_82479_ + p.f_82479_) * (r.f_82481_ - q.f_82481_);
        if (val == 0.0) {
            return 0;
        }
        return val > 0.0 ? 1 : 2;
    }

    private static MobEffect getRegisteredMobEffect(String id) {
        MobEffect potion = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(id));
        if (potion == null) {
            throw new IllegalStateException("Invalid MobEffect requested: " + id);
        }
        return potion;
    }
}

