/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.PowerConsolidation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.RangedAttribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouStorage;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.butterfly.SafeFakePlayer;
import stepsword.mahoutsukai.item.MagicalItemRender;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.render.item.CaliburnRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.FakeSkeleton;
import stepsword.mahoutsukai.util.Utils;

public class Caliburn
extends SwordItem {
    protected String name = "caliburn";
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_caliburn_attack";
    public static String MT_ATTACK_CAP = "mahoutsukai_caliburn_innate_cap";

    public Caliburn() {
        super((Tier)Tiers.IRON, 3, -2.4f, new Item.Properties().m_41491_(ModItems.MAHOUTSUKAI_CREATIVE_TAB).m_41503_(MTConfig.POWER_CONSOLIDATION_DURABILITY));
        this.setRegistryName(this.name);
    }

    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Caliburn.setattacktonbt(stack, worldIn);
        return super.m_6813_(stack, worldIn, state, pos, entityLiving);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new CaliburnMahouProvider();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.POWER_CONSOLIDATION_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public CompoundTag getShareTag(ItemStack stack) {
        CompoundTag ret = super.getShareTag(stack);
        if (ret == null) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            return (CompoundTag)CaliburnMahouStorage.writeNBT(mahou);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, Level world) {
        if (stack != null && !world.f_46443_) {
            ICaliburnMahou mahou;
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = new CompoundTag();
            }
            if ((mahou = Utils.getCaliburnMahou(stack)) != null) {
                nbt.m_128350_(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
                nbt.m_128347_(MT_ATTACK_CAP, mahou.getInnateCap());
            }
            stack.m_41751_(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        ICaliburnMahou mahou;
        CompoundTag nbt;
        if (stack != null && stack.m_41782_() && (nbt = stack.m_41783_()) != null && nbt.m_128441_(MT_ATTACK_DAMAGE) && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            if (MTConfig.POWER_CONSOLIDATION_TIERS.size() <= 0) {
                mahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, Math.max(nbt.m_128457_(MT_ATTACK_DAMAGE), mahou.getAttackDamage())));
            } else {
                if (nbt.m_128441_(MT_ATTACK_CAP)) {
                    mahou.setInnateCap(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, nbt.m_128457_(MT_ATTACK_CAP)));
                } else {
                    mahou.setInnateCap(MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
                }
                mahou.setAttackDamage((float)Math.min(mahou.getInnateCap(), (double)Math.max(nbt.m_128457_(MT_ATTACK_DAMAGE), mahou.getAttackDamage())));
            }
        }
    }

    public void readShareTag(ItemStack stack, CompoundTag nbtt) {
        if (nbtt != null) {
            ICaliburnMahou caliburnMahou = Utils.getCaliburnMahou(stack);
            CaliburnMahou serverCaliburnMahou = new CaliburnMahou();
            CaliburnMahouStorage.readNBT(serverCaliburnMahou, (Tag)nbtt);
            if (caliburnMahou != null) {
                if (MTConfig.POWER_CONSOLIDATION_TIERS.size() <= 0) {
                    caliburnMahou.setAttackDamage(Math.min((float)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, serverCaliburnMahou.getAttackDamage()));
                } else {
                    caliburnMahou.setInnateCap(Math.min((double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP, serverCaliburnMahou.getInnateCap()));
                    caliburnMahou.setAttackDamage((float)Math.min(serverCaliburnMahou.getInnateCap(), (double)serverCaliburnMahou.getAttackDamage()));
                }
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public static float simulateHit(ItemStack s, Level world) {
        float ret = 3.0f;
        int health = 5000000;
        if (s != null) {
            ItemStack s1 = s.m_41777_();
            if (Attributes.f_22281_ instanceof RangedAttribute) {
                ((RangedAttribute)Attributes.f_22281_).f_22308_ = Math.max(((RangedAttribute)Attributes.f_22281_).f_22308_, (double)MTConfig.POWER_CONSOLIDATION_ATTACK_CAP);
            }
            FakeSkeleton fake_target = new FakeSkeleton(world);
            fake_target.h = 5000000.0f;
            SafeFakePlayer fake_player = new SafeFakePlayer((ServerLevel)world, "faker");
            fake_player.m_21008_(InteractionHand.MAIN_HAND, s1);
            fake_player.m_21204_().m_22178_(s1.m_41638_(EquipmentSlot.MAINHAND));
            ((Player)fake_player).f_20922_ = 1000;
            fake_player.m_5706_((Entity)fake_target);
            ret = (float)health - fake_target.h;
        }
        return ret;
    }

    public static boolean specialTarget(LivingEntity entity) {
        boolean blacklisted = false;
        for (String string : MTConfig.POWER_CONSOLIDATION_FEAR_BLACKLIST) {
            if (string == null || entity.m_6095_().getRegistryName() == null || !string.equals(entity.m_6095_().getRegistryName().toString())) continue;
            blacklisted = true;
        }
        if (blacklisted) {
            return false;
        }
        return entity.m_21222_() || entity.m_21205_().m_41720_() instanceof Morgan || entity.m_21206_().m_41720_() instanceof Morgan || Caliburn.containsKeyword(entity.m_7755_().getString().toLowerCase()) || Caliburn.containsKeyword(entity.m_5446_().toString().toLowerCase());
    }

    public static boolean containsKeyword(String name) {
        List<? extends String> arr = MTConfig.UNHOLY_WORDS;
        for (int i = 0; i < arr.size(); ++i) {
            if (!name.contains(arr.get(i))) continue;
            return true;
        }
        int numKeys = arr.size();
        for (int i = 1; i < numKeys + 1; ++i) {
            if (!name.contains(new TranslatableComponent("mahoutsukai.caliburnkeyword" + i).getString())) continue;
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player player, InteractionHand handIn) {
        player.m_6672_(handIn);
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(handIn));
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_5551_(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        if (player != null && !worldIn.f_46443_) {
            int radius = MTConfig.POWER_CONSOLIDATION_PULL_RADIUS;
            AABB aabb = new AABB(player.m_142538_().m_142082_(-radius, -4, -radius), player.m_142538_().m_142082_(radius, 4, radius));
            List lst = worldIn.m_45976_(LivingEntity.class, aabb);
            double score = -1.0;
            double chosendist = 0.0;
            LivingEntity chosen = null;
            for (LivingEntity target : lst) {
                if (target.m_142081_().equals(player.m_142081_()) || !EffectUtil.isLookingAtMe((Entity)target, player, 45) || !Caliburn.specialTarget(target)) continue;
                double d = Math.abs(EffectUtil.pointToLineDistance(target.m_20182_(), player.m_20299_(1.0f), player.m_20154_().m_82549_(player.m_20299_(1.0f))));
                double e = target.m_20182_().m_82554_(player.m_20182_());
                if (score != -1.0 && !(score > d * d + e)) continue;
                score = d * d + e;
                chosen = target;
                chosendist = e;
            }
            if (chosen != null) {
                Vec3 chosenDirection = chosen.m_20182_().m_82546_(player.m_20182_());
                Caliburn.boop((Entity)player, (float)(chosendist / 8.0), -chosenDirection.f_82479_, -chosenDirection.f_82480_, -chosenDirection.f_82481_);
                Caliburn.boop(chosen, (float)(chosendist / 8.0), chosenDirection.f_82479_, chosenDirection.f_82480_, chosenDirection.f_82481_);
            }
        }
        super.m_5551_(stack, worldIn, player, timeLeft);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        HashMultimap multimapret = HashMultimap.create();
        float damage = 3.0f;
        Caliburn.getattackfromnbt(stack);
        if (slot == EquipmentSlot.MAINHAND && multimap != null) {
            ICaliburnMahou mahou;
            if (stack != null && (mahou = Utils.getCaliburnMahou(stack)) != null) {
                damage = mahou.getAttackDamage();
            }
            if (Attributes.f_22281_ != null && Attributes.f_22283_ != null) {
                for (Attribute k : multimap.keySet()) {
                    if (k.equals(Attributes.f_22281_) || k.equals(Attributes.f_22283_)) continue;
                    multimapret.putAll((Object)k, (Iterable)multimap.get((Object)k));
                }
                multimapret.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
                multimapret.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", -2.600000095367432, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimapret;
    }

    public static void boop(Entity entity, float strength, double x, double y, double z) {
        entity.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(x * x + z * z + y * y)));
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.f_19864_ = true;
        if (entity.m_20096_()) {
            motionY /= 2.0;
            if ((motionY += 0.3) > 0.6) {
                motionY = 0.6;
            }
        }
        entity.m_20256_(new Vec3(motionX, motionY, motionZ));
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public Object getRenderPropertiesInternal() {
        return new MagicalItemRender(CaliburnRenderer::new);
    }
}

