/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouStorage;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.util.Utils;

public class ProjectionSpellScroll
extends SpellScroll {
    public static final String MEMORIZED_WEAPON = "MAHOUTSUKAI_MEMORIZED_WEAPON";

    public ProjectionSpellScroll() {
        super("projection");
    }

    @Override
    public int getInitialManaCost() {
        return MTConfig.PROJECTION_MANA_COST;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag nbt;
        IScrollMahou scrollMahou;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        Item item = stack.m_41720_();
        if (item instanceof ProjectionSpellScroll && (scrollMahou = Utils.getScrollMahou(stack)) != null && (nbt = scrollMahou.getSpellStorage()) != null && nbt.m_128441_(MEMORIZED_WEAPON)) {
            CompoundTag weapon = nbt.m_128469_(MEMORIZED_WEAPON);
            Object s = "";
            Item i = RealityMarbleSpellEffect.getItemFromName(weapon.m_128461_("id"));
            if (i != null) {
                if (weapon.m_128441_("tag") && weapon.m_128469_("tag").m_128441_("ench")) {
                    s = (String)s + "Enchanted ";
                }
                s = (String)s + i.m_7626_(stack).getString();
                tooltip.add((Component)new TextComponent(ChatFormatting.GREEN + (String)s));
            }
        }
    }

    @Override
    public void readShareTag(ItemStack stack, CompoundTag nbtt) {
        IScrollMahou scrollMahou = Utils.getScrollMahou(stack);
        ScrollMahou serverScrollMahou = new ScrollMahou();
        if (nbtt != null) {
            ScrollMahouStorage.readNBT(serverScrollMahou, (Tag)nbtt);
            if (scrollMahou != null) {
                scrollMahou.setCasterUUID(serverScrollMahou.getCasterUUID());
                scrollMahou.setCasterName(serverScrollMahou.getCasterName());
                scrollMahou.setSpellStorage(serverScrollMahou.getSpellStorage());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    @Override
    public boolean doSpell(Player user, IScrollMahou scrollMahou) {
        if (scrollMahou != null) {
            CompoundTag spellStorage = scrollMahou.getSpellStorage();
            if (spellStorage == null || !spellStorage.m_128441_(MEMORIZED_WEAPON)) {
                CompoundTag memorized = ProjectionSpellEffect.memorize(user);
                if (memorized != null) {
                    user.m_5661_((Component)new TextComponent(ChatFormatting.RED + "Memorized!"), true);
                    spellStorage = new CompoundTag();
                    spellStorage.m_128365_(MEMORIZED_WEAPON, (Tag)memorized);
                    scrollMahou.setSpellStorage(spellStorage);
                    ((ServerPlayer)user).f_8906_.m_141995_((Packet)new ClientboundSetCarriedItemPacket(user.m_150109_().f_35977_));
                }
            } else {
                return ProjectionSpellEffect.projection(user, spellStorage.m_128469_(MEMORIZED_WEAPON));
            }
        }
        return false;
    }
}

