/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.secret.ripper;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.exchange.ImmunityExchangeSpellEffect;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.networking.FogPacket;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TheRipper
extends ItemBase {
    public TheRipper() {
        super("theripper", ModItems.MAHOUTSUKAI_CREATIVE_TAB, 1, MTConfig.RIPPER_DURABILITY);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        HashMultimap multimapret = HashMultimap.create();
        for (Attribute k : multimap.keySet()) {
            if (k.equals(Attributes.f_22281_) || k.equals(Attributes.f_22283_)) continue;
            multimapret.putAll((Object)k, (Iterable)multimap.get((Object)k));
        }
        if (slot == EquipmentSlot.MAINHAND) {
            multimapret.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(UUID.fromString("91AFBB56-376B-4498-945B-2F7FFF070635"), "Weapon modifier", MTConfig.RIPPER_MOVEMENT_SPEED, AttributeModifier.Operation.ADDITION));
        }
        if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND) {
            multimapret.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", MTConfig.RIPPER_DAMAGE, AttributeModifier.Operation.ADDITION));
            multimapret.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", MTConfig.RIPPER_SPEED, AttributeModifier.Operation.ADDITION));
        }
        return multimapret;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        if (player != null) {
            int manafog;
            Player target = player;
            ItemStack main = player.m_6844_(EquipmentSlot.MAINHAND);
            ItemStack off = player.m_6844_(EquipmentSlot.OFFHAND);
            if (!player.f_19853_.f_46443_ && main.m_41720_() == off.m_41720_() && main.m_41720_() == ModItems.theripper && MTConfig.RIPPER_GIVES_INVIS && PlayerManaManager.drainMana(player, manafog = MTConfig.RIPPER_INVIS_MANA_COST, false, false) == manafog) {
                EffectUtil.buff((LivingEntity)player, ModEffects.RIPPER_INVISIBILITY, false, 2000000000, false);
                RipperInvisPotion.notifyIfInvisible((LivingEntity)player);
            }
            int mana = MTConfig.RIPPER_FOG_MANA_COST;
            if (!player.f_19853_.f_46443_ && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.RIPPER_COOLDOWN) && PlayerManaManager.drainMana(player, mana, false, false) == mana) {
                LivingEntity look = ImmunityExchangeSpellEffect.getEnemy(player);
                if (look != null) {
                    target = look;
                }
                EffectUtil.buff((LivingEntity)player, ModEffects.RIPPER_COOLDOWN, false, MTConfig.RIPPER_COOLDOWN, false);
                PacketHandler.sendTracking((Entity)target, new FogPacket(target.m_142049_(), MTConfig.RIPPER_FOG_RANGE, MTConfig.RIPPER_FOG_DISTANCE));
                if (target instanceof ServerPlayer) {
                    PacketHandler.sendTo((ServerPlayer)target, new FogPacket(target.m_142049_(), 20.0, 5.0));
                }
            }
            return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
    }

    public static void ripperOnHit(LivingHurtEvent event) {
        LivingEntity living;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_21205_().m_41720_() == living.m_21206_().m_41720_() && living.m_21206_().m_41720_() == ModItems.theripper) {
            if (EffectUtil.hasBuff(living, ModEffects.RIPPER_INVISIBILITY) && MTConfig.RIPPER_GIVES_INVIS) {
                EffectUtil.debuff(living, ModEffects.RIPPER_INVISIBILITY);
                RipperInvisPotion.notifyNotInvisible(living);
                EffectUtil.buff(living, ModEffects.RIPPER_INVIS_COOLDOWN, false, MTConfig.RIPPER_INVIS_COOLDOWN, false);
            }
            if (!EffectUtil.isLookingAtMe(living, event.getEntityLiving())) {
                IMahou mahou;
                event.getEntityLiving().f_19802_ = 0;
                int mm = 100;
                if (living instanceof Player && (mahou = Utils.getPlayerMahou((Player)living)) != null) {
                    mm = mahou.getMaxMana();
                }
                double d = MTConfig.RIPPER_DAMAGE_BONUS_FROM_BEHIND * (double)(MTConfig.RIPPER_DAMAGE_BONUS_SCALES_WITH_MANA ? mm : 1);
                d = (double)event.getAmount() + d;
                event.setAmount((float)d);
            }
        }
    }

    public static void ripperLivingTick(LivingEntity living) {
        if (living != null && (living.m_21205_().m_41720_() != living.m_21206_().m_41720_() || living.m_21205_().m_41720_() != ModItems.theripper) && EffectUtil.hasBuff(living, ModEffects.RIPPER_INVISIBILITY)) {
            EffectUtil.debuff(living, ModEffects.RIPPER_INVISIBILITY);
            RipperInvisPotion.notifyNotInvisible(living);
        }
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.RIPPER_DURABILITY;
    }

    public static void attackTargetEntityWithCurrentItem(Entity targetEntity, Player player, InteractionHand hand) {
        if (!ForgeHooks.onPlayerAttackTarget((Player)player, (Entity)targetEntity)) {
            return;
        }
        if (targetEntity.m_6097_() && !targetEntity.m_7313_((Entity)player)) {
            float f = (float)player.m_21051_(Attributes.f_22281_).m_22135_();
            float f1 = targetEntity instanceof LivingEntity ? EnchantmentHelper.m_44833_((ItemStack)player.m_21120_(hand), (MobType)((LivingEntity)targetEntity).m_6336_()) : EnchantmentHelper.m_44833_((ItemStack)player.m_21120_(hand), (MobType)MobType.f_21640_);
            float f2 = player.m_36403_(0.5f);
            f1 *= f2;
            player.m_36334_();
            if ((f *= 0.2f + f2 * f2 * 0.8f) > 0.0f || f1 > 0.0f) {
                ItemStack itemstack;
                boolean flag = f2 > 0.9f;
                boolean flag1 = false;
                int i = 0;
                i += EnchantmentHelper.m_44894_((LivingEntity)player);
                if (player.m_20142_() && flag) {
                    player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12314_, player.m_5720_(), 1.0f, 1.0f);
                    ++i;
                    flag1 = true;
                }
                boolean flag2 = flag && player.f_19789_ > 0.0f && !player.m_20096_() && !player.m_6147_() && !player.m_20069_() && !player.m_21023_(MobEffects.f_19610_) && !player.m_20159_() && targetEntity instanceof LivingEntity;
                flag2 = flag2 && !player.m_20142_();
                CriticalHitEvent hitResult = ForgeHooks.getCriticalHit((Player)player, (Entity)targetEntity, (boolean)flag2, (float)(flag2 ? 1.5f : 1.0f));
                boolean bl = flag2 = hitResult != null;
                if (flag2) {
                    f *= hitResult.getDamageModifier();
                }
                f += f1;
                boolean flag3 = false;
                double d0 = player.f_19787_ - player.f_19867_;
                if (flag && !flag2 && !flag1 && player.m_20096_() && d0 < (double)player.m_6113_() && (itemstack = player.m_21120_(hand)).m_41720_() instanceof SwordItem) {
                    flag3 = true;
                }
                float f4 = 0.0f;
                boolean flag4 = false;
                int j = EnchantmentHelper.m_44914_((LivingEntity)player);
                if (targetEntity instanceof LivingEntity) {
                    f4 = ((LivingEntity)targetEntity).m_21223_();
                    if (j > 0 && !targetEntity.m_6060_()) {
                        flag4 = true;
                        targetEntity.m_20254_(1);
                    }
                }
                Vec3 vec3d = targetEntity.m_20184_();
                boolean flag5 = targetEntity.m_6469_(DamageSource.m_19344_((Player)player), f);
                if (flag5) {
                    if (i > 0) {
                        if (targetEntity instanceof LivingEntity) {
                            ((LivingEntity)targetEntity).m_147240_((double)((float)i * 0.5f), (double)Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)))));
                        } else {
                            targetEntity.m_5997_((double)(-Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f), 0.1, (double)(Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180))) * (float)i * 0.5f));
                        }
                        player.m_20256_(player.m_20184_().m_82542_(0.6, 1.0, 0.6));
                        player.m_6858_(false);
                    }
                    if (flag3) {
                        float f3 = 1.0f + EnchantmentHelper.m_44821_((LivingEntity)player) * f;
                        for (LivingEntity livingentity : player.f_19853_.m_45976_(LivingEntity.class, targetEntity.m_142469_().m_82377_(1.0, 0.25, 1.0))) {
                            if (livingentity == player || livingentity == targetEntity || player.m_7307_((Entity)livingentity) || livingentity instanceof ArmorStand && ((ArmorStand)livingentity).m_31677_() || !(player.m_20280_((Entity)livingentity) < 9.0)) continue;
                            livingentity.m_147240_((double)0.4f, (double)Mth.m_14031_((float)(player.f_19857_ * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(player.f_19857_ * ((float)Math.PI / 180)))));
                            livingentity.m_6469_(DamageSource.m_19344_((Player)player), f3);
                        }
                        player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
                        player.m_36346_();
                    }
                    if (targetEntity instanceof ServerPlayer && targetEntity.f_19864_) {
                        ((ServerPlayer)targetEntity).f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(targetEntity));
                        targetEntity.f_19864_ = false;
                        targetEntity.m_20256_(vec3d);
                    }
                    if (flag2) {
                        player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12313_, player.m_5720_(), 1.0f, 1.0f);
                        player.m_5704_(targetEntity);
                    }
                    if (!flag2 && !flag3) {
                        if (flag) {
                            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12316_, player.m_5720_(), 1.0f, 1.0f);
                        } else {
                            player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12318_, player.m_5720_(), 1.0f, 1.0f);
                        }
                    }
                    if (f1 > 0.0f) {
                        player.m_5700_(targetEntity);
                    }
                    player.m_21335_(targetEntity);
                    if (targetEntity instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)((LivingEntity)targetEntity), (Entity)player);
                    }
                    EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)targetEntity);
                    ItemStack itemstack1 = player.m_21120_(hand);
                    Entity entity = targetEntity;
                    if (targetEntity instanceof EnderDragonPart) {
                        entity = ((EnderDragonPart)targetEntity).f_31010_;
                    }
                    if (!player.f_19853_.f_46443_ && !itemstack1.m_41619_() && entity instanceof LivingEntity) {
                        ItemStack copy = itemstack1.m_41777_();
                        itemstack1.m_41640_((LivingEntity)entity, player);
                        if (itemstack1.m_41619_()) {
                            ForgeEventFactory.onPlayerDestroyItem((Player)player, (ItemStack)copy, (InteractionHand)InteractionHand.MAIN_HAND);
                            player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                        }
                    }
                    if (targetEntity instanceof LivingEntity) {
                        float f5 = f4 - ((LivingEntity)targetEntity).m_21223_();
                        player.m_36222_(Stats.f_12928_, Math.round(f5 * 10.0f));
                        if (j > 0) {
                            targetEntity.m_20254_(j * 4);
                        }
                        if (player.f_19853_ instanceof ServerLevel && f5 > 2.0f) {
                            int k = (int)((double)f5 * 0.5);
                            ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, targetEntity.m_20185_(), targetEntity.m_20227_(0.5), targetEntity.m_20189_(), k, 0.1, 0.0, 0.1, 0.2);
                        }
                    }
                    player.m_36399_(0.1f);
                } else {
                    player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12315_, player.m_5720_(), 1.0f, 1.0f);
                    if (flag4) {
                        targetEntity.m_20095_();
                    }
                }
            }
        }
    }
}

