/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.util.ByteBufUtils;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class KeyPressPacket {
    String keyD;

    public KeyPressPacket() {
    }

    public KeyPressPacket(String k) {
        this.keyD = k;
    }

    public void fromBytes(ByteBuf buf) {
        String s;
        this.keyD = s = ByteBufUtils.readUTF8String(buf);
    }

    public void toBytes(ByteBuf buf) {
        String s = this.keyD;
        ByteBufUtils.writeUTF8String(buf, s);
    }

    public static void encode(KeyPressPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static KeyPressPacket decode(FriendlyByteBuf buf) {
        KeyPressPacket msg = new KeyPressPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final KeyPressPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (message.keyD.equals("key.drawMahoujin")) {
                    KeyPressPacket.drawMahoujin(context);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void drawMahoujin(Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player == null) {
            return;
        }
        Level world = player.f_19853_;
        IMahou playerMahou = Utils.getPlayerMahou((Player)player);
        if (playerMahou != null && EffectUtil.hasBuff((LivingEntity)player, ModEffects.BLEEDING)) {
            Vec3 pp = player.m_20182_();
            Vec3 pv = player.m_20252_(1.0f);
            pv = new Vec3(pv.f_82479_, 0.0, pv.f_82481_).m_82541_();
            Vec3 pgoal = new Vec3(pv.f_82479_ + pp.f_82479_, pp.f_82480_ - 1.0, pv.f_82481_ + pp.f_82481_);
            BlockPos posInFront = new BlockPos(pgoal);
            BlockState blockInFrontState = world.m_8055_(posInFront);
            if (Utils.isBlockAir(world, posInFront)) {
                posInFront = posInFront.m_7495_();
                blockInFrontState = world.m_8055_(posInFront);
            }
            if (!Utils.isBlockAir(world, posInFront) && !(blockInFrontState.m_60734_() instanceof IFluidBlock) && (blockInFrontState.m_60638_((BlockGetter)world, posInFront, (Entity)player, Direction.UP) && blockInFrontState.m_60734_() != ModBlocks.mahoujin.get() || blockInFrontState.m_60734_() instanceof ChestBlock || !MTConfig.BLOOD_CIRCLE_SOLID_ONLY)) {
                BlockPos mahoujinPos = posInFront.m_7494_();
                if (!Utils.isBlockAir(world, mahoujinPos) && world.m_8055_(mahoujinPos).m_60734_() != ModBlocks.spellClothBlock.get()) {
                    mahoujinPos = mahoujinPos.m_7494_();
                    posInFront = posInFront.m_7494_();
                    blockInFrontState = world.m_8055_(posInFront);
                }
                if (blockInFrontState.m_60638_((BlockGetter)world, posInFront, (Entity)player, Direction.UP) && blockInFrontState.m_60734_() != ModBlocks.mahoujin.get() || blockInFrontState.m_60734_() instanceof ChestBlock || !MTConfig.BLOOD_CIRCLE_SOLID_ONLY) {
                    if (Utils.isBlockAir(world, mahoujinPos) || world.m_8055_(mahoujinPos).m_60734_() == ModBlocks.spellClothBlock.get()) {
                        boolean clothFlag = world.m_8055_(mahoujinPos).m_60734_() == ModBlocks.spellClothBlock.get();
                        world.m_46597_(mahoujinPos, ((BlockBase)ModBlocks.mahoujin.get()).m_49966_());
                        BlockEntity te = world.m_7702_(mahoujinPos);
                        if (te instanceof MahoujinTileEntity) {
                            ((MahoujinTileEntity)te).setCaster((Player)player);
                            ((MahoujinTileEntity)te).setCloth(clothFlag);
                            ((MahoujinTileEntity)te).setFay(false);
                        }
                        playerMahou.setHasMagic(true);
                        ModTriggers.MAHOUTSUKAI.trigger(player);
                        PlayerManaManager.updateClientMahou(player, playerMahou);
                    }
                    EffectUtil.debuff((LivingEntity)player, ModEffects.BLEEDING);
                }
            }
        }
    }
}

