/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MisfortunePotion
extends MobEffect {
    protected MisfortunePotion() {
        super(MobEffectCategory.NEUTRAL, ModEffects.getColorNumber(22, 22, 22));
        EffectUtil.effectIcon = new ResourceLocation("mahoutsukai", "textures/effects/misfortune.png");
    }

    public static void misfortuneLivingUpdate(LivingEntity living) {
        if (EffectUtil.hasBuff(living, ModEffects.MISFORTUNE) && !living.f_19853_.f_46443_ && ServerHandler.tickCounter % 4L == 0L) {
            int level = EffectUtil.getBuffLevel(living, ModEffects.MISFORTUNE);
            if ((level -= MisfortunePotion.getMaxKodoku(living)) > 0) {
                ItemStack s;
                IItemHandler inv;
                double lightningchance = MTConfig.KODOKU_MISFORTUNE_LIGHTNING_CHANCE;
                double dropitemchance = MTConfig.KODOKU_MISFORTUNE_DROP_CHANCE;
                double aggrochance = MTConfig.KODOKU_MISFORTUNE_AGGRO_CHANCE;
                double tripchance = MTConfig.KODOKU_MISFORTUNE_TRIP_CHANCE;
                float aggro = living.m_21187_().nextFloat();
                float trip = living.m_21187_().nextFloat();
                float drop = living.m_21187_().nextFloat();
                float lightning = living.m_21187_().nextFloat();
                if ((double)aggro < aggrochance * (double)level) {
                    int range = 40;
                    AABB aabb = new AABB(living.m_20185_() - (double)range, living.m_20186_() - 10.0, living.m_20189_() - (double)range, living.m_20185_() + (double)range, living.m_20186_() + 10.0, living.m_20189_() + (double)range);
                    List lst = living.f_19853_.m_45976_(Mob.class, aabb);
                    if (lst.size() > 0) {
                        ((Mob)lst.get(living.m_21187_().nextInt(lst.size()))).m_6703_(living);
                    }
                }
                if ((double)drop < dropitemchance * (double)level && (inv = Utils.getInventory(living)) != null && inv.getSlots() > 0 && Utils.getInventory(s = inv.getStackInSlot(living.m_21187_().nextInt(inv.getSlots()))) == null) {
                    living.m_20000_((ItemLike)s.m_41720_(), 1);
                    s.m_41774_(1);
                }
                if ((double)trip < tripchance * (double)level) {
                    Vec3 motion = living.m_20184_();
                    double motionX = motion.f_82479_;
                    double motionY = motion.f_82480_;
                    double motionZ = motion.f_82481_;
                    living.f_19864_ = true;
                    living.m_20334_(motionX += living.m_20154_().f_82479_ * 2.0, motionY, motionZ += living.m_20154_().f_82481_ * 2.0);
                }
                if ((double)lightning < lightningchance * (double)level) {
                    LightningBolt lightningb = (LightningBolt)EntityType.f_20465_.m_20615_(living.f_19853_);
                    lightningb.m_20219_(new Vec3(living.m_20185_(), living.m_20186_(), living.m_20189_()));
                    lightningb.m_20874_(false);
                    ((ServerLevel)living.f_19853_).m_7967_((Entity)lightningb);
                }
            }
        }
    }

    public static void misfortuneBreakEvent(BlockEvent.BreakEvent event) {
        if (EffectUtil.hasBuff((LivingEntity)event.getPlayer(), ModEffects.MISFORTUNE) && !event.getPlayer().f_19853_.f_46443_) {
            int level = EffectUtil.getBuffLevel((LivingEntity)event.getPlayer(), ModEffects.MISFORTUNE) / MTConfig.KODOKU_TOOL_BREAK_DIVISOR;
            event.getPlayer().m_21120_(InteractionHand.MAIN_HAND).m_41622_(level, (LivingEntity)event.getPlayer(), a -> {});
        }
    }

    public static void misfortuneLootEvent(LivingDropsEvent event) {
        Entity base = event.getSource().m_7639_();
        if (base instanceof LivingEntity && !base.f_19853_.f_46443_ && EffectUtil.hasBuff((LivingEntity)base, ModEffects.MISFORTUNE)) {
            int level = EffectUtil.getBuffLevel((LivingEntity)base, ModEffects.MISFORTUNE) / MTConfig.KODOKU_LOOT_DIVISOR;
            for (int i = 0; i < level; ++i) {
                if (event.getDrops().size() <= 0) continue;
                int ind = ((LivingEntity)base).m_21187_().nextInt(event.getDrops().size());
                event.getDrops().remove(ind);
            }
        }
    }

    public static int getMaxKodoku(LivingEntity living) {
        IItemHandler inventory = Utils.getInventory(living);
        int maxkodoku = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                IKodokuMahou mahou;
                ItemStack s = inventory.getStackInSlot(i);
                if (s.m_41619_() || !(s.m_41720_() instanceof KodokuItem) || (mahou = Utils.getKodokuMahou(s)) == null || mahou.getKodoku() <= maxkodoku) continue;
                maxkodoku = mahou.getKodoku();
            }
        }
        return maxkodoku;
    }
}

