/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RevertedPacket;
import stepsword.mahoutsukai.potion.EyesPotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ReversionEyesPotion
extends EyesPotion {
    public ReversionEyesPotion() {
        super(ModEffects.getColorNumber(242, 7, 23));
        EffectUtil.effectIcon = new ResourceLocation("mahoutsukai", "textures/effects/reverted.png");
    }

    public static void reversionEyesPlayerTick(Player player) {
        if (EffectUtil.hasBuff((LivingEntity)player, ModEffects.REVERSION_EYES)) {
            ReversionEyesPotion.addRevert((LivingEntity)player);
        }
    }

    public static void reversionEyesLivingUpdate(LivingEntity entity) {
        Level world = entity.f_19853_;
        if (!world.f_46443_ && ReversionEyesPotion.isEntityReverted(entity)) {
            ReversionEyesPotion.cantBreatheUnderwater(entity);
            ReversionEyesPotion.canBurn(entity);
            ReversionEyesPotion.burnInDay(entity);
            ReversionEyesPotion.noMoreEffects(entity);
            if (!ReversionEyesPotion.continueReverting(entity)) {
                EffectUtil.debuff(entity, ModEffects.REVERTED);
                ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
                lst.add(entity);
            }
        }
    }

    public static boolean continueReverting(LivingEntity victim) {
        int totalRange = MTConfig.REVERSION_EYES_RANGE_FROM_USER;
        Vec3 myloc = new Vec3(victim.m_20185_(), victim.m_20186_(), victim.m_20189_());
        boolean keepReverting = false;
        List lst = victim.f_19853_.m_45976_(Player.class, new AABB(victim.m_20185_() - (double)totalRange, victim.m_20186_() - (double)totalRange, victim.m_20189_() - (double)totalRange, victim.m_20185_() + (double)totalRange, victim.m_20186_() + (double)totalRange, victim.m_20189_() + (double)totalRange));
        for (Player tmp : lst) {
            if (tmp.m_142081_().equals(victim.m_142081_()) || !EffectUtil.hasBuff((LivingEntity)tmp, ModEffects.REVERSION_EYES) || !EffectUtil.inRange(victim, (LivingEntity)tmp, myloc, MTConfig.REVERSION_EYES_RANGE_FROM_LOOK_VEC, false)) continue;
            keepReverting = true;
        }
        return keepReverting;
    }

    public static void addRevert(LivingEntity target) {
        int totalRange = MTConfig.REVERSION_EYES_RANGE_FROM_USER;
        Vec3 myloc = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
        List lst = target.f_19853_.m_45976_(LivingEntity.class, new AABB(target.m_20185_() - (double)totalRange, target.m_20186_() - (double)totalRange, target.m_20189_() - (double)totalRange, target.m_20185_() + (double)totalRange, target.m_20186_() + (double)totalRange, target.m_20189_() + (double)totalRange));
        ArrayList<LivingEntity> toSendE = new ArrayList<LivingEntity>();
        for (LivingEntity tmp : lst) {
            if (!EffectUtil.inRange(tmp, target, myloc, MTConfig.REVERSION_EYES_RANGE_FROM_LOOK_VEC, false) || ContractMahoujinTileEntity.isImmuneToSpell(target.f_19853_, target.m_142081_(), (Entity)tmp) || ReversionEyesPotion.isEntityReverted(tmp)) continue;
            ReversionEyesPotion.setEntityReverted(tmp);
            toSendE.add(tmp);
        }
        ReversionEyesPotion.notifyTracking(toSendE, true, target.f_19853_);
    }

    public static void setEntityReverted(LivingEntity target) {
        EffectUtil.buff(target, ModEffects.REVERTED, false, 100);
    }

    public static boolean isEntityReverted(LivingEntity target) {
        return EffectUtil.hasBuff(target, ModEffects.REVERTED);
    }

    public static void noMoreEffects(LivingEntity e) {
        if (!e.f_19853_.f_46443_) {
            Object mahou;
            ArrayList<MobEffect> toremove = new ArrayList<MobEffect>();
            for (MobEffectInstance effect : e.m_21220_()) {
                if (effect.m_19544_() == ModEffects.REVERTED) continue;
                toremove.add(effect.m_19544_());
            }
            for (MobEffect p : toremove) {
                try {
                    e.m_21195_(p);
                }
                catch (Exception exception) {}
            }
            if (e instanceof Player && (mahou = Utils.getPlayerMahou((Player)e)) != null) {
                mahou.clearBuffs();
            }
            if ((mahou = Utils.getLivingMahou(e)) != null) {
                mahou.clearBuffs();
            }
        } else {
            MahouTsukaiMod.proxy.revertPlayer();
        }
    }

    public static boolean reversionEyesProjectileImpact(Entity entity, HitResult r) {
        Entity target;
        boolean ret = false;
        if (entity != null && r instanceof EntityHitResult && (target = ((EntityHitResult)r).m_82443_()) instanceof LivingEntity && ReversionEyesPotion.isEntityReverted((LivingEntity)target)) {
            ret = true;
            if (entity instanceof Arrow) {
                ReversionEyesPotion.arrowEnderman(target, (Arrow)entity);
            }
        }
        return ret;
    }

    public static void arrowEnderman(Entity entity, Arrow arrow) {
        if (entity != null) {
            Vec3 arrowmot = arrow.m_20184_();
            double motionX = arrowmot.f_82479_;
            double motionY = arrowmot.f_82480_;
            double motionZ = arrowmot.f_82481_;
            float f = Mth.m_14116_((float)((float)(motionX * motionX + motionY * motionY + motionZ * motionZ)));
            int i = Mth.m_14165_((double)((double)f * arrow.m_36789_()));
            if (arrow.m_36792_()) {
                i += entity.f_19853_.f_46441_.nextInt(i / 2 + 2);
            }
            DamageSource damagesource = arrow.m_37282_() == null ? DamageSource.m_19346_((AbstractArrow)arrow, (Entity)arrow) : DamageSource.m_19346_((AbstractArrow)arrow, null);
            if (arrow.m_6060_()) {
                entity.m_20254_(5);
            }
            if (entity instanceof EnderMan) {
                if (ReversionEyesPotion.attackEntityFrom((LivingEntity)entity, DamageSource.f_19318_, i)) {
                    float f1;
                    LivingEntity LivingEntity2 = (LivingEntity)entity;
                    LivingEntity2.f_20889_ = 100;
                    if (!arrow.f_19853_.f_46443_) {
                        LivingEntity2.m_21317_(LivingEntity2.m_21234_() + 1);
                    }
                    if ((f1 = Mth.m_14116_((float)((float)(motionX * motionX + motionZ * motionZ)))) > 0.0f) {
                        LivingEntity2.m_5997_(motionX * 3.0 * (double)0.6f / (double)f1, 0.1, motionZ * 3.0 * (double)0.6f / (double)f1);
                    }
                    arrow.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (arrow.f_19853_.f_46441_.nextFloat() * 0.2f + 0.9f));
                    arrow.m_146870_();
                }
                return;
            }
            if (entity instanceof LivingEntity && !entity.m_6469_(damagesource, (float)i)) {
                ReversionEyesPotion.attackEntityFrom((LivingEntity)entity, DamageSource.f_19318_, i);
                LivingEntity LivingEntity3 = (LivingEntity)entity;
                LivingEntity3.f_20889_ = 100;
                if (!arrow.f_19853_.f_46443_) {
                    LivingEntity3.m_21317_(LivingEntity3.m_21234_() + 1);
                }
                float f1 = Mth.m_14116_((float)((float)(motionX * motionX + motionZ * motionZ)));
                arrow.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (arrow.f_19853_.f_46441_.nextFloat() * 0.2f + 0.9f));
                arrow.m_146870_();
            }
        }
    }

    public static void notifyIfReverted(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (ReversionEyesPotion.isEntityReverted(e)) {
            ReversionEyesPotion.notifyTracking(lst, true, e.f_19853_);
        }
    }

    public static void notifyNotReverted(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        ReversionEyesPotion.notifyTracking(lst, false, e.f_19853_);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RevertedPacket(e.m_142049_(), r));
            }
        }
    }

    public static boolean attackEntityFrom(LivingEntity e, DamageSource source, float amount) {
        Entity entity1;
        boolean flag1 = false;
        if (e.f_19853_.f_46443_) {
            return false;
        }
        if (e.m_21223_() <= 0.0f) {
            return false;
        }
        float f = amount;
        e.f_20924_ = 1.5f;
        float f2 = e.f_19802_;
        Objects.requireNonNull(e);
        if (f2 > 20.0f / 2.0f) {
            ReversionEyesPotion.damageEntity(e, source, amount);
            flag1 = true;
        } else {
            Objects.requireNonNull(e);
            e.f_19802_ = 20;
            ReversionEyesPotion.damageEntity(e, source, amount);
            e.f_20916_ = e.f_20917_ = 10;
        }
        e.f_20918_ = 0.0f;
        Entity entity12 = source.m_7639_();
        if (entity12 != null && entity12 instanceof LivingEntity) {
            e.m_6703_((LivingEntity)entity12);
        }
        byte b0 = 2;
        e.f_19853_.m_7605_((Entity)e, b0);
        if (source != DamageSource.f_19312_ && amount > 0.0f) {
            e.f_19864_ = true;
        }
        if ((entity1 = source.m_7639_()) != null) {
            double d1 = entity1.m_20185_() - e.m_20185_();
            double d0 = entity1.m_20189_() - e.m_20189_();
            while (d1 * d1 + d0 * d0 < 1.0E-4) {
                d1 = (Math.random() - Math.random()) * 0.01;
                d0 = (Math.random() - Math.random()) * 0.01;
            }
            e.f_20918_ = (float)(Mth.m_14136_((double)d0, (double)d1) * 57.29577951308232 - (double)e.f_19857_);
            e.m_147240_((double)0.4f, d1, d0);
        } else {
            e.f_20918_ = (int)(Math.random() * 2.0) * 180;
        }
        if (flag1) {
            if (e instanceof EnderMan) {
                e.m_5496_(SoundEvents.f_11849_, 1.0f, ReversionEyesPotion.getSoundPitch(e));
            }
            if (e instanceof Shulker) {
                e.m_5496_(SoundEvents.f_12414_, 1.0f, ReversionEyesPotion.getSoundPitch(e));
            }
        }
        return true;
    }

    public static float getSoundPitch(LivingEntity e) {
        return e.m_6162_() ? (e.f_19853_.f_46441_.nextFloat() - e.f_19853_.f_46441_.nextFloat()) * 0.2f + 1.5f : (e.f_19853_.f_46441_.nextFloat() - e.f_19853_.f_46441_.nextFloat()) * 0.2f + 1.0f;
    }

    public static void damageEntity(LivingEntity e, DamageSource damageSrc, float damageAmount) {
        if (!e.m_20147_()) {
            if ((damageAmount = ForgeHooks.onLivingHurt((LivingEntity)e, (DamageSource)damageSrc, (float)damageAmount)) <= 0.0f) {
                return;
            }
            float f = damageAmount;
            damageAmount = Math.max(damageAmount - e.m_6103_(), 0.0f);
            e.m_7911_(e.m_6103_() - (f - damageAmount));
            damageAmount = ForgeHooks.onLivingDamage((LivingEntity)e, (DamageSource)damageSrc, (float)damageAmount);
            if (damageAmount != 0.0f) {
                float f1 = e.m_21223_();
                e.m_21231_().m_19289_(damageSrc, f1, damageAmount);
                e.m_21153_(f1 - damageAmount);
                e.m_7911_(e.m_6103_() - damageAmount);
            }
        }
    }

    public static void canBurn(LivingEntity e) {
        if (e.m_5825_()) {
            if (e.m_20077_()) {
                e.m_6469_(DamageSource.f_19308_, 4.0f);
                e.f_20889_ = 100;
                e.m_20254_(15);
            }
            if (!BlockPos.m_121921_((AABB)e.m_142469_().m_82406_(0.001)).noneMatch(posIn -> {
                BlockState state = e.f_19853_.m_8055_(posIn);
                return state.m_60620_((Tag)BlockTags.f_13076_) || state.m_60713_(Blocks.f_49991_) || state.isBurning((BlockGetter)e.f_19853_, posIn);
            })) {
                e.m_6469_(DamageSource.f_19305_, 1.0f);
            }
        }
    }

    public static void burnInDay(LivingEntity e) {
        float f;
        if (e instanceof Husk && (f = e.m_6073_()) > 0.5f && e.f_19853_.f_46441_.nextFloat() * 30.0f < (f - 0.4f) * 2.0f && e.f_19853_.m_45527_(new BlockPos(e.m_20185_(), e.m_20186_() + (double)e.m_20192_(), e.m_20189_()))) {
            boolean flag = true;
            ItemStack itemstack = e.m_6844_(EquipmentSlot.HEAD);
            if (!itemstack.m_41619_()) {
                if (itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41773_() + e.f_19853_.f_46441_.nextInt(2));
                    if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                        e.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
                flag = false;
            }
            if (flag) {
                e.m_20254_(8);
            }
        }
    }

    public static void cantBreatheUnderwater(LivingEntity e) {
        if (e.m_20069_()) {
            if (e instanceof WaterAnimal) {
                e.m_20301_(-20);
            }
            if (e.m_6040_() || e.m_21023_(MobEffects.f_19608_)) {
                e.m_20301_(ReversionEyesPotion.decreaseAirSupply(e, e.m_20146_()));
                if (e.m_20146_() <= 0 && ServerHandler.tickCounter % 20L == 0L) {
                    e.m_20301_(0);
                    for (int i = 0; i < 8; ++i) {
                        float f2 = e.m_21187_().nextFloat() - e.m_21187_().nextFloat();
                        float f = e.m_21187_().nextFloat() - e.m_21187_().nextFloat();
                        float f1 = e.m_21187_().nextFloat() - e.m_21187_().nextFloat();
                        e.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, e.m_20185_() + (double)f2, e.m_20186_() + (double)f, e.m_20189_() + (double)f1, e.m_20184_().f_82479_, e.m_20184_().f_82480_, e.m_20184_().f_82481_);
                    }
                    e.m_6469_(DamageSource.f_19312_, 2.0f);
                }
            }
        }
    }

    public static int decreaseAirSupply(LivingEntity e, int air) {
        int i = EnchantmentHelper.m_44918_((LivingEntity)e);
        return i > 0 && e.m_21187_().nextInt(i + 1) > 0 ? air : air - 1;
    }
}

