/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.EffectRenderer;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RipperInvisiblePacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisCooldownPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class RipperInvisPotion
extends MobEffect {
    protected RipperInvisPotion() {
        super(MobEffectCategory.NEUTRAL, ModEffects.getColorNumber(252, 45, 45));
    }

    public void initializeClient(Consumer<EffectRenderer> consumer) {
        consumer.accept(new EffectRenderer(){

            public void renderInventoryEffect(MobEffectInstance effect, EffectRenderingInventoryScreen<?> gui, PoseStack mStack, int x, int y, float z) {
            }

            public void renderHUDEffect(MobEffectInstance effect, GuiComponent gui, PoseStack mStack, int x, int y, float z, float alpha) {
            }

            public boolean shouldRender(MobEffectInstance effect) {
                return false;
            }

            public boolean shouldRenderHUD(MobEffectInstance effect) {
                return false;
            }
        });
    }

    public void m_6386_(LivingEntity livingEntity, AttributeMap attributeMapIn, int amplifier) {
        RipperInvisPotion.notifyNotInvisible(livingEntity);
        EffectUtil.debuff(livingEntity, MobEffects.f_19609_);
    }

    public void m_6385_(LivingEntity livingEntity, AttributeMap attributeMapIn, int amplifier) {
        RipperInvisPotion.notifyIfInvisible(livingEntity);
        EffectUtil.buff(livingEntity, MobEffects.f_19609_, false, 2000000000, false);
    }

    public static void notifyIfInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisPotion.notifyTracking(lst, true, e.f_19853_);
        }
    }

    public static void notifyNotInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        RipperInvisPotion.notifyTracking(lst, false, e.f_19853_);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, Level world) {
        if (world instanceof ServerLevel) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RipperInvisiblePacket(e.m_142049_(), r));
            }
        }
    }

    public static void presenceConcealmentLivingTick(LivingEntity e) {
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisCooldownPotion.nudge(e);
        }
    }
}

