/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.RenderProperties;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.entity.mahoujin.AuthorityMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.BeamProjectileEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownEntity;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffAOEMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.ReplicaTeleportMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.RhoAiasMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.RhongomyniadEntity;
import stepsword.mahoutsukai.entity.mahoujin.SpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.proxy.ClientProxy;
import stepsword.mahoutsukai.render.ClipWrappedRenderLayer;
import stepsword.mahoutsukai.render.ClippedRenderTypeBuffer;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.entity.RenderAOEMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderAuthorityMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderBeamProjectileEntity;
import stepsword.mahoutsukai.render.entity.RenderFaeEntity;
import stepsword.mahoutsukai.render.entity.RenderFallenDownBeamEntity;
import stepsword.mahoutsukai.render.entity.RenderFallenDownEntity;
import stepsword.mahoutsukai.render.entity.RenderGandrEntity;
import stepsword.mahoutsukai.render.entity.RenderGateChainEntity;
import stepsword.mahoutsukai.render.entity.RenderLightningEntity;
import stepsword.mahoutsukai.render.entity.RenderMorganBallEntity;
import stepsword.mahoutsukai.render.entity.RenderMysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderMysticStaffMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderReplicaTeleportEntity;
import stepsword.mahoutsukai.render.entity.RenderRhoAiasMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderRhongomyniadEntity;
import stepsword.mahoutsukai.render.entity.RenderSmiteEntity;
import stepsword.mahoutsukai.render.entity.RenderSpatialDisorientationMahoujinEntity;
import stepsword.mahoutsukai.render.particle.ParticleFog;
import stepsword.mahoutsukai.render.particle.ParticleLightning;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.particle.ParticleSphere;
import stepsword.mahoutsukai.render.shader.FogShaderInstance;
import stepsword.mahoutsukai.render.shader.ModShaders;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderUtils {
    public static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    public static final ResourceLocation runes = new ResourceLocation("mahoutsukai:textures/block/runes.png");
    public static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    public static int rune_index = 0;

    public static int getRuneIndex() {
        ++rune_index;
        return rune_index %= 2000000000;
    }

    public static void rotateQ(float w, float x, float y, float z, PoseStack matrix) {
        matrix.m_85845_(new Quaternion(new Vector3f(x, y, z), w, true));
    }

    public static RenderType renderRingCull(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(runes, ring_index));
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        ++rune_index;
        RenderType type = MahoujinRenderType.createRunesRenderType(runes, rune_index %= 2000000000);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index, ResourceLocation loc) {
        ++rune_index;
        RenderType type = MahoujinRenderType.createRunesRenderType(loc, rune_index %= 2000000000);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a) {
        ++rune_index;
        RenderType type = MahoujinRenderType.createSphereRenderType(beam, rune_index %= 2000000000);
        RenderUtils.renderSphere(matrix, buf, radius, gradation, lx, ly, r, g, b, a, type);
        return type;
    }

    public static RenderType renderRing(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        matrix.m_85836_();
        Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
        VertexConsumer bb = buffer.m_6299_(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.m_85982_(positionMatrix, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
                bb.m_85982_(positionMatrix, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            bb.m_85982_(positionMatrix, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(texx, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_85982_(positionMatrix, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(texx, 1.0f).m_7120_(lx, ly).m_5752_();
        }
        matrix.m_85849_();
        return type;
    }

    public static void translateBasic(double x, double y, double z, PoseStack matrix) {
        Camera renderInfo = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 basic = renderInfo.m_90583_();
        RenderUtils.rotateQ(renderInfo.m_90589_(), 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(renderInfo.m_90590_() + 180.0f, 0.0f, 1.0f, 0.0f, matrix);
        matrix.m_85837_(x - basic.f_82479_, y - basic.f_82480_, z - basic.f_82481_);
    }

    public static void bindTexture(ResourceLocation r) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)r);
        RenderSystem.m_69493_();
    }

    public static void renderClippedItem(ItemStack itemStackIn, ItemTransforms.TransformType transformTypeIn, boolean leftHand, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn, BakedModel modelIn, float progress, double x, double y, double z, double yaw, double pitch, double size, boolean clip) {
        if (!itemStackIn.m_41619_()) {
            boolean flag;
            matrixStackIn.m_85836_();
            Matrix4f m = matrixStackIn.m_85850_().m_85861_().m_27658_();
            boolean bl = flag = transformTypeIn == ItemTransforms.TransformType.GUI || transformTypeIn == ItemTransforms.TransformType.GROUND || transformTypeIn == ItemTransforms.TransformType.FIXED;
            if (itemStackIn.m_41720_() == Items.f_42713_ && flag) {
                modelIn = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            if (!(modelIn = ForgeHooksClient.handleCameraTransforms((PoseStack)matrixStackIn, (BakedModel)modelIn, (ItemTransforms.TransformType)transformTypeIn, (boolean)leftHand)).m_7521_() && (itemStackIn.m_41720_() != Items.f_42713_ || flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemTransforms.TransformType.GUI && !transformTypeIn.m_111841_() && itemStackIn.m_41720_() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.m_41720_()).m_40614_()) instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                RenderType rendertype = ItemBlockRenderTypes.m_109279_((ItemStack)itemStackIn, (boolean)flag1);
                RenderType rendertype1 = flag && Objects.equals(rendertype, Sheets.m_110791_()) ? Sheets.m_110792_() : rendertype;
                rendertype1 = new ClipWrappedRenderLayer(clip, pitch, yaw, x, y, z, progress, size, rendertype1, m);
                VertexConsumer ivertexbuilder = bufferIn.m_6299_(rendertype1);
                RenderUtils.renderModel(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
            } else {
                ItemStack stack2 = itemStackIn.m_41777_();
                EnchantmentHelper.m_44865_(new HashMap(), (ItemStack)stack2);
                RenderProperties.get((ItemStack)stack2).getItemStackRenderer().m_108829_(stack2, transformTypeIn, matrixStackIn, (MultiBufferSource)new ClippedRenderTypeBuffer(bufferIn, clip, pitch, yaw, x, y, z, progress, size, m), combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.m_85849_();
        }
    }

    private static void renderModel(BakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, PoseStack matrixStackIn, VertexConsumer bufferIn) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            Minecraft.m_91087_().m_91291_().m_115162_(matrixStackIn, bufferIn, modelIn.m_6840_((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        Minecraft.m_91087_().m_91291_().m_115162_(matrixStackIn, bufferIn, modelIn.m_6840_((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public static VertexConsumer getBuffer(MultiBufferSource bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        return glintIn ? VertexMultiConsumer.m_86168_((VertexConsumer)bufferIn.m_6299_(isItemIn ? RenderType.m_110490_() : RenderType.m_110496_()), (VertexConsumer)bufferIn.m_6299_(renderTypeIn)) : bufferIn.m_6299_(renderTypeIn);
    }

    public static Vec3 vecFromPitchYaw(float pitch, float yaw) {
        float f = Mth.m_14089_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = Mth.m_14031_((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -Mth.m_14089_((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = Mth.m_14031_((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static void renderFSQ(PoseStack stack, ResourceLocation texture, float r1, float g1, float b1, float a1, float xoffset, float yoffset, float x, float y, float z) {
        float r = r1 / 255.0f;
        float g = g1 / 255.0f;
        float b = b1 / 255.0f;
        float a = a1;
        Matrix4f m = stack.m_85850_().m_85861_();
        Entity e = Minecraft.m_91087_().m_91288_();
        if (e != null) {
            int j = 240;
            int k = 240;
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            RenderType type = MahoujinRenderType.createMahoujinRenderType(texture, 0, false, () -> ModShaders.PASSTHROUGH_QUADS);
            VertexConsumer bb = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(type);
            RenderSystem.m_69482_();
            bb.m_85982_(m, 0.0f + xoffset, 0.0f + yoffset, z).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(j, k).m_5752_();
            bb.m_85982_(m, 0.0f + xoffset, y + yoffset, z).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(j, k).m_5752_();
            bb.m_85982_(m, x + xoffset, y + yoffset, z).m_85950_(r, g, b, a).m_7421_(1.0f, 1.0f).m_7120_(j, k).m_5752_();
            bb.m_85982_(m, x + xoffset, 0.0f + yoffset, z).m_85950_(r, g, b, a).m_7421_(1.0f, 0.0f).m_7120_(j, k).m_5752_();
            buffer.m_109912_(type);
        }
    }

    public static void renderTextureOverlay(PoseStack matrix, String loc, int r, int g, int b, float a, float xoffset, float yoffset, float x, float y, float z) {
        ResourceLocation rl = new ResourceLocation(loc);
        RenderSystem.m_157429_((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)a);
        RenderUtils.renderFSQ(matrix, rl, r, g, b, a, xoffset, yoffset, x, y, z);
    }

    public static float calculateOverlayFade(int duration, int interval, int fadeTicks, float maxAlpha) {
        int large = duration % interval;
        float alpha = 0.0f;
        if (large > interval - fadeTicks) {
            alpha = ((float)large - ((float)interval - (float)fadeTicks)) / (float)fadeTicks;
            alpha *= maxAlpha;
        }
        return alpha;
    }

    public static void renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, RenderType type, float percentage) {
        float PI = 3.141592f;
        VertexConsumer bb = buf.m_6299_(type);
        Matrix4f m = matrix.m_85850_().m_85861_();
        for (float alpha = 0.0f; alpha < 3.141592f; alpha += 3.141592f / (float)gradation) {
            float beta = 0.0f;
            while ((double)beta < 6.31459997177124 * (double)percentage) {
                float x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha));
                float y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha));
                float z = (float)((double)radius * Math.cos(alpha));
                bb.m_85982_(m, x, y, z).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
                x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                z = (float)((double)radius * Math.cos(alpha + 3.141592f / (float)gradation));
                bb.m_85982_(m, x, y, z).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
                beta += 3.141592f / (float)gradation;
            }
        }
    }

    public static void renderSphere(PoseStack matrix, MultiBufferSource buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        RenderUtils.renderSphere(matrix, buf, radius, gradation, lx, ly, r, g, b, a, type, 1.0f);
    }

    public static void entityRenders(Entity re, PoseStack matrix, float partialTicks) {
        boolean hasEyes = false;
        if (re instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)re, ModEffects.FAY_SIGHT_EYES)) {
            hasEyes = true;
        }
        Vec3 proj = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double d3 = proj.f_82479_;
        double d4 = proj.f_82480_;
        double d5 = proj.f_82481_;
        HashSet<Entity> entities = ClientProxy.getAllEntities(Minecraft.m_91087_().f_91073_);
        if (entities != null && entities.size() > 0) {
            for (Entity entity : entities) {
                float m;
                double d2;
                double d1;
                double d0;
                if (entity instanceof FaeEntity && entity.m_20280_(re) < 3600.0 && (hasEyes || EffectUtil.hasBuff((LivingEntity)((FaeEntity)entity), ModEffects.REVERTED))) {
                    double d02 = entity.f_19790_ + (entity.m_20185_() - entity.f_19790_) * (double)partialTicks;
                    double d12 = entity.f_19791_ + (entity.m_20186_() - entity.f_19791_) * (double)partialTicks;
                    double d22 = entity.f_19792_ + (entity.m_20189_() - entity.f_19792_) * (double)partialTicks;
                    float m2 = entity.f_19859_ + (entity.f_19857_ - entity.f_19859_) * partialTicks;
                    matrix.m_85836_();
                    RenderFaeEntity.render((FaeEntity)entity, d02 - d3, d12 - d4, d22 - d5, matrix, partialTicks);
                    matrix.m_85849_();
                }
                if (entity instanceof MysticStaffMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    MysticStaffMahoujinEntity beam = (MysticStaffMahoujinEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderMysticStaffMahoujinEntity.renderCircle((MysticStaffMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MysticStaffBeamMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    MysticStaffBeamMahoujinEntity beam = (MysticStaffBeamMahoujinEntity)entity;
                    d0 = beam.prevx + (beam.m_20185_() - beam.prevx) * (double)partialTicks;
                    d1 = beam.prevy + (beam.m_20186_() - beam.prevy) * (double)partialTicks;
                    d2 = beam.prevz + (beam.m_20189_() - beam.prevz) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderMysticStaffBeamMahoujinEntity.renderBeam((MysticStaffBeamMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GateChainEntity && entity.m_20280_(re) < 4096.0) {
                    GateChainEntity chain = (GateChainEntity)entity;
                    d0 = chain.f_19854_ + (chain.m_20185_() - chain.f_19854_) * (double)partialTicks;
                    d1 = chain.f_19855_ + (chain.m_20186_() - chain.f_19855_) * (double)partialTicks;
                    d2 = chain.f_19856_ + (chain.m_20189_() - chain.f_19856_) * (double)partialTicks;
                    m = chain.f_19859_ + (chain.f_19857_ - chain.f_19859_) * partialTicks;
                    RenderGateChainEntity.renderCircle((GateChainEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof SmiteEntity && entity.m_20280_(re) < 16384.0) {
                    SmiteEntity beam = (SmiteEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderSmiteEntity.renderSmite((SmiteEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MorganBallEntity && entity.m_20280_(re) < 16384.0) {
                    MorganBallEntity beam = (MorganBallEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderMorganBallEntity.renderMorganBall((MorganBallEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof AuthorityMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    AuthorityMahoujinEntity beam = (AuthorityMahoujinEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderAuthorityMahoujinEntity.renderAuthority((AuthorityMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof RhoAiasMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    RhoAiasMahoujinEntity beam = (RhoAiasMahoujinEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderRhoAiasMahoujinEntity.renderRhoAias((RhoAiasMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof ReplicaTeleportMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    ReplicaTeleportMahoujinEntity beam = (ReplicaTeleportMahoujinEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderReplicaTeleportEntity.renderReplica((ReplicaTeleportMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GandrEntity && entity.m_20280_(re) < 4096.0) {
                    GandrEntity beam = (GandrEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderGandrEntity.renderGandr((GandrEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof FallenDownEntity && entity.m_20280_(re) < 16384.0) {
                    FallenDownEntity beam = (FallenDownEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderFallenDownEntity.renderFallenDown((FallenDownEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof FallenDownBeamEntity && entity.m_20280_(re) < 16384.0) {
                    FallenDownBeamEntity beam = (FallenDownBeamEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderFallenDownBeamEntity.renderFallenDownBeam((FallenDownBeamEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof LightningEntity && entity.m_20280_(re) < 16384.0) {
                    LightningEntity beam = (LightningEntity)entity;
                    d0 = beam.prev_x + (beam.m_20185_() - beam.prev_x) * (double)partialTicks;
                    d1 = beam.prev_y + (beam.m_20186_() - beam.prev_y) * (double)partialTicks;
                    d2 = beam.prev_z + (beam.m_20189_() - beam.prev_z) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderLightningEntity.renderLightning((LightningEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof SpatialDisorientationMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    SpatialDisorientationMahoujinEntity beam = (SpatialDisorientationMahoujinEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderSpatialDisorientationMahoujinEntity.renderSpatial((SpatialDisorientationMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof BeamProjectileEntity && entity.m_20280_(re) < 16384.0) {
                    BeamProjectileEntity beam = (BeamProjectileEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderBeamProjectileEntity.renderBeamProjectile((BeamProjectileEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MysticStaffAOEMahoujinEntity && entity.m_20280_(re) < 16384.0) {
                    MysticStaffAOEMahoujinEntity beam = (MysticStaffAOEMahoujinEntity)entity;
                    d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                    d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                    d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                    m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                    RenderAOEMahoujinEntity.renderAOECircle((MysticStaffAOEMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (!(entity instanceof RhongomyniadEntity) || !(entity.m_20280_(re) < 16384.0)) continue;
                RhongomyniadEntity beam = (RhongomyniadEntity)entity;
                d0 = beam.f_19854_ + (beam.m_20185_() - beam.f_19854_) * (double)partialTicks;
                d1 = beam.f_19855_ + (beam.m_20186_() - beam.f_19855_) * (double)partialTicks;
                d2 = beam.f_19856_ + (beam.m_20189_() - beam.f_19856_) * (double)partialTicks;
                m = beam.f_19859_ + (beam.f_19857_ - beam.f_19859_) * partialTicks;
                RenderRhongomyniadEntity.renderRhongomyniad((RhongomyniadEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
            }
        }
    }

    public static void particleRenders(Entity re, PoseStack matrix, float partialTicks) {
        Vec3 proj = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        double d3 = proj.f_82479_;
        double d4 = proj.f_82480_;
        double d5 = proj.f_82481_;
        HashSet<Particle> particles = ClientProxy.getNoRenderParticles(Minecraft.m_91087_().f_91061_);
        ArrayList<Particle> orderedFog = new ArrayList<Particle>();
        FogShaderInstance.doDepth = true;
        if (particles != null && particles.size() > 0) {
            for (Particle particle : particles) {
                Particle p;
                if (particle instanceof ParticleLightning) {
                    p = (ParticleLightning)particle;
                    ParticleLightning.renderLightningParticle((ParticleLightning)p, d3, d4, d5, matrix, partialTicks);
                }
                if (particle instanceof ParticleFog) {
                    p = (ParticleFog)particle;
                    orderedFog.add(p);
                }
                if (particle instanceof ParticleMagic) {
                    p = (ParticleMagic)particle;
                    ParticleMagic.renderMagic((ParticleMagic)p, d3, d4, d5, matrix, partialTicks);
                }
                if (!(particle instanceof ParticleSphere)) continue;
                p = (ParticleSphere)particle;
                ParticleSphere.renderParticleSphere((ParticleSphere)p, d3, d4, d5, matrix, partialTicks);
            }
        }
        for (ParticleFog particleFog : orderedFog) {
            ParticleFog.renderFog(particleFog, d3, d4, d5, matrix, partialTicks);
        }
    }

    public static void render(ItemStack stack, boolean m) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        nbt.m_128379_("render", m);
    }

    public static boolean shouldRender(ItemStack stack) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return true;
        }
        if (stack.m_41783_().m_128441_("render")) {
            return stack.m_41783_().m_128471_("render");
        }
        return true;
    }

    public static RenderType renderSpiral(PoseStack matrix, MultiBufferSource buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float lengthen, float innerradius, float texs) {
        matrix.m_85836_();
        Matrix4f positionMatrix = matrix.m_85850_().m_85861_();
        VertexConsumer bb = buffer.m_6299_(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double h2 = height;
        double r2 = radius;
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = texs;
        double ygrow = cy;
        for (int i = 0; i < num_segments + 1; ++i) {
            r2 = innerradius + (radius - innerradius) * ((float)(num_segments - i) / (float)num_segments);
            h2 = height * ((float)(num_segments - i) / (float)num_segments);
            p = r2 + h2 * Math.cos(EffectUtil.toRad(flatness));
            q = h2 * Math.sin(EffectUtil.toRad(flatness));
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = 0.0f;
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.m_85982_(positionMatrix, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(0.0f, 0.0f).m_7120_(lx, ly).m_5752_();
                bb.m_85982_(positionMatrix, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(0.0f, 1.0f).m_7120_(lx, ly).m_5752_();
            }
            double tt = (double)i * theta;
            x = -r2 * Math.sin(tt);
            y = ygrow;
            z = r2 * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = ygrow - q;
            zb = p * Math.cos(tt);
            bb.m_85982_(positionMatrix, (float)x, (float)y, (float)z).m_85950_(r, g, b, a).m_7421_(texx, 0.0f).m_7120_(lx, ly).m_5752_();
            bb.m_85982_(positionMatrix, (float)xb, (float)yb, (float)zb).m_85950_(r, g, b, a).m_7421_(texx, 1.0f).m_7120_(lx, ly).m_5752_();
            ygrow += (double)lengthen;
        }
        matrix.m_85849_();
        return type;
    }

    public static void billboard(PoseStack m, float r, float partialTicks) {
        Entity e = Minecraft.m_91087_().m_91288_();
        if (e != null) {
            float yaw = e.f_19859_ + (e.m_146908_() - e.f_19859_) * partialTicks;
            float pitch = e.f_19860_ + (e.m_146909_() - e.f_19860_) * partialTicks;
            RenderUtils.rotateQ(360.0f - yaw, 0.0f, 1.0f, 0.0f, m);
            RenderUtils.rotateQ(pitch + 90.0f, 1.0f, 0.0f, 0.0f, m);
            RenderUtils.rotateQ(r, 0.0f, 1.0f, 0.0f, m);
        }
    }

    public static Vec3 bezier(double t, Vec3 p0, Vec3 p1, Vec3 p2) {
        double m = (1.0 - t) * (1.0 - t);
        return p1.m_82549_(p0.m_82546_(p1).m_82490_(m)).m_82549_(p2.m_82546_(p1).m_82490_(t * t));
    }
}

